/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.renderers.swt;

import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.ui.SapphireCommands;
import org.eclipse.sapphire.ui.SapphirePropertyEditor;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.assist.internal.PropertyEditorAssistDecorator;
import org.eclipse.sapphire.ui.internal.binding.ComboBinding;
import org.eclipse.sapphire.ui.internal.binding.RadioButtonsGroup;
import org.eclipse.sapphire.ui.internal.binding.RadioButtonsGroupBinding;
import org.eclipse.sapphire.ui.renderers.swt.PropertyEditorRenderer;
import org.eclipse.sapphire.ui.renderers.swt.PropertyEditorRendererFactory;
import org.eclipse.sapphire.ui.renderers.swt.ValuePropertyEditorRenderer;
import org.eclipse.sapphire.ui.util.SwtUtil;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public final class EnumPropertyEditorRenderer
extends ValuePropertyEditorRenderer {
    private Control control;

    public EnumPropertyEditorRenderer(SapphireRenderingContext context, SapphirePropertyEditor part) {
        super(context, part);
    }

    protected void createContents(Composite parent) {
        SapphirePropertyEditor part = this.getPart();
        ValueProperty property = (ValueProperty)part.getProperty();
        boolean showLabel = part.getRenderingHint("show.label", true);
        int baseIndent = part.getLeftMarginHint();
        boolean preferVerticalRadioButtonBinding = part.getRenderingHint("prefer.vertical.radio.buttons", false);
        boolean preferRadioButtonBinding = part.getRenderingHint("prefer.radio.buttons", false);
        boolean preferComboBinding = part.getRenderingHint("prefer.combo", false);
        if (preferVerticalRadioButtonBinding && !showLabel) {
            showLabel = true;
        }
        int hspan = showLabel && !preferVerticalRadioButtonBinding ? 1 : 2;
        Enum[] enumValues = (Enum[])property.getTypeClass().getEnumConstants();
        Label labelControl = null;
        PropertyEditorAssistDecorator decorator = null;
        if (showLabel) {
            String labelText = property.getLabel(false, CapitalizationType.FIRST_WORD_ONLY, true);
            if (preferVerticalRadioButtonBinding) {
                Composite composite = new Composite(parent, 0);
                composite.setLayoutData((Object)SwtUtil.hspan(SwtUtil.gdhfill(), hspan));
                composite.setLayout((Layout)SwtUtil.glspacing(SwtUtil.glayout(2, 0, 0), 2));
                this.context.adapt((Control)composite);
                decorator = new PropertyEditorAssistDecorator(part, this.context, composite);
                decorator.getControl().setLayoutData((Object)SwtUtil.valign(SwtUtil.gd(), 0x1000000));
                Label label = new Label(composite, 64);
                label.setLayoutData((Object)SwtUtil.gd());
                label.setText(labelText);
                labelControl = label;
                decorator.addEditorControl((Control)composite);
                decorator.addEditorControl((Control)label);
            } else {
                Label label = new Label(parent, 0);
                label.setLayoutData((Object)SwtUtil.gdhindent(SwtUtil.gd(), baseIndent + 9));
                label.setText(String.valueOf(labelText) + ":");
                this.context.adapt((Control)label);
                labelControl = label;
            }
        }
        if (preferVerticalRadioButtonBinding) {
            RadioButtonsGroup buttonsGroup = new RadioButtonsGroup(this.context, parent, true);
            buttonsGroup.setLayoutData(SwtUtil.gdhindent(SwtUtil.hspan(SwtUtil.gdhfill(), hspan), baseIndent + 20));
            this.context.adapt((Control)buttonsGroup);
            this.control = buttonsGroup;
        } else {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)SwtUtil.glspacing(SwtUtil.glayout(2, 0, 0), 2));
            this.context.adapt((Control)composite);
            decorator = new PropertyEditorAssistDecorator(part, this.context, composite);
            decorator.addEditorControl((Control)composite);
            if (preferRadioButtonBinding || enumValues.length <= 3 && !preferComboBinding) {
                composite.setLayoutData((Object)SwtUtil.hspan(SwtUtil.gd(), hspan));
                decorator.getControl().setLayoutData((Object)SwtUtil.valign(SwtUtil.gd(), 0x1000000));
                RadioButtonsGroup buttonsGroup = new RadioButtonsGroup(this.context, composite, false);
                buttonsGroup.setLayoutData(SwtUtil.gdhfill());
                this.context.adapt((Control)buttonsGroup);
                this.control = buttonsGroup;
            } else {
                int whint = part.getRenderingHint("width", -1);
                composite.setLayoutData((Object)SwtUtil.hspan(whint == -1 ? SwtUtil.gdhfill() : SwtUtil.gdwhint(SwtUtil.gd(), whint), hspan));
                decorator.getControl().setLayoutData((Object)SwtUtil.valign(SwtUtil.gd(), 128));
                Combo c = new Combo(composite, 2060);
                c.setLayoutData((Object)SwtUtil.gdhfill());
                c.setVisibleItemCount(10);
                this.context.adapt((Control)c);
                SapphireCommands.configurePropertyEditorContext((Control)c);
                this.control = c;
            }
        }
        this.control.setData("assist-decorator", (Object)decorator);
        if (labelControl != null) {
            this.control.setData("related-controls", (Object)labelControl);
        }
        this.binding = this.control instanceof RadioButtonsGroup ? new RadioButtonsGroupBinding(this.getModelElement(), property, this.context, (RadioButtonsGroup)this.control) : new ComboBinding(this.getModelElement(), property, this.context, (Combo)this.control);
        this.control.setData("binding", (Object)this.binding);
        decorator.addEditorControl(this.control);
        this.addControl(this.control);
    }

    protected void handleFocusReceivedEvent() {
        this.control.setFocus();
    }

    public static final class Factory
    extends PropertyEditorRendererFactory {
        public boolean isApplicableTo(SapphirePropertyEditor propertyEditorDefinition) {
            ModelProperty property = propertyEditorDefinition.getProperty();
            return property instanceof ValueProperty && property.isOfType(Enum.class);
        }

        public PropertyEditorRenderer create(SapphireRenderingContext context, SapphirePropertyEditor part) {
            return new EnumPropertyEditorRenderer(context, part);
        }
    }
}

