/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.renderers.swt;

import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelElementListener;
import org.eclipse.sapphire.modeling.ModelPropertyChangeEvent;
import org.eclipse.sapphire.ui.SapphirePropertyEditor;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.renderers.swt.PropertyEditorRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ListPropertyEditorRenderer
extends PropertyEditorRenderer {
    private ModelElementListener listElementListener = new ModelElementListener(){

        public void propertyChanged(ModelPropertyChangeEvent event) {
            ListPropertyEditorRenderer.this.handleListElementChangedEvent(event);
        }
    };

    public ListPropertyEditorRenderer(SapphireRenderingContext context, SapphirePropertyEditor part) {
        super(context, part);
        this.attachListElementListener();
    }

    public ListProperty getProperty() {
        return (ListProperty)super.getProperty();
    }

    public final ModelElementList<IModelElement> getList() {
        IModelElement modelElement = this.getModelElement();
        if (modelElement != null) {
            return (ModelElementList)this.getProperty().invokeGetterMethod((Object)modelElement);
        }
        return null;
    }

    @Override
    protected void handlePropertyChangedEvent() {
        super.handlePropertyChangedEvent();
        this.attachListElementListener();
    }

    protected void handleListElementChangedEvent(ModelPropertyChangeEvent event) {
    }

    @Override
    protected void handleDisposeEvent() {
        ModelElementList<IModelElement> list = this.getList();
        if (list != null) {
            for (IModelElement entry : list) {
                entry.removeListener(this.listElementListener);
            }
        }
    }

    private void attachListElementListener() {
        ModelElementList<IModelElement> list = this.getList();
        if (list != null) {
            for (IModelElement entry : list) {
                entry.addListener(this.listElementListener);
            }
        }
    }
}

