/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.renderers.swt;

import org.eclipse.sapphire.modeling.EditFailedException;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.ui.DelayedTasksExecutor;
import org.eclipse.sapphire.ui.SapphirePropertyEditor;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.sapphire.ui.renderers.swt.PropertyEditorRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ValuePropertyEditorRenderer
extends PropertyEditorRenderer {
    private final ModifyPropertyValueTask modifyPropertyTask = new ModifyPropertyValueTask();

    public ValuePropertyEditorRenderer(SapphireRenderingContext context, SapphirePropertyEditor part) {
        super(context, part);
    }

    public final ValueProperty getProperty() {
        return (ValueProperty)super.getProperty();
    }

    protected final <T> Value<T> getPropertyValue() {
        return (Value)this.getProperty().invokeGetterMethod((Object)this.getModelElement());
    }

    protected final void setPropertyValue(String value) {
        this.setPropertyValue(value, true);
    }

    protected final void setPropertyValue(String value, boolean async) {
        if (async) {
            this.modifyPropertyTask.setValue(value);
            DelayedTasksExecutor.schedule(this.modifyPropertyTask);
        } else {
            boolean rollback = false;
            try {
                this.getProperty().invokeSetterMethod((Object)this.getModelElement(), (Object)value);
            }
            catch (Exception e) {
                EditFailedException editFailedException = EditFailedException.findAsCause((Throwable)e);
                if (editFailedException != null) {
                    rollback = true;
                }
                SapphireUiFrameworkPlugin.log(e);
            }
            if (rollback) {
                this.handlePropertyChangedEvent();
            }
        }
    }

    private final class ModifyPropertyValueTask
    extends DelayedTasksExecutor.Task {
        private String value = null;

        private ModifyPropertyValueTask() {
        }

        public synchronized String getValue() {
            return this.value;
        }

        public synchronized void setValue(String value) {
            this.value = value;
        }

        public int getPriority() {
            return 100;
        }

        public void run() {
            ValuePropertyEditorRenderer.this.setPropertyValue(this.getValue(), false);
        }
    }
}

