/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.util;

import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.sapphire.ui.renderers.swt.ColumnSortComparator;
import org.eclipse.sapphire.ui.util.internal.MutableReference;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SwtUtil {
    public static final GridLayout glayout(int columns) {
        return new GridLayout(columns, false);
    }

    public static final GridLayout glayout(int columns, int marginWidth, int marginHeight) {
        GridLayout layout = new GridLayout(columns, false);
        layout.marginWidth = marginWidth;
        layout.marginHeight = marginHeight;
        return layout;
    }

    public static final GridLayout glayout(int columns, int leftMargin, int rightMargin, int topMargin, int bottomMargin) {
        GridLayout layout = new GridLayout(columns, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginLeft = leftMargin;
        layout.marginRight = rightMargin;
        layout.marginTop = topMargin;
        layout.marginBottom = bottomMargin;
        return layout;
    }

    public static final GridLayout glspacing(GridLayout layout, int spacing) {
        layout.horizontalSpacing = spacing;
        layout.verticalSpacing = spacing;
        return layout;
    }

    public static final GridData gd() {
        return new GridData();
    }

    public static final GridData gdfill() {
        return new GridData(4, 4, true, true);
    }

    public static final GridData gdhfill() {
        return new GridData(768);
    }

    public static final GridData gdvfill() {
        return new GridData(1040);
    }

    public static final GridData gdhhint(GridData gd, int heightHint) {
        gd.heightHint = heightHint;
        return gd;
    }

    public static final GridData gdwhint(GridData gd, int widthHint) {
        gd.widthHint = widthHint;
        return gd;
    }

    public static final GridData gdhindent(GridData gd, int horizontalIndent) {
        gd.horizontalIndent = horizontalIndent;
        return gd;
    }

    public static final GridData gdvindent(GridData gd, int verticalIndent) {
        gd.verticalIndent = verticalIndent;
        return gd;
    }

    public static final GridData hspan(GridData gd, int span) {
        gd.horizontalSpan = span;
        return gd;
    }

    public static final GridData vspan(GridData gd, int span) {
        gd.verticalSpan = span;
        return gd;
    }

    public static final GridData halign(GridData gd, int alignment) {
        gd.horizontalAlignment = alignment;
        return gd;
    }

    public static final GridData valign(GridData gd, int alignment) {
        gd.verticalAlignment = alignment;
        return gd;
    }

    public static Color color(int id) {
        return Display.getCurrent().getSystemColor(id);
    }

    public static final int getPreferredWidth(Control control) {
        return control.computeSize((int)-1, (int)-1).x;
    }

    public static Shell getActiveShell() {
        if (PlatformUI.isWorkbenchRunning()) {
            final IWorkbench workbench = PlatformUI.getWorkbench();
            Display display = workbench.getDisplay();
            final Shell[] result = new Shell[1];
            display.syncExec(new Runnable(){

                public void run() {
                    IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                    result[0] = window != null ? window.getShell() : null;
                }
            });
            return result[0];
        }
        return null;
    }

    public static boolean hasModalShell(final Display display) {
        if (display.isDisposed()) {
            return false;
        }
        final MutableReference result = new MutableReference();
        display.syncExec(new Runnable(){

            public void run() {
                result.set(Boolean.FALSE);
                Shell[] shellArray = display.getShells();
                int n = shellArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Shell shell = shellArray[n2];
                    if (!shell.isDisposed() && shell.isVisible() && (shell.getStyle() & 0x10000) != 0) {
                        result.set(Boolean.TRUE);
                        break;
                    }
                    ++n2;
                }
            }
        });
        return (Boolean)result.get();
    }

    public static void waitOnModalShells() {
        Display display = PlatformUI.getWorkbench().getDisplay();
        while (SwtUtil.hasModalShell(display)) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static void setEnabledOnChildren(Composite composite, boolean enabled) {
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.setEnabled(enabled);
            ++n2;
        }
    }

    public static void runOnDisplayThread(Display display, Runnable runnable) {
        if (display.getThread() == Thread.currentThread()) {
            runnable.run();
        } else {
            display.asyncExec(runnable);
        }
    }

    public static TreeItem getTreeItem(Tree tree, int x, int y) {
        return SwtUtil.getTreeItem(tree.getItems(), x, y);
    }

    private static TreeItem getTreeItem(TreeItem[] items, int x, int y) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            Rectangle bounds = item.getBounds();
            bounds.add(new Rectangle(bounds.x - 25, bounds.y, 25, bounds.height));
            if (bounds.contains(x, y)) {
                return item;
            }
            TreeItem res = SwtUtil.getTreeItem(item.getItems(), x, y);
            if (res != null) {
                return res;
            }
            ++n2;
        }
        return null;
    }

    public static void makeTableSortable(TableViewer tableViewer) {
        Map<TableColumn, Comparator<Object>> comparators = Collections.emptyMap();
        SwtUtil.makeTableSortable(tableViewer, comparators, tableViewer.getTable().getColumn(0), 1024);
    }

    public static void makeTableSortable(TableViewer tableViewer, Map<TableColumn, Comparator<Object>> comparators) {
        SwtUtil.makeTableSortable(tableViewer, comparators, tableViewer.getTable().getColumn(0), 1024);
    }

    public static void makeTableSortable(final TableViewer tableViewer, Map<TableColumn, Comparator<Object>> comparators, TableColumn initialSortColumn, int initialSortDirection) {
        final Table table = tableViewer.getTable();
        SwtUtil.sortByTableColumn(tableViewer, initialSortColumn, initialSortDirection, comparators.get(initialSortColumn));
        TableColumn[] tableColumnArray = table.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            final TableColumn column = tableColumnArray[n2];
            final Comparator<Object> comparator = comparators.get(column);
            column.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    TableColumn currentSortColumn = table.getSortColumn();
                    if (currentSortColumn != column) {
                        SwtUtil.sortByTableColumn(tableViewer, column, 1024, comparator);
                    } else {
                        int currentSortDirection = table.getSortDirection();
                        if (currentSortDirection == 1024) {
                            SwtUtil.sortByTableColumn(tableViewer, column, 128, comparator);
                        } else {
                            table.setSortColumn(null);
                            tableViewer.setComparator(null);
                        }
                    }
                }
            });
            ++n2;
        }
    }

    public static void sortByTableColumn(TableViewer tableViewer, TableColumn column, final int direction, Comparator<Object> comparator) {
        Table table = tableViewer.getTable();
        table.setSortColumn(column);
        table.setSortDirection(direction);
        final ColumnSortComparator comp = comparator != null ? comparator : new ColumnSortComparator();
        tableViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object x, Object y) {
                int result = comp.compare(x, y);
                if (direction == 128) {
                    result *= -1;
                }
                return result;
            }
        });
    }
}

