/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.calendar.integrated.internal;

import org.eclipse.sapphire.modeling.IModel;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ModelElement;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.serialization.ValueSerializationService;
import org.eclipse.sapphire.samples.calendar.AttendeeType;
import org.eclipse.sapphire.samples.calendar.integrated.IAttendee;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AttendeeStub
extends ModelElement
implements IAttendee {
    private Value<String> eMail = null;
    private Value<Boolean> inContactsDatabase = null;
    private Value<String> name = null;
    private Value<AttendeeType> type = null;

    public AttendeeStub(IModelParticle parent, ModelProperty parentProperty) {
        super(TYPE, parent, parentProperty);
    }

    protected abstract String readEMail();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getEMail() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.eMail == null) {
                this.refresh((ModelProperty)PROP_E_MAIL, true);
            }
            return this.eMail;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEMail(String value) {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_E_MAIL.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_E_MAIL, true);
            if (!AttendeeStub.equal((String)this.eMail.getText(false), (String)value)) {
                this.validateEdit();
                this.writeEMail(value);
                this.refresh((ModelProperty)PROP_E_MAIL, false);
            }
        }
    }

    protected abstract void writeEMail(String var1);

    protected abstract String readInContactsDatabase();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<Boolean> isInContactsDatabase() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.inContactsDatabase == null) {
                this.refresh((ModelProperty)PROP_IN_CONTACTS_DATABASE, true);
            }
            return this.inContactsDatabase;
        }
    }

    protected abstract String readName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getName() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.name == null) {
                this.refresh((ModelProperty)PROP_NAME, true);
            }
            return this.name;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setName(String value) {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_NAME.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_NAME, true);
            if (!AttendeeStub.equal((String)this.name.getText(false), (String)value)) {
                this.validateEdit();
                this.writeName(value);
                this.refresh((ModelProperty)PROP_NAME, false);
            }
        }
    }

    protected abstract void writeName(String var1);

    protected abstract String readType();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<AttendeeType> getType() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.type == null) {
                this.refresh((ModelProperty)PROP_TYPE, true);
            }
            return this.type;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setType(String value) {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_TYPE.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_TYPE, true);
            if (!AttendeeStub.equal((String)this.type.getText(false), (String)value)) {
                this.validateEdit();
                this.writeType(value);
                this.refresh((ModelProperty)PROP_TYPE, false);
            }
        }
    }

    protected abstract void writeType(String var1);

    @Override
    public void setType(AttendeeType value) {
        this.setType(value != null ? ((ValueSerializationService)this.service(ValueSerializationService.class)).encode(PROP_TYPE, (Object)value) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModel iModel = this.model;
        synchronized (iModel) {
            property = property.refine((IModelElement)this);
            if (property == PROP_E_MAIL) {
                if (this.eMail != null || force) {
                    Value<String> oldValue = this.eMail;
                    String val = this.readEMail();
                    this.eMail = new Value((IModelElement)this, PROP_E_MAIL, PROP_E_MAIL.encodeKeywords(val));
                    this.eMail.init();
                    boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_E_MAIL);
                    if (oldValue != null) {
                        if (this.eMail.equals(oldValue)) {
                            this.eMail = oldValue;
                        }
                        if (this.eMail != oldValue || propertyEnabledStatusChanged) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_E_MAIL);
                        }
                    }
                }
            } else if (property == PROP_IN_CONTACTS_DATABASE) {
                if (this.inContactsDatabase != null || force) {
                    Value<Boolean> oldValue = this.inContactsDatabase;
                    String val = this.readInContactsDatabase();
                    this.inContactsDatabase = new Value((IModelElement)this, PROP_IN_CONTACTS_DATABASE, PROP_IN_CONTACTS_DATABASE.encodeKeywords(val));
                    this.inContactsDatabase.init();
                    boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_IN_CONTACTS_DATABASE);
                    if (oldValue != null) {
                        if (this.inContactsDatabase.equals(oldValue)) {
                            this.inContactsDatabase = oldValue;
                        }
                        if (this.inContactsDatabase != oldValue || propertyEnabledStatusChanged) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_IN_CONTACTS_DATABASE);
                        }
                    }
                }
            } else if (property == PROP_NAME) {
                if (this.name != null || force) {
                    Value<String> oldValue = this.name;
                    String val = this.readName();
                    this.name = new Value((IModelElement)this, PROP_NAME, PROP_NAME.encodeKeywords(val));
                    this.name.init();
                    boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_NAME);
                    if (oldValue != null) {
                        if (this.name.equals(oldValue)) {
                            this.name = oldValue;
                        }
                        if (this.name != oldValue || propertyEnabledStatusChanged) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_NAME);
                        }
                    }
                }
            } else if (property == PROP_TYPE && (this.type != null || force)) {
                Value<AttendeeType> oldValue = this.type;
                String val = this.readType();
                this.type = new Value((IModelElement)this, PROP_TYPE, PROP_TYPE.encodeKeywords(val));
                this.type.init();
                boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_TYPE);
                if (oldValue != null) {
                    if (this.type.equals(oldValue)) {
                        this.type = oldValue;
                    }
                    if (this.type != oldValue || propertyEnabledStatusChanged) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_TYPE);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() {
        IModel iModel = this.model;
        synchronized (iModel) {
            this.validateEdit();
            this.doRemove();
        }
        IModelParticle parent = this.getParent();
        if (parent != null) {
            if (parent instanceof ModelElementList) {
                ((ModelElementList)parent).handleElementRemovedEvent();
            } else {
                ((IModelElement)parent).refresh(this.getParentProperty());
            }
        }
    }

    protected abstract void doRemove();
}

