/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.calendar.internal;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.sapphire.modeling.IModel;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.serialization.ValueSerializationService;
import org.eclipse.sapphire.modeling.xml.ModelElementForXml;
import org.eclipse.sapphire.modeling.xml.ModelStoreForXml;
import org.eclipse.sapphire.modeling.xml.StandardXmlNamespaceResolver;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlNamespaceResolver;
import org.eclipse.sapphire.modeling.xml.XmlNode;
import org.eclipse.sapphire.modeling.xml.XmlPath;
import org.eclipse.sapphire.samples.calendar.IEventAttachment;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EventAttachment
extends ModelElementForXml
implements IEventAttachment {
    private static final Map<ModelProperty, XmlPath> MAP_PROP_TO_XML_PATH = new HashMap<ModelProperty, XmlPath>();
    private static final StandardXmlNamespaceResolver NAMESPACE_RESOLVER = new StandardXmlNamespaceResolver(TYPE);
    private static final XmlPath PATH_LOCAL_COPY_LOCATION = new XmlPath("local-copy", (XmlNamespaceResolver)NAMESPACE_RESOLVER);
    private static final XmlPath PATH_PUBLIC_COPY_LOCATION = new XmlPath("public-copy", (XmlNamespaceResolver)NAMESPACE_RESOLVER);
    private Value<IPath> localCopyLocation = null;
    private Value<URL> publicCopyLocation = null;

    static {
        MAP_PROP_TO_XML_PATH.put((ModelProperty)PROP_LOCAL_COPY_LOCATION, PATH_LOCAL_COPY_LOCATION);
        MAP_PROP_TO_XML_PATH.put((ModelProperty)PROP_PUBLIC_COPY_LOCATION, PATH_PUBLIC_COPY_LOCATION);
    }

    public EventAttachment(IModelParticle parent, ModelProperty parentProperty, XmlElement element) {
        super(TYPE, parent, parentProperty, element);
        ((ModelStoreForXml)this.getModel().getModelStore()).registerModelElement((Node)element.getDomNode(), (IModelElement)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<IPath> getLocalCopyLocation() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.localCopyLocation == null) {
                this.refresh((ModelProperty)PROP_LOCAL_COPY_LOCATION, true);
            }
            return this.localCopyLocation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLocalCopyLocation(String value) {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_LOCAL_COPY_LOCATION.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_LOCAL_COPY_LOCATION, true);
            if (!EventAttachment.equal((String)this.localCopyLocation.getText(false), (String)value)) {
                this.validateEdit();
                this.getXmlElement(true).setChildNodeText(PATH_LOCAL_COPY_LOCATION, value, true);
                this.refresh((ModelProperty)PROP_LOCAL_COPY_LOCATION, false);
            }
        }
    }

    @Override
    public void setLocalCopyLocation(IPath value) {
        this.setLocalCopyLocation(value != null ? ((ValueSerializationService)this.service(ValueSerializationService.class)).encode(PROP_LOCAL_COPY_LOCATION, (Object)value) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<URL> getPublicCopyLocation() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.publicCopyLocation == null) {
                this.refresh((ModelProperty)PROP_PUBLIC_COPY_LOCATION, true);
            }
            return this.publicCopyLocation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPublicCopyLocation(String value) {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_PUBLIC_COPY_LOCATION.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_PUBLIC_COPY_LOCATION, true);
            if (!EventAttachment.equal((String)this.publicCopyLocation.getText(false), (String)value)) {
                this.validateEdit();
                this.getXmlElement(true).setChildNodeText(PATH_PUBLIC_COPY_LOCATION, value, true);
                this.refresh((ModelProperty)PROP_PUBLIC_COPY_LOCATION, false);
            }
        }
    }

    @Override
    public void setPublicCopyLocation(URL value) {
        this.setPublicCopyLocation(value != null ? ((ValueSerializationService)this.service(ValueSerializationService.class)).encode(PROP_PUBLIC_COPY_LOCATION, (Object)value) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModel iModel = this.model;
        synchronized (iModel) {
            property = property.refine((IModelElement)this);
            if (property == PROP_LOCAL_COPY_LOCATION) {
                if (this.localCopyLocation != null || force) {
                    Value<IPath> oldValue = this.localCopyLocation;
                    XmlElement element = this.getXmlElement(false);
                    String val = element == null ? null : element.getChildNodeText(PATH_LOCAL_COPY_LOCATION, false);
                    this.localCopyLocation = new Value((IModelElement)this, PROP_LOCAL_COPY_LOCATION, PROP_LOCAL_COPY_LOCATION.encodeKeywords(val));
                    this.localCopyLocation.init();
                    boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_LOCAL_COPY_LOCATION);
                    if (oldValue != null) {
                        if (this.localCopyLocation.equals(oldValue)) {
                            this.localCopyLocation = oldValue;
                        }
                        if (this.localCopyLocation != oldValue || propertyEnabledStatusChanged) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_LOCAL_COPY_LOCATION);
                        }
                    }
                }
            } else if (property == PROP_PUBLIC_COPY_LOCATION && (this.publicCopyLocation != null || force)) {
                Value<URL> oldValue = this.publicCopyLocation;
                XmlElement element = this.getXmlElement(false);
                String val = element == null ? null : element.getChildNodeText(PATH_PUBLIC_COPY_LOCATION, false);
                this.publicCopyLocation = new Value((IModelElement)this, PROP_PUBLIC_COPY_LOCATION, PROP_PUBLIC_COPY_LOCATION.encodeKeywords(val));
                this.publicCopyLocation.init();
                boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_PUBLIC_COPY_LOCATION);
                if (oldValue != null) {
                    if (this.publicCopyLocation.equals(oldValue)) {
                        this.publicCopyLocation = oldValue;
                    }
                    if (this.publicCopyLocation != oldValue || propertyEnabledStatusChanged) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_PUBLIC_COPY_LOCATION);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() {
        IModel iModel = this.model;
        synchronized (iModel) {
            XmlElement element = this.getXmlElement(false);
            if (element != null) {
                this.validateEdit();
                element.remove();
            }
        }
        IModelParticle parent = this.getParent();
        if (parent != null) {
            if (parent instanceof ModelElementList) {
                ((ModelElementList)parent).handleElementRemovedEvent();
            } else {
                ((IModelElement)parent).refresh(this.getParentProperty());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlNode getXmlNode(ModelProperty property) {
        IModel iModel = this.model;
        synchronized (iModel) {
            XmlPath path;
            property = property.refine((IModelElement)this);
            XmlElement el = this.getXmlElement(false);
            if (el != null && (path = MAP_PROP_TO_XML_PATH.get(property)) != null) {
                return el.getChildNode(path, false);
            }
            return null;
        }
    }
}

