/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.calendar.ui;

import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.samples.calendar.integrated.IAttendee;
import org.eclipse.sapphire.samples.calendar.ui.CalendarEditor;
import org.eclipse.sapphire.samples.contacts.IContact;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.assist.JumpHandler;
import org.eclipse.sapphire.ui.editor.views.masterdetails.MasterDetailsContentNode;
import org.eclipse.sapphire.ui.editor.views.masterdetails.MasterDetailsContentTree;
import org.eclipse.sapphire.ui.editor.views.masterdetails.MasterDetailsPage;

public final class ContactDetailsJumpHandler
extends JumpHandler {
    public boolean isApplicable(ValueProperty property) {
        return true;
    }

    public boolean canLocateJumpTarget(SapphirePart part, SapphireRenderingContext context, IModelElement modelElement, ValueProperty property) {
        IAttendee attendee = (IAttendee)modelElement;
        return (Boolean)attendee.isInContactsDatabase().getContent();
    }

    public void jump(SapphirePart part, SapphireRenderingContext context, IModelElement modelElement, ValueProperty property) {
        CalendarEditor editor = (CalendarEditor)((Object)part.getNearestPart(CalendarEditor.class));
        ContactDetailsJumpHandler.jump(editor, modelElement);
    }

    public static void jump(CalendarEditor editor, IModelElement modelElement) {
        IAttendee attendee = (IAttendee)modelElement;
        String name = attendee.getName().getText();
        if (name != null) {
            MasterDetailsPage contactsFormPage;
            MasterDetailsContentTree content;
            MasterDetailsContentNode contactNode;
            IContact contact = null;
            for (IContact c : editor.getContactsDatabase().getContacts()) {
                if (!name.equals(c.getName().getText())) continue;
                contact = c;
                break;
            }
            if (contact != null && (contactNode = ContactDetailsJumpHandler.findContactNode((content = (contactsFormPage = (MasterDetailsPage)editor.getPage("Contacts")).getContentTree()).getRoot(), contact)) != null) {
                contactNode.select();
                editor.showPage("Contacts");
            }
        }
    }

    private static MasterDetailsContentNode findContactNode(MasterDetailsContentNode node, IContact contact) {
        if (node.getModelElement() == contact) {
            return node;
        }
        for (MasterDetailsContentNode child : node.getChildNodes()) {
            MasterDetailsContentNode res = ContactDetailsJumpHandler.findContactNode(child, contact);
            if (res == null) continue;
            return res;
        }
        return null;
    }
}

