/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.contacts.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.sapphire.modeling.IModel;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelElementListController;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.xml.ModelElementForXml;
import org.eclipse.sapphire.modeling.xml.ModelElementListControllerForXml;
import org.eclipse.sapphire.modeling.xml.ModelStoreForXml;
import org.eclipse.sapphire.modeling.xml.StandardXmlNamespaceResolver;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlNamespaceResolver;
import org.eclipse.sapphire.modeling.xml.XmlNode;
import org.eclipse.sapphire.modeling.xml.XmlPath;
import org.eclipse.sapphire.samples.contacts.IAssistant;
import org.eclipse.sapphire.samples.contacts.IAssistantTask;
import org.eclipse.sapphire.samples.contacts.internal.AssistantTask;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Assistant
extends ModelElementForXml
implements IAssistant {
    private static final Map<ModelProperty, XmlPath> MAP_PROP_TO_XML_PATH = new HashMap<ModelProperty, XmlPath>();
    private static final StandardXmlNamespaceResolver NAMESPACE_RESOLVER = new StandardXmlNamespaceResolver(TYPE);
    private static final XmlPath PATH_NAME = new XmlPath("name", (XmlNamespaceResolver)NAMESPACE_RESOLVER);
    private static final XmlPath PATH_NOTES = new XmlPath("notes", (XmlNamespaceResolver)NAMESPACE_RESOLVER);
    private ModelElementList<IAssistantTask> delegatedTasks = null;
    private Value<String> name = null;
    private Value<String> notes = null;

    static {
        MAP_PROP_TO_XML_PATH.put((ModelProperty)PROP_NAME, PATH_NAME);
        MAP_PROP_TO_XML_PATH.put((ModelProperty)PROP_NOTES, PATH_NOTES);
    }

    public Assistant(IModelParticle parent, ModelProperty parentProperty, XmlElement element) {
        super(TYPE, parent, parentProperty, element);
        ((ModelStoreForXml)this.getModel().getModelStore()).registerModelElement((Node)element.getDomNode(), (IModelElement)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementList<IAssistantTask> getDelegatedTasks() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.delegatedTasks == null) {
                this.refresh((ModelProperty)PROP_DELEGATED_TASKS, true);
            }
            return this.delegatedTasks;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getName() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.name == null) {
                this.refresh((ModelProperty)PROP_NAME, true);
            }
            return this.name;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setName(String value) {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_NAME.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_NAME, true);
            if (!Assistant.equal((String)this.name.getText(false), (String)value)) {
                this.validateEdit();
                this.getXmlElement(true).setChildNodeText(PATH_NAME, value, true);
                this.refresh((ModelProperty)PROP_NAME, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getNotes() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.notes == null) {
                this.refresh((ModelProperty)PROP_NOTES, true);
            }
            return this.notes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNotes(String value) {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_NOTES.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_NOTES, true);
            if (!Assistant.equal((String)this.notes.getText(false), (String)value)) {
                this.validateEdit();
                this.getXmlElement(true).setChildNodeText(PATH_NOTES, value, true);
                this.refresh((ModelProperty)PROP_NOTES, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModel iModel = this.model;
        synchronized (iModel) {
            property = property.refine((IModelElement)this);
            if (property == PROP_DELEGATED_TASKS) {
                boolean notified;
                boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_DELEGATED_TASKS);
                if (this.delegatedTasks == null && force) {
                    this.delegatedTasks = new ModelElementList((IModelElement)this, PROP_DELEGATED_TASKS);
                    final Map<ModelElementType, String> typeToElementName = Collections.singletonMap(IAssistantTask.TYPE, "task");
                    ModelElementListControllerForXml<IAssistantTask> controller = new ModelElementListControllerForXml<IAssistantTask>(typeToElementName.values()){

                        protected IAssistantTask wrap(XmlElement element) {
                            return new AssistantTask((IModelParticle)this.getList(), (ModelProperty)PROP_DELEGATED_TASKS, element);
                        }

                        public IAssistantTask createNewElement(ModelElementType type) {
                            this.validateEdit();
                            String elementName = (String)typeToElementName.get(type);
                            return this.wrap(this.getParentXmlElement(true).addChildElement(elementName));
                        }

                        protected XmlElement getParentXmlElement(boolean createIfNecessary) {
                            return Assistant.this.getXmlElement(createIfNecessary);
                        }
                    };
                    controller.init((IModelElement)this, PROP_DELEGATED_TASKS, this.delegatedTasks, new String[0]);
                    this.delegatedTasks.init((ModelElementListController)controller);
                }
                if (this.delegatedTasks != null && !(notified = this.delegatedTasks.refresh()) && propertyEnabledStatusChanged) {
                    this.notifyPropertyChangeListeners((ModelProperty)PROP_DELEGATED_TASKS);
                }
            } else if (property == PROP_NAME) {
                if (this.name != null || force) {
                    Value<String> oldValue = this.name;
                    XmlElement element = this.getXmlElement(false);
                    String val = element == null ? null : element.getChildNodeText(PATH_NAME, false);
                    this.name = new Value((IModelElement)this, PROP_NAME, PROP_NAME.encodeKeywords(val));
                    this.name.init();
                    boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_NAME);
                    if (oldValue != null) {
                        if (this.name.equals(oldValue)) {
                            this.name = oldValue;
                        }
                        if (this.name != oldValue || propertyEnabledStatusChanged) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_NAME);
                        }
                    }
                }
            } else if (property == PROP_NOTES && (this.notes != null || force)) {
                Value<String> oldValue = this.notes;
                XmlElement element = this.getXmlElement(false);
                String val = element == null ? null : element.getChildNodeText(PATH_NOTES, false);
                this.notes = new Value((IModelElement)this, PROP_NOTES, PROP_NOTES.encodeKeywords(val));
                this.notes.init();
                boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_NOTES);
                if (oldValue != null) {
                    if (this.notes.equals(oldValue)) {
                        this.notes = oldValue;
                    }
                    if (this.notes != oldValue || propertyEnabledStatusChanged) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_NOTES);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() {
        IModel iModel = this.model;
        synchronized (iModel) {
            XmlElement element = this.getXmlElement(false);
            if (element != null) {
                this.validateEdit();
                element.remove();
            }
        }
        IModelParticle parent = this.getParent();
        if (parent != null) {
            if (parent instanceof ModelElementList) {
                ((ModelElementList)parent).handleElementRemovedEvent();
            } else {
                ((IModelElement)parent).refresh(this.getParentProperty());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlNode getXmlNode(ModelProperty property) {
        IModel iModel = this.model;
        synchronized (iModel) {
            XmlPath path;
            property = property.refine((IModelElement)this);
            XmlElement el = this.getXmlElement(false);
            if (el != null && (path = MAP_PROP_TO_XML_PATH.get(property)) != null) {
                return el.getChildNode(path, false);
            }
            return null;
        }
    }
}

