/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.ezbug.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.sapphire.modeling.IModel;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.xml.ModelForXml;
import org.eclipse.sapphire.modeling.xml.ModelStoreForXml;
import org.eclipse.sapphire.modeling.xml.RootElementController;
import org.eclipse.sapphire.modeling.xml.StandardRootElementController;
import org.eclipse.sapphire.modeling.xml.StandardXmlNamespaceResolver;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlNamespaceResolver;
import org.eclipse.sapphire.modeling.xml.XmlNode;
import org.eclipse.sapphire.modeling.xml.XmlPath;
import org.eclipse.sapphire.samples.ezbug.IBugReport;
import org.eclipse.sapphire.samples.ezbug.IFileBugReportOp;
import org.eclipse.sapphire.samples.ezbug.internal.BugReport;
import org.eclipse.sapphire.samples.ezbug.internal.FileBugReportOpMethods;

public final class FileBugReportOp
extends ModelForXml
implements IFileBugReportOp {
    private static final Map<ModelProperty, XmlPath> MAP_PROP_TO_XML_PATH = new HashMap<ModelProperty, XmlPath>();
    private static final StandardXmlNamespaceResolver NAMESPACE_RESOLVER = new StandardXmlNamespaceResolver(TYPE);
    private static final XmlPath PATH_BUG_REPORT = new XmlPath("bug", (XmlNamespaceResolver)NAMESPACE_RESOLVER);
    private IBugReport bugReport = null;
    private boolean bugReportCached = false;
    private XmlElement bugReportElement = null;

    static {
        MAP_PROP_TO_XML_PATH.put((ModelProperty)PROP_BUG_REPORT, PATH_BUG_REPORT);
    }

    public FileBugReportOp(ModelStoreForXml modelStore) {
        super(TYPE, modelStore);
        ((ModelStoreForXml)this.getModel().getModelStore()).registerRootModelElement((IModelElement)this);
    }

    protected RootElementController createRootElementController() {
        return new StandardRootElementController(null, null, null, "report");
    }

    public IBugReport getBugReport() {
        return this.getBugReport(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBugReport getBugReport(boolean createIfNecessary) {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (!this.bugReportCached) {
                this.refresh((ModelProperty)PROP_BUG_REPORT, true);
            }
            if (this.bugReport == null && createIfNecessary) {
                this.validateEdit();
                this.getXmlElement(true).getChildNode(PATH_BUG_REPORT, true);
                this.refresh((ModelProperty)PROP_BUG_REPORT, true);
            }
            return this.bugReport;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus execute(IProgressMonitor monitor) {
        IModel iModel = this.model;
        synchronized (iModel) {
            return FileBugReportOpMethods.execute(this, monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModel iModel = this.model;
        synchronized (iModel) {
            property = property.refine((IModelElement)this);
            if (property == PROP_BUG_REPORT && (this.bugReportCached || force)) {
                XmlNode child;
                this.bugReportCached = true;
                IBugReport element = null;
                XmlElement el = this.getXmlElement(false);
                XmlNode xmlNode = child = el == null ? null : el.getChildNode(PATH_BUG_REPORT, false);
                if (child == null) {
                    this.bugReportElement = null;
                } else if (!child.equals((Object)this.bugReportElement)) {
                    this.bugReportElement = (XmlElement)child;
                    element = new BugReport((IModelParticle)this, (ModelProperty)PROP_BUG_REPORT, this.bugReportElement);
                } else {
                    element = this.bugReport;
                }
                boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_BUG_REPORT);
                if (this.bugReport != element) {
                    if (this.bugReport != null) {
                        this.bugReport.dispose();
                    }
                    this.bugReport = element;
                    this.notifyPropertyChangeListeners((ModelProperty)PROP_BUG_REPORT);
                } else if (propertyEnabledStatusChanged) {
                    this.notifyPropertyChangeListeners((ModelProperty)PROP_BUG_REPORT);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlNode getXmlNode(ModelProperty property) {
        IModel iModel = this.model;
        synchronized (iModel) {
            XmlPath path;
            property = property.refine((IModelElement)this);
            XmlElement el = this.getXmlElement(false);
            if (el != null && (path = MAP_PROP_TO_XML_PATH.get(property)) != null) {
                return el.getChildNode(path, false);
            }
            return null;
        }
    }
}

