/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.gallery.internal;

import java.util.Collections;
import java.util.Map;
import org.eclipse.sapphire.modeling.IModel;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelElementListController;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.xml.IModelElementForXml;
import org.eclipse.sapphire.modeling.xml.ModelElementForXml;
import org.eclipse.sapphire.modeling.xml.ModelElementListControllerForXml;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.samples.gallery.IMultiSelectListGallery;
import org.eclipse.sapphire.samples.gallery.IMultiSelectListGalleryItem;
import org.eclipse.sapphire.samples.gallery.internal.MultiSelectListGalleryItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MultiSelectListGallery
extends ModelElementForXml
implements IMultiSelectListGallery {
    private ModelElementList<IMultiSelectListGalleryItem> list = null;

    public MultiSelectListGallery(IModelParticle parent, ModelProperty parentProperty) {
        super(TYPE, parent, parentProperty, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementList<IMultiSelectListGalleryItem> getList() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.list == null) {
                this.refresh((ModelProperty)PROP_LIST, true);
            }
            return this.list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModel iModel = this.model;
        synchronized (iModel) {
            property = property.refine((IModelElement)this);
            if (property == PROP_LIST) {
                boolean notified;
                boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_LIST);
                if (this.list == null && force) {
                    this.list = new ModelElementList((IModelElement)this, PROP_LIST);
                    final Map<ModelElementType, String> typeToElementName = Collections.singletonMap(IMultiSelectListGalleryItem.TYPE, "item");
                    ModelElementListControllerForXml<IMultiSelectListGalleryItem> controller = new ModelElementListControllerForXml<IMultiSelectListGalleryItem>(typeToElementName.values()){

                        protected IMultiSelectListGalleryItem wrap(XmlElement element) {
                            return new MultiSelectListGalleryItem((IModelParticle)this.getList(), (ModelProperty)PROP_LIST, element);
                        }

                        public IMultiSelectListGalleryItem createNewElement(ModelElementType type) {
                            this.validateEdit();
                            String elementName = (String)typeToElementName.get(type);
                            return this.wrap(this.getParentXmlElement(true).addChildElement(elementName));
                        }

                        protected XmlElement getParentXmlElement(boolean createIfNecessary) {
                            return MultiSelectListGallery.this.getXmlElement(createIfNecessary);
                        }
                    };
                    controller.init((IModelElement)this, PROP_LIST, this.list, new String[0]);
                    this.list.init((ModelElementListController)controller);
                }
                if (this.list != null && !(notified = this.list.refresh()) && propertyEnabledStatusChanged) {
                    this.notifyPropertyChangeListeners((ModelProperty)PROP_LIST);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlElement getXmlElement(boolean createIfNecessary) {
        IModel iModel = this.model;
        synchronized (iModel) {
            XmlElement root = ((IModelElementForXml)this.getParent()).getXmlElement(createIfNecessary);
            if (root != null) {
                root = root.getChildElement("multi-select-list", createIfNecessary);
            }
            return root;
        }
    }
}

