/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.xml;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.sapphire.modeling.ByteArrayModelStore;
import org.eclipse.sapphire.modeling.CorruptedModelStoreExceptionInterceptor;
import org.eclipse.sapphire.modeling.xml.ModelStoreForXml;
import org.eclipse.sapphire.tests.modeling.xml.IXmlBindingTestModel;
import org.eclipse.sapphire.tests.modeling.xml.internal.XmlBindingTestModel;
import org.eclipse.sapphire.tests.modeling.xml.internal.XmlBindingTestModelAltB;
import org.eclipse.sapphire.tests.modeling.xml.internal.XmlBindingTestModelAltC;

public final class XmlBindingTests
extends TestCase {
    private XmlBindingTests(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("XmlBindingTests");
        suite.addTest((Test)new XmlBindingTests("testValueProperties1"));
        suite.addTest((Test)new XmlBindingTests("testValueProperties2"));
        suite.addTest((Test)new XmlBindingTests("testValueProperties3"));
        return suite;
    }

    public void testValueProperties1() throws Exception {
        ByteArrayModelStore modelStore = new ByteArrayModelStore();
        ModelStoreForXml xmlModelStore = new ModelStoreForXml(modelStore);
        XmlBindingTestModel model = new XmlBindingTestModel(xmlModelStore);
        this.testValueProperties(modelStore, model, this.loadResource("testValueProperties1.txt"));
    }

    public void testValueProperties2() throws Exception {
        ByteArrayModelStore modelStore = new ByteArrayModelStore();
        ModelStoreForXml xmlModelStore = new ModelStoreForXml(modelStore);
        XmlBindingTestModelAltB model = new XmlBindingTestModelAltB(xmlModelStore);
        this.testValueProperties(modelStore, model, this.loadResource("testValueProperties2.txt"));
    }

    public void testValueProperties3() throws Exception {
        ByteArrayModelStore modelStore = new ByteArrayModelStore();
        ModelStoreForXml xmlModelStore = new ModelStoreForXml(modelStore);
        XmlBindingTestModelAltC model = new XmlBindingTestModelAltC(xmlModelStore);
        this.testValueProperties(modelStore, model, this.loadResource("testValueProperties3.txt"));
    }

    private void testValueProperties(ByteArrayModelStore modelStore, IXmlBindingTestModel model, String expected) throws Exception {
        model.setCorruptedModelStoreExceptionInterceptor(new CorruptedModelStoreExceptionInterceptor(){

            public boolean shouldAttemptRepair() {
                return true;
            }
        });
        model.setValuePropertyA("aaaa");
        model.setValuePropertyB("bbbb");
        model.setValuePropertyC("cccc");
        model.setValuePropertyD("dddd");
        model.setValuePropertyE("eeee");
        model.setValuePropertyF("ffff");
        model.save();
        String result = new String(modelStore.getContents(), "UTF-8");
        XmlBindingTests.assertEqualsIgnoreNewLineDiffs(expected, result);
    }

    private String loadResource(String name) throws Exception {
        String string;
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("XmlBindingTests." + name);
        if (in == null) {
            throw new IllegalArgumentException(name);
        }
        try {
            BufferedReader r = new BufferedReader(new InputStreamReader(in));
            char[] chars = new char[1024];
            StringBuilder buf = new StringBuilder();
            int i = r.read(chars);
            while (i != -1) {
                buf.append(chars, 0, i);
                i = r.read(chars);
            }
            string = buf.toString();
        }
        catch (Throwable throwable) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            in.close();
        }
        catch (IOException iOException) {}
        return string;
    }

    private static void assertEqualsIgnoreNewLineDiffs(String expected, String actual) {
        XmlBindingTests.assertEquals((String)expected.replace("\r", ""), (String)actual.replace("\r", ""));
    }
}

