/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.UrlResourceStore;
import org.eclipse.sapphire.modeling.localization.LocalizationService;
import org.eclipse.sapphire.modeling.localization.StandardLocalizationService;
import org.osgi.framework.Bundle;

public class BundleResourceStore
extends UrlResourceStore {
    private final String bundleId;
    private final String path;

    public BundleResourceStore(String bundleId, String path) throws ResourceStoreException {
        super(BundleResourceStore.toUrl(bundleId, path, true));
        this.bundleId = bundleId;
        this.path = path;
    }

    public boolean isOutOfDate() {
        return false;
    }

    protected LocalizationService initLocalizationService(Locale locale) {
        return new StandardLocalizationService(locale){

            @Override
            protected boolean load(Locale locale, Map<String, String> keyToText) {
                String bundleId = BundleResourceStore.this.bundleId;
                String path = BundleResourceStore.this.path;
                int lastDot = path.lastIndexOf(46);
                if (lastDot != -1) {
                    URL resFileUrl;
                    String resFilePath = path.substring(0, lastDot);
                    String localeString = locale.toString();
                    if (localeString.length() > 0) {
                        resFilePath = String.valueOf(resFilePath) + "_" + localeString;
                    }
                    if ((resFileUrl = BundleResourceStore.toUrl(bundleId, resFilePath = String.valueOf(resFilePath) + ".properties", false)) != null) {
                        boolean bl;
                        InputStream stream = resFileUrl.openStream();
                        try {
                            bl = 1.parse(stream, keyToText);
                        }
                        catch (Throwable throwable) {
                            try {
                                try {
                                    stream.close();
                                }
                                catch (IOException iOException) {}
                                throw throwable;
                            }
                            catch (IOException iOException) {
                                return false;
                            }
                        }
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                        return bl;
                    }
                }
                return false;
            }
        };
    }

    private static final URL toUrl(String bundleId, String path, boolean throwExceptionOnNotFound) {
        Bundle bundle = Platform.getBundle((String)bundleId);
        URL url = FileLocator.find((Bundle)bundle, (IPath)new Path(path), null);
        if (url == null && throwExceptionOnNotFound) {
            String msg = NLS.bind((String)Resources.couldNotFindBundleResource, (Object)bundleId, (Object)path);
            throw new IllegalArgumentException(msg);
        }
        return url;
    }

    private static final class Resources
    extends NLS {
        public static String couldNotFindBundleResource;

        static {
            Resources.initializeMessages((String)BundleResourceStore.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

