/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.sapphire.modeling.BindingImpl;
import org.eclipse.sapphire.modeling.CorruptedResourceExceptionInterceptor;
import org.eclipse.sapphire.modeling.ElementBindingImpl;
import org.eclipse.sapphire.modeling.ElementProperty;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ListBindingImpl;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.ValueBindingImpl;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.localization.LocalizationService;
import org.eclipse.sapphire.modeling.localization.SourceLanguageLocalizationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Resource {
    private final Resource parent;
    private IModelElement element;
    private final Map<ModelProperty, BindingImpl> bindings = new HashMap<ModelProperty, BindingImpl>();
    private CorruptedResourceExceptionInterceptor corruptedResourceExceptionInterceptor;
    private final Map<Locale, LocalizationService> localizationServices = new HashMap<Locale, LocalizationService>();

    public Resource(Resource parent) {
        this.parent = parent;
    }

    public void init(IModelElement element) {
        if (this.element != null) {
            throw new IllegalStateException();
        }
        this.element = element;
    }

    public Resource parent() {
        return this.parent;
    }

    public Resource root() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.root();
    }

    public final IModelElement element() {
        return this.element;
    }

    public final ValueBindingImpl binding(ValueProperty property) {
        return (ValueBindingImpl)this.binding((ModelProperty)property);
    }

    public final ElementBindingImpl binding(ElementProperty property) {
        return (ElementBindingImpl)this.binding((ModelProperty)property);
    }

    public final ListBindingImpl binding(ListProperty property) {
        return (ListBindingImpl)this.binding((ModelProperty)property);
    }

    public final BindingImpl binding(ModelProperty property) {
        BindingImpl binding = this.bindings.get(property);
        if (binding == null) {
            binding = this.createBinding(property);
            if (binding == null) {
                throw new IllegalArgumentException();
            }
            this.bindings.put(property, binding);
        }
        return binding;
    }

    protected abstract BindingImpl createBinding(ModelProperty var1);

    public void save() throws ResourceStoreException {
        Resource root = this.root();
        if (this != root) {
            root.save();
        }
    }

    public <A> A adapt(Class<A> adapterType) {
        Object result = null;
        if (adapterType.isInstance(this)) {
            result = this;
        } else if (adapterType == LocalizationService.class) {
            result = this.getLocalizationService();
        } else if (this.parent != null) {
            result = this.parent.adapt(adapterType);
        }
        return (A)result;
    }

    public boolean isOutOfDate() {
        Resource root = this.root();
        if (this != root) {
            return root.isOutOfDate();
        }
        return false;
    }

    public final LocalizationService getLocalizationService() {
        return this.getLocalizationService(Locale.getDefault());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LocalizationService getLocalizationService(Locale locale) {
        Map<Locale, LocalizationService> map = this.localizationServices;
        synchronized (map) {
            LocalizationService service = this.localizationServices.get(locale);
            if (service == null && (service = this.initLocalizationService(locale)) != null) {
                this.localizationServices.put(locale, service);
            }
            return service;
        }
    }

    protected LocalizationService initLocalizationService(Locale locale) {
        Resource root = this.root();
        if (this != root) {
            return root.getLocalizationService(locale);
        }
        return SourceLanguageLocalizationService.INSTANCE;
    }

    public final void setCorruptedResourceExceptionInterceptor(CorruptedResourceExceptionInterceptor interceptor) {
        this.corruptedResourceExceptionInterceptor = interceptor;
    }

    protected final boolean validateCorruptedResourceRecovery() {
        if (this.corruptedResourceExceptionInterceptor != null) {
            return this.corruptedResourceExceptionInterceptor.shouldAttemptRepair();
        }
        return false;
    }
}

