/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.annotations.processor.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.sapphire.modeling.annotations.processor.util.ArrayTypeReference;
import org.eclipse.sapphire.modeling.annotations.processor.util.BaseModel;
import org.eclipse.sapphire.modeling.annotations.processor.util.FieldModel;
import org.eclipse.sapphire.modeling.annotations.processor.util.IndentingPrintWriter;
import org.eclipse.sapphire.modeling.annotations.processor.util.MethodModel;
import org.eclipse.sapphire.modeling.annotations.processor.util.MethodParameterModel;
import org.eclipse.sapphire.modeling.annotations.processor.util.ParameterizedTypeReference;
import org.eclipse.sapphire.modeling.annotations.processor.util.StaticInitializerModel;
import org.eclipse.sapphire.modeling.annotations.processor.util.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassModel
extends BaseModel {
    private TypeReference name;
    private Set<TypeReference> imports = new HashSet<TypeReference>();
    private TypeReference baseClass;
    private Set<TypeReference> interfaces = new HashSet<TypeReference>();
    private boolean isAbstract = false;
    private List<FieldModel> fields = new ArrayList<FieldModel>();
    private List<StaticInitializerModel> staticInitializers = new ArrayList<StaticInitializerModel>();
    private List<MethodModel> methods = new ArrayList<MethodModel>();

    public TypeReference getName() {
        return this.name;
    }

    public void setName(TypeReference name) {
        if (name instanceof ArrayTypeReference || name instanceof ParameterizedTypeReference) {
            throw new IllegalArgumentException();
        }
        this.name = name;
    }

    public Set<TypeReference> getImports() {
        TreeSet<TypeReference> result = new TreeSet<TypeReference>();
        result.addAll(this.imports);
        if (this.baseClass != null) {
            this.baseClass.contributeNecessaryImports(result);
        }
        for (TypeReference intr : this.interfaces) {
            intr.contributeNecessaryImports(result);
        }
        for (FieldModel field : this.fields) {
            field.getType().contributeNecessaryImports(result);
        }
        for (MethodModel method : this.methods) {
            method.getReturnType().contributeNecessaryImports(result);
            for (MethodParameterModel param : method.getParameters()) {
                param.getType().contributeNecessaryImports(result);
            }
        }
        Iterator itr = result.iterator();
        while (itr.hasNext()) {
            TypeReference entry = (TypeReference)itr.next();
            boolean keep = true;
            if (entry == null) {
                keep = false;
            } else {
                String pkg = entry.getPackage();
                if (entry == TypeReference.VOID_TYPE || TypeReference.PRIMITIVE_TYPES.values().contains(entry) || entry == TypeReference.WILDCARD_TYPE_PARAM) {
                    keep = false;
                } else if (pkg.equals(this.name.getPackage()) || pkg.equals("java.lang")) {
                    keep = false;
                }
            }
            if (keep) continue;
            itr.remove();
        }
        return result;
    }

    public void addImport(TypeReference type) {
        type.contributeNecessaryImports(this.imports);
    }

    public void addImport(Class<?> cl) {
        this.addImport(new TypeReference(cl));
    }

    public TypeReference getBaseClass() {
        return this.baseClass;
    }

    public void setBaseClass(TypeReference baseClass) {
        this.baseClass = baseClass;
    }

    public Set<TypeReference> getInterfaces() {
        return this.interfaces;
    }

    public void addInterface(TypeReference intrfc) {
        this.interfaces.add(intrfc);
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public void setAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    public boolean containsField(String name) {
        for (FieldModel field : this.fields) {
            if (field.getName() == null || !field.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public void addField(FieldModel field) {
        this.fields.add(field);
        field.setParent(this);
    }

    public FieldModel addField() {
        FieldModel field = new FieldModel();
        this.addField(field);
        return field;
    }

    public FieldModel addConstant() {
        FieldModel field = this.addField();
        field.setStatic(true);
        field.setFinal(true);
        return field;
    }

    public void removeField(FieldModel field) {
        this.fields.remove(field);
    }

    public StaticInitializerModel getStaticInitializer(String id) {
        return this.getStaticInitializer(id, false);
    }

    public StaticInitializerModel getStaticInitializer(String id, boolean createIfNecessary) {
        for (StaticInitializerModel x : this.staticInitializers) {
            if (!id.equals(x.getId())) continue;
            return x;
        }
        if (createIfNecessary) {
            return this.addStaticInitializer(id);
        }
        return null;
    }

    public void addStaticInitializer(StaticInitializerModel staticInitializer) {
        this.staticInitializers.add(staticInitializer);
        staticInitializer.setParent(this);
    }

    public StaticInitializerModel addStaticInitializer() {
        StaticInitializerModel staticInitializer = new StaticInitializerModel();
        this.addStaticInitializer(staticInitializer);
        return staticInitializer;
    }

    public StaticInitializerModel addStaticInitializer(String id) {
        StaticInitializerModel staticInitializer = this.addStaticInitializer();
        staticInitializer.setId(id);
        return staticInitializer;
    }

    public void addMethod(MethodModel method) {
        this.methods.add(method);
        method.setParent(this);
    }

    public MethodModel addMethod() {
        MethodModel method = new MethodModel();
        this.addMethod(method);
        return method;
    }

    public MethodModel addMethod(String name) {
        MethodModel m = this.addMethod();
        m.setName(name);
        return m;
    }

    public MethodModel addConstructor() {
        MethodModel m = this.addMethod();
        m.setConstructor(true);
        return m;
    }

    public void removeMethod(MethodModel method) {
        this.methods.remove(method);
        method.setParent(null);
    }

    @Override
    public void write(IndentingPrintWriter pw) {
        pw.print("package ");
        pw.print(this.name.getPackage());
        pw.print(';');
        pw.println();
        pw.println();
        Set<TypeReference> imports = this.getImports();
        for (TypeReference entry : imports) {
            pw.print("import ");
            pw.print(entry.getQualifiedName());
            pw.print(';');
            pw.println();
        }
        if (!imports.isEmpty()) {
            pw.println();
        }
        pw.printf("public %s class ", this.isAbstract ? "abstract" : "final");
        pw.print(this.name.getSimpleName());
        pw.println();
        if (this.baseClass != null || !this.interfaces.isEmpty()) {
            pw.increaseIndent();
            pw.println();
            if (this.baseClass != null) {
                pw.print("extends ");
                pw.print(this.baseClass.getSimpleName());
                pw.println();
            }
            if (!this.interfaces.isEmpty()) {
                pw.print("implements ");
                boolean first = true;
                for (TypeReference intrfc : this.interfaces) {
                    if (first) {
                        first = false;
                    } else {
                        pw.print(", ");
                    }
                    pw.print(intrfc.getSimpleName());
                }
                pw.println();
            }
            pw.println();
            pw.decreaseIndent();
        }
        pw.print('{');
        pw.println();
        pw.increaseIndent();
        Comparator<FieldModel> fieldByNameComparator = new Comparator<FieldModel>(){

            @Override
            public int compare(FieldModel f1, FieldModel f2) {
                String n2;
                String n1 = f1.getName();
                if (n1 == (n2 = f2.getName())) {
                    return 0;
                }
                if (n1 == null) {
                    return -1;
                }
                if (n2 == null) {
                    return 1;
                }
                return n1.compareTo(n2);
            }
        };
        TreeSet<FieldModel> constants = new TreeSet<FieldModel>(fieldByNameComparator);
        TreeSet<FieldModel> instanceFields = new TreeSet<FieldModel>(fieldByNameComparator);
        for (FieldModel field : this.fields) {
            if (field.isStatic() && field.isFinal()) {
                constants.add(field);
                continue;
            }
            instanceFields.add(field);
        }
        if (!constants.isEmpty()) {
            for (FieldModel field : constants) {
                field.write(pw);
            }
            pw.println();
        }
        for (StaticInitializerModel staticInitializer : this.staticInitializers) {
            staticInitializer.write(pw);
        }
        if (!instanceFields.isEmpty()) {
            for (FieldModel field : instanceFields) {
                field.write(pw);
            }
            pw.println();
        }
        for (MethodModel method : this.methods) {
            method.write(pw);
        }
        pw.decreaseIndent();
        pw.print('}');
        pw.println();
    }
}

