/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.annotations.processor.util;

import java.io.PrintWriter;

public final class IndentingPrintWriter {
    private static final String INDENT = "    ";
    private static final String[] COMMON_INDENTS = new String[10];
    private final PrintWriter base;
    private int indentLevel;
    private String indentLevelString;
    private boolean indentOnNextWrite;

    static {
        IndentingPrintWriter.COMMON_INDENTS[0] = "";
        int i = 1;
        while (i < COMMON_INDENTS.length) {
            IndentingPrintWriter.COMMON_INDENTS[i] = String.valueOf(COMMON_INDENTS[i - 1]) + INDENT;
            ++i;
        }
    }

    public IndentingPrintWriter(PrintWriter base) {
        this.base = base;
        this.indentLevel = 0;
        this.indentLevelString = COMMON_INDENTS[0];
        this.indentOnNextWrite = false;
    }

    public void print(String value) {
        this.indentIfNecessary();
        this.base.print(value);
    }

    public void print(char value) {
        this.indentIfNecessary();
        this.base.print(value);
    }

    public void print(Object value) {
        this.indentIfNecessary();
        this.base.print(value);
    }

    public void println() {
        this.indentIfNecessary();
        this.base.println();
        this.indentOnNextWrite = true;
    }

    public void printf(String format, Object ... args) {
        this.indentIfNecessary();
        this.base.printf(format, args);
    }

    public void increaseIndent() {
        ++this.indentLevel;
        this.indentLevelString = this.indentLevel < COMMON_INDENTS.length ? COMMON_INDENTS[this.indentLevel] : String.valueOf(this.indentLevelString) + INDENT;
    }

    public void decreaseIndent() {
        if (this.indentLevel > 0) {
            --this.indentLevel;
            this.indentLevelString = this.indentLevel < COMMON_INDENTS.length ? COMMON_INDENTS[this.indentLevel] : this.indentLevelString.substring(0, this.indentLevelString.length() - INDENT.length());
        }
    }

    private void indentIfNecessary() {
        if (this.indentOnNextWrite) {
            this.base.print(this.indentLevelString);
            this.indentOnNextWrite = false;
        }
    }
}

