/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.serialization.internal;

import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelPropertyService;
import org.eclipse.sapphire.modeling.ModelPropertyServiceFactory;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.internal.SapphireModelingExtensionSystem;
import org.eclipse.sapphire.modeling.internal.SapphireModelingFrameworkPlugin;
import org.eclipse.sapphire.modeling.serialization.ValueSerialization;
import org.eclipse.sapphire.modeling.serialization.ValueSerializationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ValueSerializationServiceFactory
extends ModelPropertyServiceFactory {
    private static final ValueSerializationService DEFAULT_SERIALIZER = new ValueSerializationService(){

        protected Object decodeFromString(String value) {
            return value;
        }
    };

    @Override
    public boolean applicable(IModelElement element, ModelProperty property, Class<? extends ModelPropertyService> service) {
        return property instanceof ValueProperty;
    }

    @Override
    public ModelPropertyService create(IModelElement element, ModelProperty property, Class<? extends ModelPropertyService> service) {
        Class<?> type = property.getTypeClass();
        ValueSerializationService serializer = null;
        if (type != String.class) {
            ValueSerialization valueSerializerAnnotation = property.getAnnotation(ValueSerialization.class);
            if (valueSerializerAnnotation != null) {
                try {
                    serializer = valueSerializerAnnotation.service().newInstance();
                    serializer.init(element, property, valueSerializerAnnotation.params());
                }
                catch (Exception e) {
                    SapphireModelingFrameworkPlugin.log(e);
                }
            }
            if (serializer == null) {
                serializer = SapphireModelingExtensionSystem.createValueSerializer(element, (ValueProperty)property, type);
                if (serializer != null) {
                    try {
                        serializer.init(element, property, new String[0]);
                    }
                    catch (Exception e) {
                        SapphireModelingFrameworkPlugin.log(e);
                        serializer = null;
                    }
                } else {
                    String message = NLS.bind((String)Resources.noSerializer, (Object[])new Object[]{element.getModelElementType().getModelElementClass().getName(), property.getName(), type.getName()});
                    SapphireModelingFrameworkPlugin.logError(message, null);
                }
            }
        }
        if (serializer == null) {
            serializer = DEFAULT_SERIALIZER;
        }
        return serializer;
    }

    private static final class Resources
    extends NLS {
        public static String noSerializer;

        static {
            Resources.initializeMessages((String)ValueSerializationServiceFactory.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

