/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.xml;

import java.util.Locale;
import org.eclipse.sapphire.modeling.CorruptedResourceException;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.internal.SapphireModelingFrameworkPlugin;
import org.eclipse.sapphire.modeling.localization.LocalizationService;
import org.eclipse.sapphire.modeling.xml.RootElementController;
import org.eclipse.sapphire.modeling.xml.StandardRootElementController;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlRootBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlRootBinding;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootXmlResource
extends XmlResource {
    private static final String PI_XML_TARGET = "xml";
    private static final String PI_XML_DATA = "version=\"1.0\" encoding=\"UTF-8\"";
    private final XmlResourceStore store;
    private final Document document;
    private RootElementController rootElementController;
    private XmlElement rootXmlElement;

    public RootXmlResource() {
        this(new XmlResourceStore());
    }

    public RootXmlResource(XmlResourceStore store) {
        super(null);
        this.store = store;
        this.document = store.getDomDocument();
    }

    public XmlResourceStore store() {
        return this.store;
    }

    @Override
    public void init(IModelElement modelElement) {
        CustomXmlRootBinding customRootXmlBindingAnnotation;
        super.init(modelElement);
        ModelElementType modelElementType = modelElement.getModelElementType();
        XmlRootBinding rootXmlBindingAnnotation = modelElementType.getAnnotation(XmlRootBinding.class);
        if (rootXmlBindingAnnotation != null) {
            this.rootElementController = new StandardRootElementController(rootXmlBindingAnnotation.namespace(), rootXmlBindingAnnotation.schemaLocation(), rootXmlBindingAnnotation.defaultPrefix(), rootXmlBindingAnnotation.elementName());
        }
        if (this.rootElementController == null && (customRootXmlBindingAnnotation = modelElementType.getAnnotation(CustomXmlRootBinding.class)) != null) {
            try {
                this.rootElementController = customRootXmlBindingAnnotation.value().newInstance();
            }
            catch (Exception e) {
                SapphireModelingFrameworkPlugin.log(e);
            }
        }
        if (this.rootElementController == null) {
            this.rootElementController = new StandardRootElementController(modelElementType.getSimpleName().substring(1));
        }
        this.rootElementController.init(this);
        this.store().registerRootModelElement(modelElement);
    }

    public final Document getDomDocument() {
        return this.document;
    }

    @Override
    public XmlElement getXmlElement(boolean createIfNecessary) {
        Element root = this.document.getDocumentElement();
        if (this.document.getChildNodes().getLength() == 0) {
            if (createIfNecessary) {
                this.fixMalformedDescriptor();
                root = this.document.getDocumentElement();
            }
        } else {
            boolean isRootValid;
            boolean bl = isRootValid = root == null ? false : this.rootElementController.checkRootElement();
            if (!isRootValid) {
                root = null;
                if (createIfNecessary) {
                    if (this.validateCorruptedResourceRecovery()) {
                        this.fixMalformedDescriptor();
                        root = this.document.getDocumentElement();
                    } else {
                        throw new CorruptedResourceException();
                    }
                }
            }
        }
        if (root == null) {
            this.rootXmlElement = null;
        } else if (this.rootXmlElement == null || root != this.rootXmlElement.getDomNode()) {
            this.rootXmlElement = new XmlElement(this.store(), root);
        }
        return this.rootXmlElement;
    }

    @Override
    public void save() throws ResourceStoreException {
        this.store.save();
    }

    @Override
    public <A> A adapt(Class<A> adapterType) {
        A adapter = this.store.adapt(adapterType);
        if (adapter == null) {
            adapter = super.adapt(adapterType);
        }
        return adapter;
    }

    @Override
    public boolean isOutOfDate() {
        return this.store.isOutOfDate();
    }

    @Override
    protected LocalizationService initLocalizationService(Locale locale) {
        return this.store.getLocalizationService(locale);
    }

    private final void fixMalformedDescriptor() {
        NodeList topLevelNodes = this.document.getChildNodes();
        Node[] nodes = new Node[topLevelNodes.getLength()];
        int i = 0;
        int n = nodes.length;
        while (i < n) {
            nodes[i] = topLevelNodes.item(i);
            ++i;
        }
        Node[] nodeArray = nodes;
        int n2 = nodes.length;
        int n3 = 0;
        while (n3 < n2) {
            Node node = nodeArray[n3];
            this.document.removeChild(node);
            ++n3;
        }
        if (this.store().isXmlDeclarationNeeded()) {
            this.addXmlProcessingInstruction(this.document);
        }
        this.rootElementController.createRootElement();
    }

    private void addXmlProcessingInstruction(Document document) {
        NodeList nodes = document.getChildNodes();
        int i = 0;
        int n = nodes.getLength();
        while (i < n) {
            ProcessingInstruction pi;
            Node node = nodes.item(i);
            if (node.getNodeType() == 7 && (pi = (ProcessingInstruction)node).getTarget().equals(PI_XML_TARGET)) {
                pi.setData(PI_XML_DATA);
                return;
            }
            ++i;
        }
        ProcessingInstruction pi = document.createProcessingInstruction(PI_XML_TARGET, PI_XML_DATA);
        document.insertBefore(pi, document.getFirstChild());
    }
}

