/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.xml;

import java.util.List;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.LayeredElementBindingImpl;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.util.internal.MiscUtil;
import org.eclipse.sapphire.modeling.xml.ChildXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlPath;
import org.eclipse.sapphire.modeling.xml.XmlResource;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlElementBinding;

public final class StandardXmlElementBindingImpl
extends LayeredElementBindingImpl {
    private XmlPath path;
    private String[] xmlElementNames;
    private ModelElementType[] modelElementTypes;

    public void init(IModelElement element, ModelProperty property, String[] params) {
        super.init(element, property, params);
        XmlElementBinding xmlElementBindingAnnotation = property.getAnnotation(XmlElementBinding.class);
        if (xmlElementBindingAnnotation != null) {
            if (xmlElementBindingAnnotation.path().length() > 0) {
                this.path = new XmlPath(xmlElementBindingAnnotation.path(), ((XmlResource)element.resource()).getXmlNamespaceResolver());
            }
            XmlElementBinding.Mapping[] mappings = xmlElementBindingAnnotation.mappings();
            this.xmlElementNames = new String[mappings.length];
            this.modelElementTypes = new ModelElementType[mappings.length];
            int i = 0;
            while (i < mappings.length) {
                XmlElementBinding.Mapping mapping = mappings[i];
                this.xmlElementNames[i] = mapping.element();
                this.modelElementTypes[i] = ModelElementType.getModelElementType(mapping.type());
                ++i;
            }
        } else {
            XmlBinding xmlBindingAnnotation = property.getAnnotation(XmlBinding.class);
            if (xmlBindingAnnotation != null && property.getAllPossibleTypes().size() == 1) {
                this.modelElementTypes = new ModelElementType[]{property.getType()};
                this.xmlElementNames = new String[]{xmlBindingAnnotation.path()};
            } else {
                this.path = new XmlPath(property.getName(), ((XmlResource)element.resource()).getXmlNamespaceResolver());
                List<ModelElementType> types = property.getAllPossibleTypes();
                this.modelElementTypes = types.toArray(new ModelElementType[types.size()]);
                this.xmlElementNames = new String[this.modelElementTypes.length];
                int i = 0;
                while (i < this.modelElementTypes.length) {
                    this.xmlElementNames[i] = this.modelElementTypes[i].getSimpleName().substring(1);
                    ++i;
                }
            }
        }
    }

    public ModelElementType type(Resource resource) {
        XmlElement xmlElement = ((XmlResource)resource).getXmlElement();
        String xmlElementName = xmlElement.getDomNode().getLocalName();
        int i = 0;
        while (i < this.xmlElementNames.length) {
            if (this.xmlElementNames[i].equals(xmlElementName)) {
                return this.modelElementTypes[i];
            }
            ++i;
        }
        throw new IllegalStateException();
    }

    protected Object readUnderlyingObject() {
        XmlElement parent = ((XmlResource)this.element().resource()).getXmlElement(false);
        if (parent != null) {
            if (this.path != null) {
                parent = (XmlElement)parent.getChildNode(this.path, false);
            }
            if (parent != null) {
                for (XmlElement element : parent.getChildElements()) {
                    String xmlElementName = element.getDomNode().getLocalName();
                    if (!MiscUtil.contains(this.xmlElementNames, xmlElementName)) continue;
                    return element;
                }
            }
        }
        return null;
    }

    protected Object createUnderlyingObject(ModelElementType type) {
        String xmlElementName = this.xmlElementNames[MiscUtil.indexOf(this.modelElementTypes, type)];
        XmlElement parent = ((XmlResource)this.element().resource()).getXmlElement(true);
        if (this.path != null) {
            parent = (XmlElement)parent.getChildNode(this.path, true);
        }
        return parent.getChildElement(xmlElementName, true);
    }

    protected Resource createResource(Object obj) {
        XmlElement xmlElement = (XmlElement)obj;
        XmlResource parentXmlResource = (XmlResource)this.element().resource();
        return new ChildXmlResource(parentXmlResource, xmlElement);
    }

    public void remove() {
        XmlElement parent = ((XmlResource)this.element().resource()).getXmlElement(false);
        if (parent != null) {
            if (this.path != null) {
                parent = (XmlElement)parent.getChildNode(this.path, false);
            }
            if (parent != null) {
                for (XmlElement element : parent.getChildElements()) {
                    String xmlElementName = element.getDomNode().getLocalName();
                    if (!MiscUtil.contains(this.xmlElementNames, xmlElementName)) continue;
                    element.remove();
                }
            }
        }
    }

    public boolean removable() {
        return true;
    }
}

