/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.calendar.internal;

import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.serialization.ValueSerializationService;
import org.eclipse.sapphire.samples.calendar.IEventAttachment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EventAttachment
extends ModelElement
implements IEventAttachment {
    private Value<IPath> localCopyLocation;
    private Value<URL> publicCopyLocation;

    public EventAttachment(IModelParticle parent, ModelProperty parentProperty, Resource resource) {
        super(TYPE, parent, parentProperty, resource);
    }

    public EventAttachment(Resource resource) {
        super(TYPE, null, null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<IPath> getLocalCopyLocation() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.localCopyLocation == null) {
                this.refresh((ModelProperty)PROP_LOCAL_COPY_LOCATION, true);
            }
            return this.localCopyLocation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLocalCopyLocation(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_LOCAL_COPY_LOCATION.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_LOCAL_COPY_LOCATION, true);
            if (!EventAttachment.equal((String)this.localCopyLocation.getText(false), (String)value)) {
                this.resource().binding(PROP_LOCAL_COPY_LOCATION).write(value);
                this.refresh((ModelProperty)PROP_LOCAL_COPY_LOCATION, false);
            }
        }
    }

    @Override
    public void setLocalCopyLocation(IPath value) {
        this.setLocalCopyLocation(value != null ? ((ValueSerializationService)this.service((ModelProperty)PROP_LOCAL_COPY_LOCATION, ValueSerializationService.class)).encode((Object)value) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<URL> getPublicCopyLocation() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.publicCopyLocation == null) {
                this.refresh((ModelProperty)PROP_PUBLIC_COPY_LOCATION, true);
            }
            return this.publicCopyLocation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPublicCopyLocation(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_PUBLIC_COPY_LOCATION.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_PUBLIC_COPY_LOCATION, true);
            if (!EventAttachment.equal((String)this.publicCopyLocation.getText(false), (String)value)) {
                this.resource().binding(PROP_PUBLIC_COPY_LOCATION).write(value);
                this.refresh((ModelProperty)PROP_PUBLIC_COPY_LOCATION, false);
            }
        }
    }

    @Override
    public void setPublicCopyLocation(URL value) {
        this.setPublicCopyLocation(value != null ? ((ValueSerializationService)this.service((ModelProperty)PROP_PUBLIC_COPY_LOCATION, ValueSerializationService.class)).encode((Object)value) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            property = property.refine((IModelElement)this);
            if (property == PROP_LOCAL_COPY_LOCATION) {
                if (this.localCopyLocation != null || force) {
                    Value<IPath> oldValue = this.localCopyLocation;
                    String val = this.resource().binding(PROP_LOCAL_COPY_LOCATION).read();
                    this.localCopyLocation = new Value((IModelElement)this, PROP_LOCAL_COPY_LOCATION, PROP_LOCAL_COPY_LOCATION.encodeKeywords(val));
                    this.localCopyLocation.init();
                    boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_LOCAL_COPY_LOCATION);
                    if (oldValue != null) {
                        if (this.localCopyLocation.equals(oldValue)) {
                            this.localCopyLocation = oldValue;
                        }
                        if (this.localCopyLocation != oldValue || propertyEnabledStatusChanged) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_LOCAL_COPY_LOCATION);
                        }
                    }
                }
            } else if (property == PROP_PUBLIC_COPY_LOCATION && (this.publicCopyLocation != null || force)) {
                Value<URL> oldValue = this.publicCopyLocation;
                String val = this.resource().binding(PROP_PUBLIC_COPY_LOCATION).read();
                this.publicCopyLocation = new Value((IModelElement)this, PROP_PUBLIC_COPY_LOCATION, PROP_PUBLIC_COPY_LOCATION.encodeKeywords(val));
                this.publicCopyLocation.init();
                boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_PUBLIC_COPY_LOCATION);
                if (oldValue != null) {
                    if (this.publicCopyLocation.equals(oldValue)) {
                        this.publicCopyLocation = oldValue;
                    }
                    if (this.publicCopyLocation != oldValue || propertyEnabledStatusChanged) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_PUBLIC_COPY_LOCATION);
                    }
                }
            }
        }
    }

    public Object read(ModelProperty property) {
        if ((property = property.refine((IModelElement)this)) == PROP_LOCAL_COPY_LOCATION) {
            return this.getLocalCopyLocation();
        }
        if (property == PROP_PUBLIC_COPY_LOCATION) {
            return this.getPublicCopyLocation();
        }
        return super.read(property);
    }

    public void write(ValueProperty property, Object value) {
        if ((property = (ValueProperty)property.refine((IModelElement)this)) == PROP_LOCAL_COPY_LOCATION) {
            if (!(value instanceof String)) {
                this.setLocalCopyLocation((IPath)value);
            } else {
                this.setLocalCopyLocation((String)value);
            }
            return;
        }
        if (property == PROP_PUBLIC_COPY_LOCATION) {
            if (!(value instanceof String)) {
                this.setPublicCopyLocation((URL)value);
            } else {
                this.setPublicCopyLocation((String)value);
            }
            return;
        }
        super.write(property, value);
    }
}

