/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.def.ISapphireLabelDef;
import org.eclipse.sapphire.ui.swt.renderer.GridLayoutUtil;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.SharedScrolledComposite;

public final class SapphireLabel
extends SapphirePart {
    public void render(final SapphireRenderingContext context) {
        ISapphireLabelDef def = (ISapphireLabelDef)this.definition;
        final GridData gd = GridLayoutUtil.gdhindent(GridLayoutUtil.gdwhint(GridLayoutUtil.gdhspan(GridLayoutUtil.gdhfill(), 2), 100), 9);
        final Label l = new Label(context.getComposite(), 64);
        l.setLayoutData((Object)gd);
        l.setText(def.getText().getLocalizedText());
        context.adapt((Control)l);
        l.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                if (l.getBounds().width != gd.widthHint + 20) {
                    gd.widthHint = l.getBounds().width == gd.widthHint ? 100 : l.getBounds().width - 20;
                    SapphireLabel.this.relayout(context.getComposite());
                }
            }
        });
    }

    private void relayout(final Composite composite) {
        composite.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (composite.isDisposed()) {
                    return;
                }
                Composite parent = composite;
                while (parent != null) {
                    if (parent instanceof SharedScrolledComposite) {
                        parent.layout(true, true);
                        ((SharedScrolledComposite)parent).reflow(true);
                        return;
                    }
                    if (parent instanceof Shell) {
                        parent.layout(true, true);
                        return;
                    }
                    parent = parent.getParent();
                }
            }
        });
    }
}

