/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.assist.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.ui.SapphireImageCache;
import org.eclipse.sapphire.ui.SapphirePropertyEditor;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContext;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContributor;
import org.eclipse.sapphire.ui.assist.internal.ActionsSectionAssistContributor;
import org.eclipse.sapphire.ui.assist.internal.DefaultValueInfoAssistContributor;
import org.eclipse.sapphire.ui.assist.internal.InfoSectionAssistContributor;
import org.eclipse.sapphire.ui.assist.internal.MinMaxInfoAssistContributor;
import org.eclipse.sapphire.ui.assist.internal.ProblemsAssistContributor;
import org.eclipse.sapphire.ui.assist.internal.ProblemsSectionAssistContributor;
import org.eclipse.sapphire.ui.assist.internal.PropertyEditorAssistDialog;
import org.eclipse.sapphire.ui.assist.internal.ResetActionsAssistContributor;
import org.eclipse.sapphire.ui.assist.internal.ShowInSourceActionAssistContributor;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public final class PropertyEditorAssistDecorator {
    private static final List<PropertyEditorAssistContributor> SYSTEM_CONTRIBUTORS = new ArrayList<PropertyEditorAssistContributor>();
    private final SapphirePropertyEditor propertyEditor;
    private final SapphireRenderingContext context;
    private final Label control;
    private final ModelProperty property;
    private final Collection<String> contributorsToSuppress;
    private final Collection<Class<?>> additionalContributors;
    private PropertyEditorAssistContext assistContext;
    private IStatus problem;
    private boolean mouseOverEditorControl;
    private EditorControlMouseTrackListener mouseTrackListener;

    static {
        SYSTEM_CONTRIBUTORS.add(new InfoSectionAssistContributor());
        SYSTEM_CONTRIBUTORS.add(new DefaultValueInfoAssistContributor());
        SYSTEM_CONTRIBUTORS.add(new MinMaxInfoAssistContributor());
        SYSTEM_CONTRIBUTORS.add(new ProblemsSectionAssistContributor());
        SYSTEM_CONTRIBUTORS.add(new ActionsSectionAssistContributor());
        SYSTEM_CONTRIBUTORS.add(new ResetActionsAssistContributor());
        SYSTEM_CONTRIBUTORS.add(new ShowInSourceActionAssistContributor());
    }

    public PropertyEditorAssistDecorator(SapphirePropertyEditor propertyEditor, SapphireRenderingContext context, Composite parent) {
        this.propertyEditor = propertyEditor;
        this.context = context;
        this.property = propertyEditor.getProperty();
        this.contributorsToSuppress = propertyEditor.getRenderingHint("suppress.assist.contributors", Collections.emptyList());
        this.additionalContributors = propertyEditor.getRenderingHint("assist.contributors", Collections.emptyList());
        this.mouseOverEditorControl = false;
        this.mouseTrackListener = new EditorControlMouseTrackListener();
        this.control = new Label(parent, 0);
        this.context.adapt((Control)this.control);
        this.control.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent event) {
                PropertyEditorAssistDecorator.this.openAssistDialog();
            }
        });
        this.control.addMouseTrackListener((MouseTrackListener)new EditorControlMouseTrackListener(){

            public void mouseEnter(MouseEvent event) {
                super.mouseEnter(event);
                PropertyEditorAssistDecorator.this.refreshImageAndCursor();
            }

            public void mouseHover(MouseEvent event) {
            }
        });
        this.refresh();
    }

    public Label getControl() {
        return this.control;
    }

    public SapphireRenderingContext getUiContext() {
        return this.context;
    }

    public Shell getShell() {
        return this.context.getShell();
    }

    public void addEditorControl(Control control) {
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.addEditorControl(child);
                ++n2;
            }
        }
        control.addMouseTrackListener((MouseTrackListener)this.mouseTrackListener);
    }

    public void removeEditorControl(Control control) {
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.removeEditorControl(child);
                ++n2;
            }
        }
        control.removeMouseTrackListener((MouseTrackListener)this.mouseTrackListener);
    }

    public void openAssistDialog() {
        if (this.assistContext != null && !this.assistContext.isEmpty()) {
            Rectangle bounds = this.control.getBounds();
            Point position = this.control.toDisplay(new Point(bounds.x, bounds.y));
            position = new Point(position.x + bounds.width + 4, position.y + 2);
            PropertyEditorAssistDialog dialog = new PropertyEditorAssistDialog(this.getShell(), position, this.assistContext);
            dialog.open();
        }
    }

    public void refresh() {
        boolean enabled;
        IModelElement element = this.propertyEditor.getModelElement();
        boolean bl = enabled = element == null ? false : element.isPropertyEnabled(this.property);
        if (enabled) {
            if (this.property instanceof ValueProperty) {
                Value value = element.read((ValueProperty)this.property);
                this.problem = value.validate();
            } else if (this.property instanceof ListProperty) {
                ModelElementList list = element.read((ListProperty)this.property);
                this.problem = list.validate();
            } else {
                throw new IllegalStateException(this.property.getClass().getName());
            }
            this.assistContext = new PropertyEditorAssistContext(this.propertyEditor, this.context);
            ArrayList<PropertyEditorAssistContributor> contributors = new ArrayList<PropertyEditorAssistContributor>(SYSTEM_CONTRIBUTORS);
            contributors.add(new ProblemsAssistContributor(this.problem));
            block2: for (String string : this.contributorsToSuppress) {
                Iterator itr = contributors.iterator();
                while (itr.hasNext()) {
                    PropertyEditorAssistContributor contributor = (PropertyEditorAssistContributor)itr.next();
                    if (!contributor.getId().equals(string)) continue;
                    itr.remove();
                    continue block2;
                }
            }
            for (Class clazz : this.additionalContributors) {
                try {
                    contributors.add((PropertyEditorAssistContributor)clazz.newInstance());
                }
                catch (Exception e) {
                    SapphireUiFrameworkPlugin.log(e);
                }
            }
            Collections.sort(contributors, new Comparator<PropertyEditorAssistContributor>(){

                @Override
                public int compare(PropertyEditorAssistContributor c1, PropertyEditorAssistContributor c2) {
                    return c1.getPriority() - c2.getPriority();
                }
            });
            for (PropertyEditorAssistContributor propertyEditorAssistContributor : contributors) {
                propertyEditorAssistContributor.contribute(this.assistContext);
            }
            if (this.assistContext.isEmpty()) {
                this.assistContext = null;
            } else {
                int n = this.problem.getSeverity();
                if (n != 4 && n != 2 && n != 1) {
                    this.problem = null;
                }
            }
        } else {
            this.assistContext = null;
            this.problem = null;
        }
        this.refreshImageAndCursor();
    }

    private void refreshImageAndCursor() {
        if (this.control.isDisposed()) {
            return;
        }
        SapphireImageCache imageCache = this.propertyEditor.getImageCache();
        if (this.assistContext != null) {
            if (this.problem != null) {
                String fieldDecorationId;
                int severity = this.problem.getSeverity();
                switch (severity) {
                    case 4: {
                        fieldDecorationId = "DEC_ERROR";
                        break;
                    }
                    case 2: {
                        fieldDecorationId = "DEC_WARNING";
                        break;
                    }
                    default: {
                        fieldDecorationId = "DEC_INFORMATION";
                    }
                }
                FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration(fieldDecorationId);
                this.control.setImage(fieldDecoration.getImage());
            } else if (this.mouseOverEditorControl) {
                this.control.setImage(imageCache.getImage(SapphireImageCache.DECORATOR_ASSIST));
            } else {
                this.control.setImage(imageCache.getImage(SapphireImageCache.DECORATOR_ASSIST_FAINT));
            }
            this.control.setVisible(true);
            this.control.setCursor(Display.getCurrent().getSystemCursor(21));
        } else {
            this.control.setVisible(false);
            this.control.setImage(imageCache.getImage(SapphireImageCache.DECORATOR_BLANK));
            this.control.setCursor(null);
        }
    }

    private class EditorControlMouseTrackListener
    extends MouseTrackAdapter {
        private EditorControlMouseTrackListener() {
        }

        public void mouseEnter(MouseEvent event) {
            PropertyEditorAssistDecorator.this.mouseOverEditorControl = true;
        }

        public void mouseHover(MouseEvent event) {
            PropertyEditorAssistDecorator.this.refreshImageAndCursor();
        }

        public void mouseExit(MouseEvent event) {
            PropertyEditorAssistDecorator.this.mouseOverEditorControl = false;
            this.performedDelayedImageRefresh();
        }

        private void performedDelayedImageRefresh() {
            final Runnable op = new Runnable(){

                public void run() {
                    PropertyEditorAssistDecorator.this.refreshImageAndCursor();
                }
            };
            Thread thread = new Thread(){

                public void run() {
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException interruptedException) {}
                    Display.getDefault().asyncExec(op);
                }
            };
            thread.start();
        }

        /* synthetic */ EditorControlMouseTrackListener(EditorControlMouseTrackListener editorControlMouseTrackListener, EditorControlMouseTrackListener editorControlMouseTrackListener2) {
            this();
        }
    }
}

