/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.internal.binding;

import java.util.Collection;
import org.eclipse.sapphire.modeling.EditFailedException;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelPropertyChangeEvent;
import org.eclipse.sapphire.modeling.ModelPropertyListener;
import org.eclipse.sapphire.ui.SapphirePropertyEditor;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.assist.internal.PropertyEditorAssistDecorator;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Control;

public abstract class AbstractBinding {
    private SapphirePropertyEditor editor;
    private ModelPropertyListener propertyChangeListener;
    private SapphireRenderingContext context;
    private Control control;

    public AbstractBinding(SapphirePropertyEditor editor, SapphireRenderingContext context, Control control) {
        this.editor = editor;
        this.context = context;
        this.control = control;
        this.propertyChangeListener = new ModelPropertyListener(){

            public void handlePropertyChangedEvent(ModelPropertyChangeEvent event) {
                AbstractBinding.this.updateTarget();
            }
        };
        this.editor.getModelElement().addListener(this.propertyChangeListener, this.editor.getProperty().getName());
        this.control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                AbstractBinding.this.dispose();
            }
        });
        this.initialize(editor, context, control);
        this.updateTarget();
    }

    public final IModelElement getModelElement() {
        return this.editor.getModelElement();
    }

    public ModelProperty getProperty() {
        return this.editor.getProperty();
    }

    public Object getPropertyValue() {
        return this.getModelElement().read(this.getProperty());
    }

    public final SapphireRenderingContext getContext() {
        return this.context;
    }

    public final Control getControl() {
        return this.control;
    }

    public final void updateModel() {
        boolean rollback = false;
        try {
            this.doUpdateModel();
        }
        catch (Exception e) {
            EditFailedException editFailedException = EditFailedException.findAsCause((Throwable)e);
            if (editFailedException != null) {
                rollback = true;
            }
            SapphireUiFrameworkPlugin.log(e);
        }
        if (rollback) {
            this.updateTarget();
        }
    }

    public final void updateTarget() {
        if (this.control != null) {
            if (this.control.isDisposed()) {
                return;
            }
            if (this.control.getDisplay().getThread() != Thread.currentThread()) {
                this.control.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        AbstractBinding.this.updateTarget();
                    }
                });
                return;
            }
        }
        try {
            this.doUpdateTarget();
            this.updateTargetAttributes();
        }
        catch (Exception e) {
            SapphireUiFrameworkPlugin.log(e);
        }
    }

    public final void updateTargetAttributes() {
        if (this.control.isDisposed()) {
            return;
        }
        PropertyEditorAssistDecorator dec = (PropertyEditorAssistDecorator)this.control.getData("assist-decorator");
        if (dec != null) {
            dec.refresh();
        }
        boolean enabled = this.getModelElement().isPropertyEnabled(this.getProperty());
        this.control.setEnabled(enabled);
        Object relatedControls = this.control.getData("related-controls");
        if (relatedControls != null) {
            if (relatedControls instanceof Control) {
                ((Control)relatedControls).setEnabled(enabled);
            } else if (relatedControls instanceof Collection) {
                for (Object control : (Collection)relatedControls) {
                    if (control == null) continue;
                    ((Control)control).setEnabled(enabled);
                }
            }
        }
    }

    public void dispose() {
        this.getModelElement().removeListener(this.propertyChangeListener, this.getProperty().getName());
    }

    protected void initialize(SapphirePropertyEditor editor, SapphireRenderingContext context, Control control) {
    }

    protected abstract void doUpdateTarget();

    protected abstract void doUpdateModel();
}

