/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.xml;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelElementDisposedEvent;
import org.eclipse.sapphire.modeling.ModelElementListener;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.ValidateEditException;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.ui.DelayedTasksExecutor;
import org.eclipse.sapphire.ui.SapphireEditor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.provisional.extensions.ISourceEditingTextTools;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.provisional.IDOMSourceEditingTextTools;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlEditorResourceStore
extends XmlResourceStore {
    private StructuredTextEditor sourceEditor;
    private IModelElement rootModelElement;
    private final Map<Node, IModelElement> nodeToModelElementMap;
    private final Scrubber scrubber;
    private final ModelElementListener modelElementDisposeListener;

    public XmlEditorResourceStore(SapphireEditor sapphireEditor, StructuredTextEditor sourceEditor) {
        super(null);
        this.sourceEditor = sourceEditor;
        this.rootModelElement = null;
        this.nodeToModelElementMap = new HashMap<Node, IModelElement>();
        this.scrubber = new Scrubber();
        this.scrubber.start();
        this.modelElementDisposeListener = new ModelElementListener(){

            public void handleElementDisposedEvent(ModelElementDisposedEvent event) {
                XmlEditorResourceStore.this.handleElementDisposed(event.getModelElement());
            }
        };
        ISourceEditingTextTools sourceEditingTextTools = (ISourceEditingTextTools)this.sourceEditor.getAdapter(ISourceEditingTextTools.class);
        IDOMSourceEditingTextTools domSourceEditingTextTools = (IDOMSourceEditingTextTools)sourceEditingTextTools;
        Document document = domSourceEditingTextTools.getDOMDocument();
        INodeAdapter adapter = new INodeAdapter(){

            public boolean isAdapterForType(Object type) {
                return false;
            }

            public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
                if (eventType == 2 && newValue instanceof IDOMNode) {
                    XmlEditorResourceStore.addAdapter((IDOMNode)newValue, this);
                }
                XmlEditorResourceStore.this.handleXmlNodeChange((Node)notifier);
            }
        };
        XmlEditorResourceStore.addAdapter((IDOMNode)document, adapter);
        this.setDomDocument(document);
    }

    public StructuredTextEditor getXmlEditor() {
        return this.sourceEditor;
    }

    public boolean isXmlDeclarationNeeded() {
        return true;
    }

    public void save() throws ResourceStoreException {
        IFile file;
        IEditorInput input = this.sourceEditor.getEditorInput();
        if (input instanceof FileEditorInput && !(file = ((FileEditorInput)input).getFile()).exists()) {
            return;
        }
        this.validateSave();
        this.sourceEditor.doSave((IProgressMonitor)new NullProgressMonitor());
    }

    public void validateEdit() {
        IFile file;
        IEditorInput input = this.sourceEditor.getEditorInput();
        if (input instanceof FileEditorInput && !(file = ((FileEditorInput)input).getFile()).exists()) {
            IStatus st = ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{file}, IWorkspace.VALIDATE_PROMPT);
            if (st.getSeverity() == 4) {
                throw new ValidateEditException();
            }
            try {
                file.create((InputStream)new ByteArrayInputStream(new byte[0]), true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {
                throw new ValidateEditException();
            }
        }
        if (!this.sourceEditor.validateEditorInputState()) {
            throw new ValidateEditException();
        }
    }

    public void validateSave() {
        if (!this.sourceEditor.validateEditorInputState()) {
            throw new ValidateEditException();
        }
    }

    public <A> A adapt(Class<A> adapterType) {
        Object result = null;
        if (adapterType == ITextEditor.class) {
            result = this.getXmlEditor();
        } else if (adapterType == File.class) {
            IEditorInput input = this.sourceEditor.getEditorInput();
            if (input instanceof FileEditorInput) {
                result = ((FileEditorInput)input).getFile().getLocation().toFile();
            } else {
                URI uri = ((FileStoreEditorInput)input).getURI();
                result = new File(uri);
            }
        } else if (adapterType == IFile.class) {
            IEditorInput input = this.sourceEditor.getEditorInput();
            if (input instanceof FileEditorInput) {
                result = ((FileEditorInput)input).getFile();
            }
        } else if (adapterType == IProject.class) {
            IEditorInput input = this.sourceEditor.getEditorInput();
            if (input instanceof FileEditorInput) {
                result = ((FileEditorInput)input).getFile().getProject();
            }
        } else {
            result = super.adapt(adapterType);
        }
        return (A)result;
    }

    public void registerRootModelElement(IModelElement rootModelElement) {
        this.rootModelElement = rootModelElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerModelElement(Node xmlNode, IModelElement modelElement) {
        Map<Node, IModelElement> map = this.nodeToModelElementMap;
        synchronized (map) {
            this.nodeToModelElementMap.put(xmlNode, modelElement);
            modelElement.addListener(this.modelElementDisposeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleElementDisposed(IModelElement element) {
        XmlElement xmlElement;
        Resource resource = element.resource();
        if (resource instanceof XmlResource && (xmlElement = ((XmlResource)resource).getXmlElement()) != null) {
            Map<Node, IModelElement> map = this.nodeToModelElementMap;
            synchronized (map) {
                Element xmlNode = xmlElement.getDomNode();
                IModelElement registeredModelElement = this.nodeToModelElementMap.get(xmlNode);
                if (registeredModelElement == element) {
                    this.nodeToModelElementMap.remove(xmlNode);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IModelElement getModelElement(Node xmlNode) {
        Map<Node, IModelElement> map = this.nodeToModelElementMap;
        synchronized (map) {
            Node node = xmlNode;
            IModelElement modelElement = this.nodeToModelElementMap.get(node);
            while (modelElement == null && node != null && !(node instanceof Document)) {
                node = node.getParentNode();
                modelElement = this.nodeToModelElementMap.get(node);
            }
            if (modelElement == null) {
                modelElement = this.rootModelElement;
            }
            return modelElement;
        }
    }

    protected void handleXmlNodeChange(Node xmlNode) {
        this.handleXmlNodeChange(xmlNode, this.getModelElement(xmlNode));
    }

    protected void handleXmlNodeChange(Node xmlNode, IModelElement nearestMatchModelElement) {
        DelayedTasksExecutor.schedule(new RefreshElementTask(nearestMatchModelElement));
    }

    private static void addAdapter(IDOMNode node, INodeAdapter adapter) {
        node.addAdapter(adapter);
        NodeList children = node.getChildNodes();
        int i = 0;
        int n = children.getLength();
        while (i < n) {
            XmlEditorResourceStore.addAdapter((IDOMNode)children.item(i), adapter);
            ++i;
        }
    }

    protected static final class RefreshElementTask
    extends DelayedTasksExecutor.Task {
        private final IModelElement element;

        public RefreshElementTask(IModelElement element) {
            this.element = element;
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof RefreshElementTask) {
                return this.element == ((RefreshElementTask)obj).element;
            }
            return false;
        }

        public int hashCode() {
            return this.element.hashCode();
        }

        public boolean subsumes(DelayedTasksExecutor.Task task) {
            boolean result = super.subsumes(task);
            if (!result && task instanceof RefreshPropertyTask && this.element == ((RefreshPropertyTask)task).element) {
                return true;
            }
            return result;
        }

        public void run() {
            this.element.refresh(false, true);
        }
    }

    protected static final class RefreshPropertyTask
    extends DelayedTasksExecutor.Task {
        private final IModelElement element;
        private final ModelProperty property;

        public RefreshPropertyTask(IModelElement element, ModelProperty property) {
            this.element = element;
            this.property = property;
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof RefreshPropertyTask) {
                RefreshPropertyTask task = (RefreshPropertyTask)obj;
                return this.element == task.element && this.property == task.property;
            }
            return false;
        }

        public int hashCode() {
            return this.element.hashCode() + this.property.hashCode();
        }

        public void run() {
            this.element.refresh(this.property, false, true);
        }
    }

    private final class Scrubber
    extends Thread {
        private boolean stopRequested = false;

        private Scrubber() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Map nodeToModelElementMap = XmlEditorResourceStore.this.nodeToModelElementMap;
            while (true) {
                Object object = this;
                synchronized (object) {
                    try {
                        Scrubber.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    if (this.stopRequested) {
                        return;
                    }
                }
                object = nodeToModelElementMap;
                synchronized (object) {
                    Iterator itr = nodeToModelElementMap.entrySet().iterator();
                    while (itr.hasNext()) {
                        Map.Entry entry = itr.next();
                        if (((Node)entry.getKey()).getParentNode() != null) continue;
                        itr.remove();
                    }
                }
            }
        }

        public synchronized void dispose() {
            this.stopRequested = true;
        }
    }
}

