/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.ElementProperty;
import org.eclipse.sapphire.modeling.EnablementService;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ImpliedElementProperty;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelElementDisposedEvent;
import org.eclipse.sapphire.modeling.ModelElementHandle;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelElementListener;
import org.eclipse.sapphire.modeling.ModelElementService;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelParticle;
import org.eclipse.sapphire.modeling.ModelPath;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelPropertyChangeEvent;
import org.eclipse.sapphire.modeling.ModelPropertyListener;
import org.eclipse.sapphire.modeling.ModelPropertyService;
import org.eclipse.sapphire.modeling.PossibleValuesService;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.SapphireMultiStatus;
import org.eclipse.sapphire.modeling.Transient;
import org.eclipse.sapphire.modeling.TransientProperty;
import org.eclipse.sapphire.modeling.ValidationStateChangeEvent;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.internal.SapphireModelingExtensionSystem;
import org.eclipse.sapphire.modeling.internal.SapphireModelingFrameworkPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModelElement
extends ModelParticle
implements IModelElement {
    private final ModelElementType type;
    private final ModelProperty parentProperty;
    private IStatus valres;
    private Set<ModelElementListener> listeners;
    private Map<ModelProperty, Set<ModelPropertyListener>> propertyListeners;
    private final Map<ModelProperty, Boolean> enablementStatuses;
    private final Map<Class<? extends ModelElementService>, ModelElementService> elementServices;
    private final Map<PropertyServiceKey, ModelPropertyService> propertyServices;

    public ModelElement(ModelElementType type, IModelParticle parent, ModelProperty parentProperty, Resource resource) {
        super(parent, resource);
        this.type = type;
        this.parentProperty = parentProperty;
        this.valres = null;
        this.listeners = null;
        this.propertyListeners = null;
        this.enablementStatuses = new HashMap<ModelProperty, Boolean>();
        this.elementServices = new HashMap<Class<? extends ModelElementService>, ModelElementService>();
        this.propertyServices = new HashMap<PropertyServiceKey, ModelPropertyService>();
        resource.init(this);
        final HashMap<ModelProperty, 1> refreshListeners = new HashMap<ModelProperty, 1>();
        for (final ModelProperty property : type.getProperties()) {
            PossibleValuesService possibleValuesProvider;
            Set<ModelPath> dependencies = property.getDependencies();
            if (!dependencies.isEmpty()) {
                ModelPropertyListener listener = new ModelPropertyListener(){

                    public void handlePropertyChangedEvent(ModelPropertyChangeEvent event) {
                        ModelElement.this.refresh(property);
                    }
                };
                refreshListeners.put(property, listener);
                for (ModelPath depPath : dependencies) {
                    this.addListener(listener, depPath);
                }
            }
            if (!(property instanceof ValueProperty) || (possibleValuesProvider = this.service(property, PossibleValuesService.class)) == null) continue;
            possibleValuesProvider.addListener(new PossibleValuesService.Listener(){

                public void handlePossibleValuesChangedEvent(PossibleValuesService.PossibleValuesChangedEvent event) {
                    ModelElement.this.refresh(property);
                }
            });
        }
        if (!refreshListeners.isEmpty()) {
            ModelElementListener disposeListener = new ModelElementListener(){

                public void handleElementDisposedEvent(ModelElementDisposedEvent event) {
                    for (Map.Entry entry : refreshListeners.entrySet()) {
                        ModelProperty property = (ModelProperty)entry.getKey();
                        ModelPropertyListener listener = (ModelPropertyListener)entry.getValue();
                        for (ModelPath depPath : property.getDependencies()) {
                            ModelElement.this.removeListener(listener, depPath);
                        }
                    }
                }
            };
            this.addListener(disposeListener);
        }
    }

    @Override
    public ModelElementType getModelElementType() {
        return this.type;
    }

    @Override
    public ModelProperty getParentProperty() {
        return this.parentProperty;
    }

    @Override
    public Object read(ModelProperty property) {
        String msg = NLS.bind((String)Resources.cannotReadProperty, (Object)property.getName());
        throw new IllegalArgumentException(msg);
    }

    @Override
    public final <T> Value<T> read(ValueProperty property) {
        return (Value)this.read((ModelProperty)property);
    }

    @Override
    public final <T extends IModelElement> ModelElementHandle<T> read(ElementProperty property) {
        return (ModelElementHandle)this.read((ModelProperty)property);
    }

    @Override
    public final <T extends IModelElement> T read(ImpliedElementProperty property) {
        return (T)((IModelElement)this.read((ModelProperty)property));
    }

    @Override
    public final <T extends IModelElement> ModelElementList<T> read(ListProperty property) {
        return (ModelElementList)this.read((ModelProperty)property);
    }

    @Override
    public final <T> Transient<T> read(TransientProperty property) {
        return (Transient)this.read((ModelProperty)property);
    }

    @Override
    public final SortedSet<String> read(ModelPath path) {
        TreeSet<String> result = new TreeSet<String>();
        this.read(path, result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void read(ModelPath path, Collection<String> result) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            ModelPath.Segment head = path.head();
            if (head instanceof ModelPath.ModelRootSegment) {
                ((IModelElement)this.root()).read(path.tail(), result);
            } else if (head instanceof ModelPath.ParentElementSegment) {
                IModelParticle parent = this.parent();
                if (parent == null) {
                    this.logInvalidModelPathMessage(path);
                    return;
                }
                if (parent instanceof ModelElementList) {
                    parent = parent.parent();
                }
                ((IModelElement)parent).read(path.tail(), result);
            } else if (head instanceof ModelPath.AllSiblingsSegment) {
                IModelParticle parent = this.parent();
                if (parent == null || !(parent instanceof ModelElementList)) {
                    this.logInvalidModelPathMessage(path);
                    return;
                }
                parent = parent.parent();
                ModelPath p = new ModelPath(this.getParentProperty().getName()).append(path.tail());
                ((IModelElement)parent).read(p, result);
            } else if (head instanceof ModelPath.AllDescendentsSegment) {
                for (ModelProperty property : this.getModelElementType().getProperties()) {
                    Object obj = this.read(property);
                    if (obj instanceof Value) {
                        String val = ((Value)obj).getText();
                        if (val == null) continue;
                        result.add(val);
                        continue;
                    }
                    if (obj instanceof IModelElement) {
                        ((IModelElement)obj).read(path, result);
                        continue;
                    }
                    if (!(obj instanceof ModelElementList)) continue;
                    for (IModelElement entry : (ModelElementList)obj) {
                        entry.read(path, result);
                    }
                }
            } else if (head instanceof ModelPath.TypeFilterSegment) {
                String t = this.getModelElementType().getSimpleName();
                boolean match = false;
                for (String type : ((ModelPath.TypeFilterSegment)head).getTypes()) {
                    if (!type.equalsIgnoreCase(t)) continue;
                    match = true;
                    break;
                }
                if (match) {
                    this.read(path.tail(), result);
                }
            } else {
                String propertyName = ((ModelPath.PropertySegment)head).getPropertyName();
                ModelProperty property = this.getModelElementType().getProperty(propertyName);
                if (property == null) {
                    this.logInvalidModelPathMessage(path);
                    return;
                }
                Object obj = this.read(property);
                if (obj instanceof Value) {
                    String val = ((Value)obj).getText();
                    if (val != null) {
                        result.add(val);
                    }
                    if (path.length() != 1) {
                        this.logInvalidModelPathMessage(path);
                        return;
                    }
                } else if (obj instanceof IModelElement) {
                    ((IModelElement)obj).read(path.tail(), result);
                } else if (obj instanceof ModelElementList) {
                    for (IModelElement entry : (ModelElementList)obj) {
                        entry.read(path.tail(), result);
                    }
                }
            }
        }
    }

    @Override
    public void write(ValueProperty property, Object value) {
        String msg = NLS.bind((String)Resources.cannotWriteProperty, (Object)property.getName());
        throw new IllegalArgumentException(msg);
    }

    @Override
    public void write(TransientProperty property, Object value) {
        String msg = NLS.bind((String)Resources.cannotWriteProperty, (Object)property.getName());
        throw new IllegalArgumentException(msg);
    }

    @Override
    public final void refresh() {
        this.refresh(false, false);
    }

    @Override
    public final void refresh(boolean force) {
        this.refresh(force, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void refresh(boolean force, boolean deep) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            for (ModelProperty property : this.getModelElementType().getProperties()) {
                this.refresh(property, force, deep);
            }
        }
    }

    @Override
    public final void refresh(ModelProperty property) {
        this.refresh(property, false, false);
    }

    @Override
    public final void refresh(ModelProperty property, boolean force) {
        this.refresh(property, force, false);
    }

    @Override
    public final void refresh(ModelProperty property, boolean force, boolean deep) {
        this.refreshProperty(property, force);
        if (deep) {
            if (property instanceof ElementProperty) {
                Object child = property instanceof ImpliedElementProperty ? this.read((ImpliedElementProperty)property) : this.read((ElementProperty)property).element();
                if (child != null) {
                    child.refresh(force, true);
                }
            } else if (property instanceof ListProperty) {
                for (IModelElement child : this.read((ListProperty)property)) {
                    child.refresh(force, true);
                }
            }
        }
    }

    protected void refreshProperty(ModelProperty property, boolean force) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <S extends ModelElementService> S service(Class<S> serviceType) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            ModelElementService service = this.elementServices.get(serviceType);
            if (service == null && (service = SapphireModelingExtensionSystem.createModelElementService(this, serviceType)) != null) {
                service.init(this);
                this.elementServices.put(serviceType, service);
            }
            return (S)service;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <S extends ModelPropertyService> S service(ModelProperty property, Class<S> serviceType) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            PropertyServiceKey key = new PropertyServiceKey(property, serviceType);
            ModelPropertyService service = this.propertyServices.get(key);
            if (service == null && (service = SapphireModelingExtensionSystem.createModelPropertyService(this, property, serviceType)) != null) {
                this.propertyServices.put(key, service);
            }
            return (S)service;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isPropertyEnabled(ModelProperty property) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            Boolean status = this.enablementStatuses.get(property);
            if (status == null) {
                this.refreshPropertyEnabledStatus(property);
                status = this.enablementStatuses.get(property);
            }
            return status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean refreshPropertyEnabledStatus(ModelProperty property) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            Boolean oldStatus = this.enablementStatuses.get(property);
            boolean newStatus = this.service(property, EnablementService.class).isEnabled();
            this.enablementStatuses.put(property, newStatus);
            return oldStatus != null && !oldStatus.equals(newStatus);
        }
    }

    @Override
    public IStatus validate() {
        if (this.valres == null) {
            this.refreshValidationResult();
        }
        return this.valres;
    }

    private void refreshValidationResult() {
        SapphireMultiStatus st = new SapphireMultiStatus();
        for (ModelProperty property : this.type.getProperties()) {
            IStatus x;
            if (!this.service(property, EnablementService.class).isEnabled()) continue;
            if (property instanceof ValueProperty) {
                x = this.read((ValueProperty)property).validate();
            } else if (property instanceof ListProperty) {
                x = this.read((ListProperty)property).validate();
            } else if (property instanceof ImpliedElementProperty) {
                x = this.read((ImpliedElementProperty)property).validate();
            } else if (property instanceof ElementProperty) {
                x = this.read((ElementProperty)property).validate();
            } else if (property instanceof TransientProperty) {
                x = this.read((TransientProperty)property).validate();
            } else {
                throw new IllegalStateException();
            }
            st.add(x);
        }
        if (this.valres == null) {
            this.valres = st;
        } else if (!this.valres.equals((Object)st)) {
            IStatus oldValidationState = this.valres;
            this.valres = st;
            this.notifyValidationStateChangeListeners(oldValidationState, this.valres);
            IModelParticle parent = this.parent();
            if (parent != null && parent instanceof IModelElement) {
                ((IModelElement)parent).notifyPropertyChangeListeners(this.parentProperty);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addListener(ModelElementListener listener) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.listeners == null) {
                this.listeners = new CopyOnWriteArraySet<ModelElementListener>();
            }
            this.listeners.add(listener);
        }
    }

    @Override
    public final void addListener(ModelPropertyListener listener, String path) {
        this.addListener(listener, new ModelPath(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addListener(ModelPropertyListener listener, ModelPath path) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            ModelPath.Segment head = path.head();
            if (head instanceof ModelPath.ModelRootSegment) {
                ((IModelElement)this.root()).addListener(listener, path.tail());
            } else if (head instanceof ModelPath.ParentElementSegment) {
                IModelParticle parent = this.parent();
                if (parent == null) {
                    this.logInvalidModelPathMessage(path);
                    return;
                }
                if (parent instanceof ModelElementList) {
                    parent = parent.parent();
                }
                ((IModelElement)parent).addListener(listener, path.tail());
            } else if (head instanceof ModelPath.AllSiblingsSegment) {
                IModelParticle parent = this.parent();
                if (parent == null || !(parent instanceof ModelElementList)) {
                    this.logInvalidModelPathMessage(path);
                    return;
                }
                parent = parent.parent();
                ModelPath p = new ModelPath(this.parentProperty.getName()).append(path.tail());
                ((IModelElement)parent).addListener(listener, p);
            } else if (head instanceof ModelPath.AllDescendentsSegment) {
                for (ModelProperty property : this.type.getProperties()) {
                    PropagationListener pListener;
                    Set<ModelPropertyListener> listeners = this.getListenersForEdit(property);
                    listeners.add(listener);
                    if (!(property instanceof ListProperty) && !(property instanceof ElementProperty) || !listeners.add(pListener = new PropagationListener(property, path, listener))) continue;
                    pListener.handlePropertyChangedEvent(null);
                }
            } else if (head instanceof ModelPath.TypeFilterSegment) {
                String t = this.type.getSimpleName();
                boolean match = false;
                for (String type : ((ModelPath.TypeFilterSegment)head).getTypes()) {
                    if (!type.equalsIgnoreCase(t)) continue;
                    match = true;
                    break;
                }
                if (match) {
                    this.addListener(listener, path.tail());
                }
            } else {
                String propertyName = ((ModelPath.PropertySegment)head).getPropertyName();
                ModelProperty property = this.type.getProperty(propertyName);
                if (property == null) {
                    this.logInvalidModelPathMessage(path);
                    return;
                }
                Set<ModelPropertyListener> listeners = this.getListenersForEdit(property);
                if (path.length() == 1) {
                    listeners.add(listener);
                } else {
                    PropagationListener pListener;
                    if (property instanceof ValueProperty) {
                        this.logInvalidModelPathMessage(path);
                        return;
                    }
                    if ((property instanceof ListProperty || property instanceof ElementProperty) && listeners.add(pListener = new PropagationListener(property, path.tail(), listener))) {
                        pListener.handlePropertyChangedEvent(null);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeListener(ModelElementListener listener) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.listeners != null) {
                this.listeners.remove(listener);
            }
        }
    }

    @Override
    public final void removeListener(ModelPropertyListener listener, String path) {
        this.removeListener(listener, new ModelPath(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeListener(ModelPropertyListener listener, ModelPath path) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            ModelPath.Segment head = path.head();
            if (head instanceof ModelPath.ModelRootSegment) {
                ((IModelElement)this.root()).removeListener(listener, path.tail());
            } else if (head instanceof ModelPath.ParentElementSegment) {
                IModelParticle parent = this.parent();
                if (parent == null) {
                    this.logInvalidModelPathMessage(path);
                    return;
                }
                if (parent instanceof ModelElementList) {
                    parent = parent.parent();
                }
                ((IModelElement)parent).removeListener(listener, path.tail());
            } else if (head instanceof ModelPath.AllSiblingsSegment) {
                IModelParticle parent = this.parent();
                if (parent == null || !(parent instanceof ModelElementList)) {
                    this.logInvalidModelPathMessage(path);
                    return;
                }
                parent = parent.parent();
                ModelPath p = new ModelPath(this.parentProperty.getName()).append(path.tail());
                ((IModelElement)parent).removeListener(listener, p);
            } else if (head instanceof ModelPath.AllDescendentsSegment) {
                for (ModelProperty property : this.type.getProperties()) {
                    Set<ModelPropertyListener> listeners = this.getListenersForEdit(property);
                    listeners.remove(listener);
                    if (property instanceof ValueProperty) continue;
                    PropagationListener pListener = new PropagationListener(property, path, listener);
                    listeners.remove(pListener);
                    if (property instanceof ElementProperty) {
                        Object element = this.read((ElementProperty)property).element();
                        if (element == null) continue;
                        element.removeListener(listener, path);
                        continue;
                    }
                    if (!(property instanceof ListProperty)) continue;
                    ModelElementList list = this.read((ListProperty)property);
                    for (IModelElement x : list) {
                        x.removeListener(listener, path);
                    }
                }
            } else if (head instanceof ModelPath.TypeFilterSegment) {
                String t = this.type.getSimpleName();
                boolean match = false;
                for (String type : ((ModelPath.TypeFilterSegment)head).getTypes()) {
                    if (!type.equalsIgnoreCase(t)) continue;
                    match = true;
                    break;
                }
                if (match) {
                    this.removeListener(listener, path.tail());
                }
            } else {
                String propertyName = ((ModelPath.PropertySegment)head).getPropertyName();
                ModelProperty property = this.type.getProperty(propertyName);
                if (property == null) {
                    this.logInvalidModelPathMessage(path);
                    return;
                }
                Set<ModelPropertyListener> listeners = this.getListenersForEdit(property);
                if (path.length() == 1) {
                    listeners.remove(listener);
                } else {
                    PropagationListener pListener = new PropagationListener(property, path.tail(), listener);
                    listeners.remove(pListener);
                    ModelPath tail = path.tail();
                    if (property instanceof ElementProperty) {
                        Object element = this.read((ElementProperty)property).element();
                        if (element != null) {
                            element.removeListener(listener, tail);
                        }
                    } else if (property instanceof ListProperty) {
                        ModelElementList list = this.read((ListProperty)property);
                        for (IModelElement x : list) {
                            x.removeListener(listener, tail);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void notifyPropertyChangeListeners(ModelProperty property) {
        ModelPropertyChangeEvent event = new ModelPropertyChangeEvent(this, property);
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            Set<ModelPropertyListener> set;
            if (this.valres != null) {
                this.refreshValidationResult();
            }
            if (this.listeners != null) {
                for (ModelElementListener modelElementListener : this.listeners) {
                    try {
                        modelElementListener.propertyChanged(event);
                    }
                    catch (Exception e) {
                        SapphireModelingFrameworkPlugin.log(e);
                    }
                }
            }
            if (this.propertyListeners != null && (set = this.propertyListeners.get(property)) != null) {
                for (ModelPropertyListener listener : set) {
                    try {
                        listener.handlePropertyChangedEvent(event);
                    }
                    catch (Exception e) {
                        SapphireModelingFrameworkPlugin.log(e);
                    }
                }
            }
            for (ModelPropertyListener modelPropertyListener : property.getListeners()) {
                try {
                    modelPropertyListener.handlePropertyChangedEvent(event);
                }
                catch (Exception e) {
                    SapphireModelingFrameworkPlugin.log(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyValidationStateChangeListeners(IStatus oldValidationState, IStatus newValidationState) {
        ValidationStateChangeEvent event = new ValidationStateChangeEvent(this, oldValidationState, newValidationState);
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.listeners != null) {
                for (ModelElementListener listener : this.listeners) {
                    try {
                        listener.validationStateChanged(event);
                    }
                    catch (Exception e) {
                        SapphireModelingFrameworkPlugin.log(e);
                    }
                }
            }
        }
    }

    private Set<ModelPropertyListener> getListenersForEdit(ModelProperty property) {
        Set<ModelPropertyListener> set;
        if (this.propertyListeners == null) {
            this.propertyListeners = new HashMap<ModelProperty, Set<ModelPropertyListener>>();
        }
        set = (set = this.propertyListeners.get(property)) == null ? new HashSet<ModelPropertyListener>() : new HashSet<ModelPropertyListener>(set);
        this.propertyListeners.put(property, set);
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void dispose() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.listeners != null) {
                ModelElementDisposedEvent event = new ModelElementDisposedEvent(this);
                for (ModelElementListener listener : this.listeners) {
                    try {
                        listener.handleElementDisposedEvent(event);
                    }
                    catch (Exception e) {
                        SapphireModelingFrameworkPlugin.log(e);
                    }
                }
            }
        }
    }

    private void logInvalidModelPathMessage(ModelPath path) {
        String message = NLS.bind((String)Resources.invalidModelPath, (Object)this.type.getModelElementClass().getName(), (Object)path.toString());
        SapphireModelingFrameworkPlugin.logError(message, null);
    }

    protected static final boolean equal(String value1, String value2) {
        String val1 = ModelElement.normalize(value1);
        String val2 = ModelElement.normalize(value2);
        boolean valuesAreEqual = false;
        if (val1 == val2) {
            valuesAreEqual = true;
        } else if (val1 != null && val2 != null) {
            valuesAreEqual = val1.equals(val2);
        }
        return valuesAreEqual;
    }

    protected static final String normalize(String value) {
        if (value != null && value.equals("")) {
            return null;
        }
        return value;
    }

    private final class PropagationListener
    extends ModelPropertyListener {
        private final ModelProperty property;
        private final ModelPath path;
        private final ModelPropertyListener listener;

        public PropagationListener(ModelProperty property, ModelPath path, ModelPropertyListener listener) {
            if (property instanceof ValueProperty) {
                throw new IllegalArgumentException();
            }
            this.property = property;
            this.path = path;
            this.listener = listener;
        }

        public boolean equals(Object obj) {
            if (obj instanceof PropagationListener) {
                PropagationListener pl = (PropagationListener)obj;
                return this.property == pl.property && this.path.equals(pl.path) && this.listener == pl.listener;
            }
            return false;
        }

        public int hashCode() {
            return this.property.hashCode() ^ this.path.hashCode();
        }

        public void handlePropertyChangedEvent(ModelPropertyChangeEvent event) {
            if (this.property instanceof ElementProperty) {
                Object element = this.property instanceof ImpliedElementProperty ? ModelElement.this.read((ImpliedElementProperty)this.property) : ModelElement.this.read((ElementProperty)this.property).element();
                if (element != null) {
                    element.addListener(this.listener, this.path);
                }
            } else {
                ModelElementList list = ModelElement.this.read((ListProperty)this.property);
                for (IModelElement x : list) {
                    x.addListener(this.listener, this.path);
                }
            }
            this.listener.handlePropertyChangedEvent(event);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PropertyServiceKey {
        private final ModelProperty property;
        private final Class<? extends ModelPropertyService> serviceType;

        public PropertyServiceKey(ModelProperty property, Class<? extends ModelPropertyService> serviceType) {
            this.property = property;
            this.serviceType = serviceType;
        }

        public boolean equals(Object obj) {
            if (obj instanceof PropertyServiceKey) {
                PropertyServiceKey key = (PropertyServiceKey)obj;
                return this.property.equals(key.property) && this.serviceType.equals(key.serviceType);
            }
            return false;
        }

        public int hashCode() {
            return this.property.hashCode() ^ this.serviceType.hashCode();
        }
    }

    private static final class Resources
    extends NLS {
        public static String invalidModelPath;
        public static String cannotReadProperty;
        public static String cannotWriteProperty;

        static {
            Resources.initializeMessages((String)ModelElement.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

