/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.localization.LocalizationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModelMetadataItem {
    public ModelMetadataItem getBase() {
        return null;
    }

    public <A extends Annotation> List<A> getAnnotations(Class<A> type) {
        A annotation = this.getAnnotation(type, false);
        return annotation == null ? Collections.emptyList() : Collections.singletonList(annotation);
    }

    public abstract <A extends Annotation> A getAnnotation(Class<A> var1, boolean var2);

    public final <A extends Annotation> A getAnnotation(Class<A> type) {
        return this.getAnnotation(type, false);
    }

    public final boolean hasAnnotation(Class<? extends Annotation> type, boolean localOnly) {
        return this.getAnnotation(type, localOnly) != null;
    }

    public final boolean hasAnnotation(Class<? extends Annotation> type) {
        return this.getAnnotation(type) != null;
    }

    public final String getLabel(boolean longLabel, CapitalizationType capitalizationType, boolean includeMnemonic) {
        String labelText = null;
        Label labelAnnotation = this.getAnnotation(Label.class, true);
        if (labelAnnotation != null) {
            if (longLabel) {
                labelText = labelAnnotation.full().trim();
            }
            if (labelText == null || labelText.length() == 0) {
                labelText = labelAnnotation.standard().trim();
            }
        }
        boolean transformNeeded = true;
        if (labelText == null) {
            ModelMetadataItem base = this.getBase();
            if (base != null) {
                labelText = base.getLabel(longLabel, capitalizationType, includeMnemonic);
                transformNeeded = false;
            } else {
                labelText = this.getDefaultLabel();
            }
        }
        if (transformNeeded) {
            labelText = this.getLocalizationService().text(labelText, capitalizationType, includeMnemonic);
        }
        return labelText;
    }

    protected abstract String getDefaultLabel();

    public abstract LocalizationService getLocalizationService();
}

