/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.annotations.processor;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.declaration.InterfaceDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.ArrayType;
import com.sun.mirror.type.ClassType;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.InterfaceType;
import com.sun.mirror.type.MirroredTypeException;
import com.sun.mirror.type.PrimitiveType;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.type.VoidType;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.sapphire.modeling.DerivedValueService;
import org.eclipse.sapphire.modeling.ElementProperty;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ImpliedElementProperty;
import org.eclipse.sapphire.modeling.ListBindingImpl;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelElement;
import org.eclipse.sapphire.modeling.ModelElementHandle;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ReferenceValue;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.Transient;
import org.eclipse.sapphire.modeling.TransientProperty;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DelegateImplementation;
import org.eclipse.sapphire.modeling.annotations.DerivedValue;
import org.eclipse.sapphire.modeling.annotations.GenerateImpl;
import org.eclipse.sapphire.modeling.annotations.Reference;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.annotations.processor.SapphireAnnotationsProcessor;
import org.eclipse.sapphire.modeling.annotations.processor.util.AccessModifier;
import org.eclipse.sapphire.modeling.annotations.processor.util.Body;
import org.eclipse.sapphire.modeling.annotations.processor.util.ClassModel;
import org.eclipse.sapphire.modeling.annotations.processor.util.FieldModel;
import org.eclipse.sapphire.modeling.annotations.processor.util.IndentingPrintWriter;
import org.eclipse.sapphire.modeling.annotations.processor.util.MethodModel;
import org.eclipse.sapphire.modeling.annotations.processor.util.MethodParameterModel;
import org.eclipse.sapphire.modeling.annotations.processor.util.ParameterizedTypeReference;
import org.eclipse.sapphire.modeling.annotations.processor.util.TypeReference;
import org.eclipse.sapphire.modeling.annotations.processor.util.WildcardTypeReference;
import org.eclipse.sapphire.modeling.serialization.ValueSerializationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GenerateImplProcessor
extends SapphireAnnotationsProcessor {
    private static final String DATA_READ_METHOD = "read.method";
    private static final String DATA_WRITE_VALUE_METHOD = "write.value.method";
    private static final String DATA_WRITE_TRANSIENT_METHOD = "write.transient.method";
    private static final String DATA_REFRESH_METHOD = "refresh.method";
    private static final String DATA_HAS_CONTENTS = "has.contents";

    @Override
    public void process(AnnotationProcessorEnvironment env, Declaration annotatedEntity, AnnotationMirror annotation) {
        try {
            if (annotation == null || annotatedEntity == null) {
                return;
            }
            if (!(annotatedEntity instanceof InterfaceDeclaration)) {
                return;
            }
            InterfaceDeclaration interfaceDeclaration = (InterfaceDeclaration)annotatedEntity;
            ClassModel implClassModel = new ClassModel();
            this.process(implClassModel, interfaceDeclaration);
            PrintWriter pw = env.getFiler().createSourceFile(implClassModel.getName().getQualifiedName());
            try {
                implClassModel.write(new IndentingPrintWriter(pw));
            }
            finally {
                pw.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static boolean isInstanceOf(TypeMirror type, String interfaceOrClass) {
        if (type instanceof DeclaredType) {
            DeclaredType declaredType = (DeclaredType)type;
            return GenerateImplProcessor.isInstanceOf(declaredType.getDeclaration(), interfaceOrClass);
        }
        return false;
    }

    protected static boolean isInstanceOf(TypeDeclaration type, String interfaceOrClass) {
        if (type != null) {
            ClassType superClassType;
            if (type.getQualifiedName().equals(interfaceOrClass)) {
                return true;
            }
            if (type instanceof ClassDeclaration && (superClassType = ((ClassDeclaration)type).getSuperclass()) != null && GenerateImplProcessor.isInstanceOf((TypeDeclaration)superClassType.getDeclaration(), interfaceOrClass)) {
                return true;
            }
            for (InterfaceType superInterface : type.getSuperinterfaces()) {
                if (!GenerateImplProcessor.isInstanceOf((TypeMirror)superInterface, interfaceOrClass)) continue;
                return true;
            }
        }
        return false;
    }

    private void process(final ClassModel elImplClass, InterfaceDeclaration elInterface) {
        MethodModel mWriteTransient;
        MethodModel mWriteValue;
        MethodModel mRead;
        String simpleName = elInterface.getSimpleName().substring(1);
        String defaultPackageName = String.valueOf(elInterface.getPackage().getQualifiedName()) + ".internal";
        GenerateImpl generateImplAnnotation = (GenerateImpl)elInterface.getAnnotation(GenerateImpl.class);
        String packageName = generateImplAnnotation.packageName();
        if (packageName.length() == 0) {
            packageName = defaultPackageName;
        }
        elImplClass.setName(new TypeReference(packageName, simpleName));
        elImplClass.addInterface(new TypeReference(elInterface.getQualifiedName()));
        elImplClass.setBaseClass(new TypeReference(ModelElement.class.getName()));
        MethodModel c1 = elImplClass.addConstructor();
        c1.addParameter(new MethodParameterModel("parent", IModelParticle.class));
        c1.addParameter(new MethodParameterModel("parentProperty", ModelProperty.class));
        c1.addParameter(new MethodParameterModel("resource", Resource.class));
        c1.getBody().append("super( TYPE, parent, parentProperty, resource );");
        MethodModel c2 = elImplClass.addConstructor();
        c2.addParameter(new MethodParameterModel("resource", Resource.class));
        c2.getBody().append("super( TYPE, null, null, resource );");
        final TreeMap propFields = new TreeMap();
        Visitor<FieldDeclaration> fieldsVisitor = new Visitor<FieldDeclaration>(){

            @Override
            public void visit(FieldDeclaration field) {
                String fieldName = field.getSimpleName();
                if (fieldName != null && fieldName.startsWith("PROP_")) {
                    PropertyFieldDeclaration propFieldDeclaration = (PropertyFieldDeclaration)propFields.get(fieldName);
                    if (propFieldDeclaration == null) {
                        propFieldDeclaration = new PropertyFieldDeclaration();
                        propFieldDeclaration.name = fieldName;
                        propFieldDeclaration.propertyName = GenerateImplProcessor.preparePropName(fieldName);
                        propFields.put(fieldName, propFieldDeclaration);
                    }
                    propFieldDeclaration.declarations.addFirst(field);
                }
            }
        };
        GenerateImplProcessor.visitAllFields(elInterface, fieldsVisitor);
        for (PropertyFieldDeclaration field : propFields.values()) {
            if (GenerateImplProcessor.isInstanceOf(field.getType(), ValueProperty.class.getName())) {
                this.processValueProperty(elImplClass, elInterface, field);
                continue;
            }
            if (GenerateImplProcessor.isInstanceOf(field.getType(), ElementProperty.class.getName())) {
                this.processElementProperty(elImplClass, elInterface, field);
                continue;
            }
            if (GenerateImplProcessor.isInstanceOf(field.getType(), ListProperty.class.getName())) {
                this.processListProperty(elImplClass, elInterface, field);
                continue;
            }
            if (!GenerateImplProcessor.isInstanceOf(field.getType(), TransientProperty.class.getName())) continue;
            this.processTransientProperty(elImplClass, elInterface, field);
        }
        Visitor<MethodDeclaration> methodsVisitor = new Visitor<MethodDeclaration>(){

            @Override
            public void visit(MethodDeclaration method) {
                DelegateImplementation delegateImplementationAnnotation = (DelegateImplementation)method.getAnnotation(DelegateImplementation.class);
                if (delegateImplementationAnnotation != null) {
                    MethodModel m = elImplClass.addMethod(method.getSimpleName());
                    m.setReturnType(GenerateImplProcessor.toTypeReference(method.getReturnType()));
                    for (ParameterDeclaration param : method.getParameters()) {
                        MethodParameterModel p = new MethodParameterModel();
                        p.setName(param.getSimpleName());
                        p.setType(GenerateImplProcessor.toTypeReference(param.getType()));
                        m.addParameter(p);
                    }
                    TypeReference delegate = null;
                    try {
                        delegateImplementationAnnotation.value();
                    }
                    catch (MirroredTypeException e) {
                        ClassDeclaration typeMirror = ((ClassType)e.getTypeMirror()).getDeclaration();
                        delegate = new TypeReference(typeMirror.getQualifiedName());
                    }
                    Body mb = m.getBody();
                    mb.append("synchronized( root() )");
                    mb.openBlock();
                    StringBuilder buf = new StringBuilder();
                    if (m.getReturnType() != TypeReference.VOID_TYPE) {
                        buf.append("return ");
                    }
                    buf.append(delegate.getSimpleName()).append('.').append(m.getName()).append("( this");
                    for (MethodParameterModel param : m.getParameters()) {
                        buf.append(", ");
                        buf.append(param.getName());
                    }
                    buf.append(" );");
                    mb.append(buf.toString());
                    mb.closeBlock();
                    elImplClass.addImport(delegate);
                }
            }
        };
        GenerateImplProcessor.visitAllMethods(elInterface, methodsVisitor);
        MethodModel mRefresh = GenerateImplProcessor.getRefreshMethod(elImplClass, false);
        if (mRefresh != null) {
            elImplClass.removeMethod(mRefresh);
            elImplClass.addMethod(mRefresh);
            mRefresh.getBody().closeBlock();
        }
        if ((mRead = GenerateImplProcessor.getReadMethod(elImplClass, false)) != null) {
            elImplClass.removeMethod(mRead);
            elImplClass.addMethod(mRead);
            mRead.getBody().appendEmptyLine();
            mRead.getBody().append("return super.read( property );");
        }
        if ((mWriteValue = GenerateImplProcessor.getValueWriteMethod(elImplClass, false)) != null) {
            elImplClass.removeMethod(mWriteValue);
            elImplClass.addMethod(mWriteValue);
            mWriteValue.getBody().appendEmptyLine();
            mWriteValue.getBody().append("super.write( property, value );");
        }
        if ((mWriteTransient = GenerateImplProcessor.getTransientWriteMethod(elImplClass, false)) != null) {
            elImplClass.removeMethod(mWriteTransient);
            elImplClass.addMethod(mWriteTransient);
            mWriteTransient.getBody().appendEmptyLine();
            mWriteTransient.getBody().append("super.write( property, object );");
        }
    }

    private void processValueProperty(ClassModel implClassModel, InterfaceDeclaration interfaceDeclaration, PropertyFieldDeclaration propField) {
        try {
            this.processValuePropertyInternal(implClassModel, interfaceDeclaration, propField);
        }
        catch (RuntimeException e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            InterfaceDeclaration modelElementInterface = propField.getDeclaringType();
            pw.println();
            pw.println("RuntimeException encountered during processValueProperty() method call.");
            pw.println();
            pw.println("interfaceDeclaration : " + (modelElementInterface == null ? "null" : modelElementInterface.getQualifiedName()));
            pw.println("propField : " + propField.name);
            pw.println();
            e.printStackTrace(pw);
            pw.println();
            pw.flush();
            System.err.println(sw.getBuffer().toString());
            throw e;
        }
    }

    private void processValuePropertyInternal(ClassModel implClassModel, InterfaceDeclaration interfaceDeclaration, PropertyFieldDeclaration propField) {
        TypeReference baseType = null;
        ParameterizedTypeReference wrapperType = null;
        Reference referenceAnnotation = propField.getAnnotation(Reference.class);
        if (referenceAnnotation != null) {
            baseType = new TypeReference(String.class);
            try {
                referenceAnnotation.target();
            }
            catch (MirroredTypeException e) {
                TypeMirror mirror = e.getTypeMirror();
                TypeReference targetType = GenerateImplProcessor.toTypeReference(mirror);
                Collection typeParams = mirror instanceof TypeDeclaration ? ((TypeDeclaration)mirror).getFormalTypeParameters() : ((DeclaredType)mirror).getDeclaration().getFormalTypeParameters();
                if (!typeParams.isEmpty()) {
                    Object[] params = new TypeReference[typeParams.size()];
                    Arrays.fill(params, WildcardTypeReference.INSTANCE);
                    targetType = targetType.parameterize((TypeReference[])params);
                }
                wrapperType = new TypeReference(ReferenceValue.class).parameterize(targetType);
            }
        } else {
            Type typeAnnotation = propField.getAnnotation(Type.class);
            if (typeAnnotation == null) {
                baseType = new TypeReference(String.class);
            } else {
                try {
                    typeAnnotation.base();
                }
                catch (MirroredTypeException e) {
                    baseType = GenerateImplProcessor.toTypeReference(e.getTypeMirror());
                }
            }
            wrapperType = new TypeReference(Value.class).parameterize(baseType);
        }
        boolean hasDerivedValueProviderAnnotation = propField.getAnnotation(DerivedValue.class) != null;
        String variableName = String.valueOf(propField.propertyName.substring(0, 1).toLowerCase()) + propField.propertyName.substring(1);
        String setterMethodName = "set" + propField.propertyName;
        String getterMethodName = null;
        InterfaceDeclaration modelElementInterface = propField.getDeclaringType();
        String getterAlt1 = "get" + propField.propertyName;
        String getterAlt2 = "is" + propField.propertyName;
        MethodDeclaration getterMethod = GenerateImplProcessor.findMethodDeclaration(modelElementInterface, getterAlt1);
        if (getterMethod == null) {
            getterMethod = GenerateImplProcessor.findMethodDeclaration(modelElementInterface, getterAlt2);
        }
        if (getterMethod == null) {
            throw new IllegalStateException("Unable to find getter method for " + modelElementInterface.getSimpleName() + '@' + propField.name);
        }
        getterMethodName = getterMethod.getSimpleName();
        propField.setGetterMethodName(getterMethodName);
        FieldModel field = implClassModel.addField();
        field.setName(variableName);
        field.setType(wrapperType);
        Body rb = GenerateImplProcessor.prepareRefreshMethodBlock(implClassModel, propField);
        rb.append("if( this.#1 != null || force == true )", variableName);
        rb.openBlock();
        rb.append("final #2 oldValue = this.#1;", variableName, wrapperType.getSimpleName());
        rb.appendEmptyLine();
        if (hasDerivedValueProviderAnnotation) {
            rb.append("final String val = service( #1, DerivedValueService.class ).getDerivedValue();", propField.name);
            implClassModel.addImport(DerivedValueService.class);
        } else {
            rb.append("final String val = resource().binding( #1 ).read();", propField.name);
        }
        rb.appendEmptyLine();
        rb.append("this.#1 = new #2( this, #3, #3.encodeKeywords( val ) );\nthis.#1.init();\n\nfinal boolean propertyEnabledStatusChanged = refreshPropertyEnabledStatus( #3 );\n\nif( oldValue != null )\n{\n    if( this.#1.equals( oldValue ) )\n    {\n        this.#1 = oldValue;\n    }\n    \n    if( this.#1 != oldValue || propertyEnabledStatusChanged )\n    {\n        notifyPropertyChangeListeners( #3 );\n    }\n}", variableName, wrapperType.getSimpleName(), propField.name);
        rb.closeBlock();
        rb.closeBlock();
        MethodModel getter = implClassModel.addMethod();
        getter.setName(getterMethodName);
        getter.setReturnType(wrapperType);
        Body gb = getter.getBody();
        gb.append("synchronized( root() )\n{\n    if( this.#1 == null )\n    {\n        refresh( #2, true );\n    }\n    \n    return this.#1;\n}", variableName, propField.name);
        MethodModel setter = null;
        if (!hasDerivedValueProviderAnnotation && GenerateImplProcessor.findMethodDeclaration(modelElementInterface, setterMethodName) != null) {
            setter = implClassModel.addMethod();
            setter.setName(setterMethodName);
            MethodParameterModel param = new MethodParameterModel("value", String.class);
            param.setFinal(false);
            setter.addParameter(param);
            Body sb = setter.getBody();
            sb.append("synchronized( root() )\n{\n    if( value != null && value.equals( \"\" ) )\n    {\n        value = null;\n    }\n    \n    value = #1.decodeKeywords( value );\n    \n    refresh( #1, true );\n    \n    if( ! equal( this.#2.getText( false ), value ) )\n    {\n        resource().binding( #1 ).write( value );\n        refresh( #1, false );\n    }\n}\n", propField.name, variableName);
            if (!baseType.getQualifiedName().equals(String.class.getName())) {
                MethodModel setterForTyped = implClassModel.addMethod();
                setterForTyped.setName(setterMethodName);
                setterForTyped.addParameter(new MethodParameterModel("value", baseType));
                Body stb = setterForTyped.getBody();
                stb.append("#1( value != null ? service( #2, ValueSerializationService.class ).encode( value ) : null );", setterMethodName, propField.name);
                implClassModel.addImport(ValueSerializationService.class);
            }
        }
        GenerateImplProcessor.contributeReadMethodBlock(implClassModel, propField);
        if (setter != null) {
            GenerateImplProcessor.contributeValueWriteMethodBlock(implClassModel, propField);
        }
    }

    private void processElementProperty(ClassModel implClassModel, InterfaceDeclaration interfaceDeclaration, PropertyFieldDeclaration propField) {
        try {
            this.processElementPropertyInternal(implClassModel, interfaceDeclaration, propField);
        }
        catch (RuntimeException e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            InterfaceDeclaration modelElementInterface = propField.getDeclaringType();
            pw.println();
            pw.println("RuntimeException encountered during processElementProperty() method call.");
            pw.println();
            pw.println("modelElementInterface : " + (modelElementInterface == null ? "null" : modelElementInterface.getQualifiedName()));
            pw.println("propField : " + propField.name);
            pw.println();
            e.printStackTrace(pw);
            pw.println();
            pw.flush();
            System.err.println(sw.getBuffer().toString());
            throw e;
        }
    }

    private void processElementPropertyInternal(ClassModel implClassModel, InterfaceDeclaration interfaceDeclaration, PropertyFieldDeclaration propField) {
        boolean isImplied = GenerateImplProcessor.isInstanceOf(propField.getType(), ImpliedElementProperty.class.getName());
        String getterMethodName = "get" + propField.propertyName;
        String variableName = String.valueOf(propField.propertyName.substring(0, 1).toLowerCase()) + propField.propertyName.substring(1);
        TypeReference memberType = null;
        Type typeAnnotation = propField.getAnnotation(Type.class);
        try {
            typeAnnotation.base();
        }
        catch (MirroredTypeException e) {
            InterfaceDeclaration typeMirror = ((InterfaceType)e.getTypeMirror()).getDeclaration();
            memberType = new TypeReference(typeMirror.getQualifiedName());
        }
        ParameterizedTypeReference handleType = new TypeReference(ModelElementHandle.class).parameterize(memberType);
        FieldModel field = implClassModel.addField();
        field.setName(variableName);
        field.setType(handleType);
        MethodModel g = implClassModel.addMethod();
        g.setName(getterMethodName);
        g.setReturnType(isImplied ? memberType : handleType);
        Body gb = g.getBody();
        gb.append("synchronized( root() )\n{\n    if( this.#1 == null )\n    {\n        refresh( #2, true );\n    }\n    \n    return this.#1#3;\n}", variableName, propField.name, isImplied ? ".element()" : "");
        Body rb = GenerateImplProcessor.prepareRefreshMethodBlock(implClassModel, propField);
        rb.append("if( this.#1 == null )\n{\n    if( force == true )\n    {\n        this.#1 = new ModelElementHandle<#3>( this, #2 );\n        this.#1.init();\n    }\n}\nelse\n{\n    this.#1.refresh();\n}", variableName, propField.name, memberType.getSimpleName());
        rb.closeBlock();
        GenerateImplProcessor.contributeReadMethodBlock(implClassModel, propField);
    }

    private void processListProperty(ClassModel implClassModel, InterfaceDeclaration interfaceDeclaration, PropertyFieldDeclaration propField) {
        try {
            this.processListPropertyInternal(implClassModel, interfaceDeclaration, propField);
        }
        catch (RuntimeException e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            InterfaceDeclaration modelElementInterface = propField.getDeclaringType();
            pw.println();
            pw.println("RuntimeException encountered during processListProperty() method call.");
            pw.println();
            pw.println("modelElementInterface : " + (modelElementInterface == null ? "null" : modelElementInterface.getQualifiedName()));
            pw.println("propField : " + propField.name);
            pw.println();
            e.printStackTrace(pw);
            pw.println();
            pw.flush();
            System.err.println(sw.getBuffer().toString());
            throw e;
        }
    }

    private void processListPropertyInternal(ClassModel implClassModel, InterfaceDeclaration interfaceDeclaration, PropertyFieldDeclaration propField) {
        String getterMethodName = "get" + propField.propertyName;
        String variableName = String.valueOf(propField.propertyName.substring(0, 1).toLowerCase()) + propField.propertyName.substring(1);
        TypeReference memberType = null;
        Type typeAnnotation = propField.getAnnotation(Type.class);
        try {
            typeAnnotation.base();
        }
        catch (MirroredTypeException e) {
            InterfaceDeclaration typeMirror = ((InterfaceType)e.getTypeMirror()).getDeclaration();
            memberType = new TypeReference(typeMirror.getQualifiedName());
        }
        ParameterizedTypeReference listType = new TypeReference(ModelElementList.class).parameterize(memberType);
        FieldModel field = implClassModel.addField();
        field.setName(variableName);
        field.setType(listType);
        MethodModel g = implClassModel.addMethod();
        g.setName(getterMethodName);
        g.setReturnType(listType);
        Body gb = g.getBody();
        gb.append("synchronized( root() )\n{\n    if( this.#1 == null )\n    {\n        refresh( #2, true );\n    }\n    \n    return this.#1;\n}", variableName, propField.name);
        Body rb = GenerateImplProcessor.prepareRefreshMethodBlock(implClassModel, propField);
        rb.append("if( this.#1 == null )\n{\n    if( force == true )\n    {\n        this.#1 = new ModelElementList<#3>( this, #2 );\n        final ListBindingImpl binding = resource().binding( #2 );\n        this.#1.init( binding );\n        refreshPropertyEnabledStatus( #2 );\n    }\n}\nelse\n{\n    final boolean propertyEnabledStatusChanged = refreshPropertyEnabledStatus( #2 );\n    final boolean notified = this.#1.refresh();\n    \n    if( ! notified && propertyEnabledStatusChanged )\n    {\n        notifyPropertyChangeListeners( #2 );\n    }\n}", variableName, propField.name, memberType.getSimpleName());
        implClassModel.addImport(ListBindingImpl.class);
        rb.closeBlock();
        GenerateImplProcessor.contributeReadMethodBlock(implClassModel, propField);
    }

    private void processTransientProperty(ClassModel implClassModel, InterfaceDeclaration interfaceDeclaration, PropertyFieldDeclaration propField) {
        try {
            this.processTransientPropertyInternal(implClassModel, interfaceDeclaration, propField);
        }
        catch (RuntimeException e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            InterfaceDeclaration modelElementInterface = propField.getDeclaringType();
            pw.println();
            pw.println("RuntimeException encountered during processTransientProperty() method call.");
            pw.println();
            pw.println("interfaceDeclaration : " + (modelElementInterface == null ? "null" : modelElementInterface.getQualifiedName()));
            pw.println("propField : " + propField.name);
            pw.println();
            e.printStackTrace(pw);
            pw.println();
            pw.flush();
            System.err.println(sw.getBuffer().toString());
            throw e;
        }
    }

    private void processTransientPropertyInternal(ClassModel implClassModel, InterfaceDeclaration interfaceDeclaration, PropertyFieldDeclaration propField) {
        TypeReference baseType = null;
        ParameterizedTypeReference wrapperType = null;
        Type typeAnnotation = propField.getAnnotation(Type.class);
        if (typeAnnotation == null) {
            baseType = new TypeReference(Object.class);
        } else {
            try {
                typeAnnotation.base();
            }
            catch (MirroredTypeException e) {
                baseType = GenerateImplProcessor.toTypeReference(e.getTypeMirror());
            }
        }
        wrapperType = new TypeReference(Transient.class).parameterize(baseType);
        String variableName = String.valueOf(propField.propertyName.substring(0, 1).toLowerCase()) + propField.propertyName.substring(1);
        String getterMethodName = "get" + propField.propertyName;
        String setterMethodName = "set" + propField.propertyName;
        FieldModel field = implClassModel.addField();
        field.setName(variableName);
        field.setType(wrapperType);
        Body rb = GenerateImplProcessor.prepareRefreshMethodBlock(implClassModel, propField);
        rb.append("if( this.#1 == null )\n{\n    if( force == true )\n    {\n        #2( null );\n    }\n}\nelse\n{\n    #2( this.#1.content() );\n}", variableName, setterMethodName);
        rb.closeBlock();
        MethodModel getter = implClassModel.addMethod();
        getter.setName(getterMethodName);
        getter.setReturnType(wrapperType);
        Body gb = getter.getBody();
        gb.append("synchronized( root() )\n{\n    if( this.#1 == null )\n    {\n        refresh( #2, true );\n    }\n    \n    return this.#1;\n}", variableName, propField.name);
        MethodModel setter = implClassModel.addMethod();
        setter.setName(setterMethodName);
        MethodParameterModel param = new MethodParameterModel("object", baseType);
        setter.addParameter(param);
        Body sb = setter.getBody();
        sb.append("synchronized( root() )\n{\n    final #2 oldTransient = this.#1;\n    \n    this.#1 = new #2( this, #3, object );\n    this.#1.init();\n    \n    final boolean propertyEnabledStatusChanged = refreshPropertyEnabledStatus( #3 );\n    \n    if( oldTransient == null )\n    {\n        if( object != null )\n        {\n            notifyPropertyChangeListeners( #3 );\n        }\n    }\n    else\n    {\n        if( this.#1.equals( oldTransient ) )\n        {\n            this.#1 = oldTransient;\n        }\n        \n        if( this.#1 != oldTransient || propertyEnabledStatusChanged )\n        {\n            notifyPropertyChangeListeners( #3 );\n        }\n    }\n}", variableName, wrapperType.getSimpleName(), propField.name);
        GenerateImplProcessor.contributeReadMethodBlock(implClassModel, propField);
        GenerateImplProcessor.contributeTransientWriteMethodBlock(implClassModel, propField);
    }

    private static MethodDeclaration findMethodDeclaration(InterfaceDeclaration interfaceDeclaration, String methodName) {
        List<MethodDeclaration> results = GenerateImplProcessor.findMethodDeclarations(interfaceDeclaration, methodName);
        if (results.isEmpty()) {
            return null;
        }
        return results.get(0);
    }

    private static List<MethodDeclaration> findMethodDeclarations(InterfaceDeclaration interfaceDeclaration, String methodName) {
        ArrayList<MethodDeclaration> results = new ArrayList<MethodDeclaration>();
        GenerateImplProcessor.findMethodDeclarations(interfaceDeclaration, methodName, results);
        return results;
    }

    private static void findMethodDeclarations(InterfaceDeclaration interfaceDeclaration, String methodName, List<MethodDeclaration> results) {
        for (MethodDeclaration method : interfaceDeclaration.getMethods()) {
            if (!method.getSimpleName().equals(methodName)) continue;
            results.add(method);
        }
        for (InterfaceType superInterfaceType : interfaceDeclaration.getSuperinterfaces()) {
            GenerateImplProcessor.findMethodDeclarations(superInterfaceType.getDeclaration(), methodName, results);
        }
    }

    private static String preparePropName(String propFieldName) {
        StringBuilder buf = new StringBuilder();
        boolean seenFirstSegment = false;
        String[] stringArray = propFieldName.split("_");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            if (seenFirstSegment) {
                buf.append(segment.charAt(0));
                buf.append(segment.substring(1).toLowerCase());
            } else {
                seenFirstSegment = true;
            }
            ++n2;
        }
        return buf.toString();
    }

    private static void visitAllMethods(InterfaceDeclaration interfaceDeclaration, Visitor<MethodDeclaration> visitor) {
        for (InterfaceType superInterface : interfaceDeclaration.getSuperinterfaces()) {
            InterfaceDeclaration superInterfaceDeclaration = superInterface.getDeclaration();
            GenerateImplProcessor.visitAllMethods(superInterfaceDeclaration, visitor);
        }
        for (MethodDeclaration method : interfaceDeclaration.getMethods()) {
            visitor.visit(method);
        }
    }

    private static void visitAllFields(InterfaceDeclaration interfaceDeclaration, Visitor<FieldDeclaration> visitor) {
        for (InterfaceType superInterface : interfaceDeclaration.getSuperinterfaces()) {
            InterfaceDeclaration superInterfaceDeclaration = superInterface.getDeclaration();
            GenerateImplProcessor.visitAllFields(superInterfaceDeclaration, visitor);
        }
        for (FieldDeclaration field : interfaceDeclaration.getFields()) {
            visitor.visit(field);
        }
    }

    private static MethodModel getReadMethod(ClassModel implClassModel, boolean createIfNecessary) {
        MethodModel readMethod = (MethodModel)implClassModel.getData(DATA_READ_METHOD);
        if (readMethod == null && createIfNecessary) {
            readMethod = implClassModel.addMethod("read");
            readMethod.setReturnType(Object.class);
            readMethod.addParameter(new MethodParameterModel("property", ModelProperty.class, false));
            readMethod.setData(DATA_HAS_CONTENTS, Boolean.FALSE);
            implClassModel.setData(DATA_READ_METHOD, readMethod);
            Body rb = readMethod.getBody();
            rb.append("property = property.refine( this );");
            rb.appendEmptyLine();
        }
        return readMethod;
    }

    private static Body contributeReadMethodBlock(ClassModel implClassModel, PropertyFieldDeclaration propField) {
        boolean hasPriorContent;
        MethodModel readMethod = GenerateImplProcessor.getReadMethod(implClassModel, true);
        Body rb = readMethod.getBody();
        if (readMethod.getData(DATA_HAS_CONTENTS) == Boolean.TRUE) {
            hasPriorContent = true;
        } else {
            hasPriorContent = false;
            readMethod.setData(DATA_HAS_CONTENTS, Boolean.TRUE);
        }
        rb.append("#1if( property == #2 )\n{\n    return #3();\n}", hasPriorContent ? "else " : "", propField.name, propField.getGetterMethodName());
        return rb;
    }

    private static MethodModel getValueWriteMethod(ClassModel implClassModel, boolean createIfNecessary) {
        MethodModel writeMethod = (MethodModel)implClassModel.getData(DATA_WRITE_VALUE_METHOD);
        if (writeMethod == null && createIfNecessary) {
            writeMethod = implClassModel.addMethod("write");
            writeMethod.addParameter(new MethodParameterModel("property", ValueProperty.class, false));
            writeMethod.addParameter(new MethodParameterModel("value", Object.class));
            writeMethod.setData(DATA_HAS_CONTENTS, Boolean.FALSE);
            implClassModel.setData(DATA_WRITE_VALUE_METHOD, writeMethod);
            Body rb = writeMethod.getBody();
            rb.append("property = (ValueProperty) property.refine( this );");
            rb.appendEmptyLine();
        }
        return writeMethod;
    }

    private static Body contributeValueWriteMethodBlock(ClassModel implClassModel, PropertyFieldDeclaration propField) {
        boolean hasPriorContent;
        MethodModel writeMethod = GenerateImplProcessor.getValueWriteMethod(implClassModel, true);
        Body rb = writeMethod.getBody();
        if (writeMethod.getData(DATA_HAS_CONTENTS) == Boolean.TRUE) {
            hasPriorContent = true;
        } else {
            hasPriorContent = false;
            writeMethod.setData(DATA_HAS_CONTENTS, Boolean.TRUE);
        }
        Type typeAnnotation = propField.getAnnotation(Type.class);
        TypeReference type = null;
        if (typeAnnotation != null) {
            try {
                typeAnnotation.base();
            }
            catch (MirroredTypeException e) {
                type = GenerateImplProcessor.toTypeReference(e.getTypeMirror());
            }
        }
        rb.append("#1if( property == #2 )", hasPriorContent ? "else " : "", propField.name);
        rb.openBlock();
        if (type == null) {
            rb.append("set#1( (String) value );\nreturn;", propField.propertyName);
        } else {
            rb.append("if( ! ( value instanceof String ) )\n{\n    set#1( (#2) value );\n}\nelse\n{\n    set#1( (String) value );\n}\n\nreturn;", propField.propertyName, type.getSimpleName());
            implClassModel.addImport(type);
        }
        rb.closeBlock();
        return rb;
    }

    private static MethodModel getTransientWriteMethod(ClassModel implClassModel, boolean createIfNecessary) {
        MethodModel writeMethod = (MethodModel)implClassModel.getData(DATA_WRITE_TRANSIENT_METHOD);
        if (writeMethod == null && createIfNecessary) {
            writeMethod = implClassModel.addMethod("write");
            writeMethod.addParameter(new MethodParameterModel("property", TransientProperty.class, false));
            writeMethod.addParameter(new MethodParameterModel("object", Object.class));
            writeMethod.setData(DATA_HAS_CONTENTS, Boolean.FALSE);
            implClassModel.setData(DATA_WRITE_TRANSIENT_METHOD, writeMethod);
            Body rb = writeMethod.getBody();
            rb.append("property = (TransientProperty) property.refine( this );");
            rb.appendEmptyLine();
        }
        return writeMethod;
    }

    private static Body contributeTransientWriteMethodBlock(ClassModel implClassModel, PropertyFieldDeclaration propField) {
        boolean hasPriorContent;
        MethodModel writeMethod = GenerateImplProcessor.getTransientWriteMethod(implClassModel, true);
        Body rb = writeMethod.getBody();
        if (writeMethod.getData(DATA_HAS_CONTENTS) == Boolean.TRUE) {
            hasPriorContent = true;
        } else {
            hasPriorContent = false;
            writeMethod.setData(DATA_HAS_CONTENTS, Boolean.TRUE);
        }
        Type typeAnnotation = propField.getAnnotation(Type.class);
        TypeReference type = null;
        if (typeAnnotation != null) {
            try {
                typeAnnotation.base();
            }
            catch (MirroredTypeException e) {
                type = GenerateImplProcessor.toTypeReference(e.getTypeMirror());
            }
        }
        rb.append("#1if( property == #2 )", hasPriorContent ? "else " : "", propField.name);
        rb.openBlock();
        if (type == null) {
            rb.append("set#1( object );", propField.propertyName);
        } else {
            rb.append("set#1( (#2) object );", propField.propertyName, type.getSimpleName());
        }
        rb.append("return;");
        rb.closeBlock();
        return rb;
    }

    private static MethodModel getRefreshMethod(ClassModel implClassModel, boolean createIfNecessary) {
        MethodModel refreshMethod = (MethodModel)implClassModel.getData(DATA_REFRESH_METHOD);
        if (refreshMethod == null && createIfNecessary) {
            refreshMethod = implClassModel.addMethod("refreshProperty");
            refreshMethod.setAccessModifier(AccessModifier.PROTECTED);
            refreshMethod.addParameter(new MethodParameterModel("property", ModelProperty.class, false));
            refreshMethod.addParameter(new MethodParameterModel("force", TypeReference.BOOLEAN_TYPE));
            refreshMethod.setData(DATA_HAS_CONTENTS, Boolean.FALSE);
            implClassModel.setData(DATA_REFRESH_METHOD, refreshMethod);
            Body rb = refreshMethod.getBody();
            rb.append("synchronized( root() )");
            rb.openBlock();
            rb.append("property = property.refine( this );");
            rb.appendEmptyLine();
        }
        return refreshMethod;
    }

    private static Body prepareRefreshMethodBlock(ClassModel implClassModel, PropertyFieldDeclaration propField) {
        boolean hasPriorContent;
        MethodModel refreshMethod = GenerateImplProcessor.getRefreshMethod(implClassModel, true);
        Body rb = refreshMethod.getBody();
        if (refreshMethod.getData(DATA_HAS_CONTENTS) == Boolean.TRUE) {
            hasPriorContent = true;
        } else {
            hasPriorContent = false;
            refreshMethod.setData(DATA_HAS_CONTENTS, Boolean.TRUE);
        }
        rb.append("#1if( property == #2 )", hasPriorContent ? "else " : "", propField.name);
        rb.openBlock();
        return rb;
    }

    private static TypeReference toTypeReference(TypeMirror typeMirror) {
        if (typeMirror instanceof VoidType) {
            return TypeReference.VOID_TYPE;
        }
        if (typeMirror instanceof PrimitiveType) {
            return TypeReference.PRIMITIVE_TYPES.get(((PrimitiveType)typeMirror).getKind());
        }
        if (typeMirror instanceof DeclaredType) {
            return new TypeReference(((DeclaredType)typeMirror).getDeclaration().getQualifiedName());
        }
        if (typeMirror instanceof ArrayType) {
            return GenerateImplProcessor.toTypeReference(((ArrayType)typeMirror).getComponentType()).array(1);
        }
        return new TypeReference(((TypeDeclaration)typeMirror).getQualifiedName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PropertyFieldDeclaration {
        public String name;
        public String propertyName;
        public LinkedList<FieldDeclaration> declarations = new LinkedList();
        private String getterMethodName;

        public TypeMirror getType() {
            if (this.declarations.isEmpty()) {
                return null;
            }
            return this.declarations.getFirst().getType();
        }

        public InterfaceDeclaration getDeclaringType() {
            if (!this.declarations.isEmpty()) {
                TypeDeclaration declaringType = this.declarations.getFirst().getDeclaringType();
                if (declaringType instanceof InterfaceDeclaration) {
                    return (InterfaceDeclaration)declaringType;
                }
                if (declaringType instanceof InterfaceType) {
                    return ((InterfaceType)declaringType).getDeclaration();
                }
                throw new IllegalStateException();
            }
            return null;
        }

        public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
            Annotation annotation = null;
            for (FieldDeclaration fd : this.declarations) {
                annotation = fd.getAnnotation(annotationType);
                if (annotation != null) break;
            }
            return (A)annotation;
        }

        public String getGetterMethodName() {
            if (this.getterMethodName == null) {
                return "get" + this.propertyName;
            }
            return this.getterMethodName;
        }

        public void setGetterMethodName(String getterMethodName) {
            this.getterMethodName = getterMethodName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Visitor<T> {
        public void visit(T var1);
    }
}

