/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.el;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionException;
import org.eclipse.sapphire.modeling.internal.SapphireModelingFrameworkPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FunctionResult {
    private final Function function;
    private final FunctionContext context;
    private final List<FunctionResult> operands;
    private final List<FunctionResult> operandsReadOnly;
    private final List<Listener> listeners;
    private Object value;

    public FunctionResult(Function function, FunctionContext context) {
        this.function = function;
        this.context = context;
        this.listeners = new CopyOnWriteArrayList<Listener>();
        List<Function> operands = function.operands();
        if (operands.size() == 0) {
            this.operands = Collections.emptyList();
            this.operandsReadOnly = this.operands;
        } else if (operands.size() == 1) {
            this.operands = Collections.singletonList(operands.get(0).evaluate(this.context));
            this.operandsReadOnly = this.operands;
        } else {
            this.operands = new ArrayList<FunctionResult>();
            for (Function operand : operands) {
                this.operands.add(operand.evaluate(this.context));
            }
            this.operandsReadOnly = Collections.unmodifiableList(this.operands);
        }
        if (!this.operands.isEmpty()) {
            Listener listener = new Listener(){

                public void handleValueChanged() {
                    FunctionResult.this.refresh();
                }
            };
            for (FunctionResult operand : this.operands) {
                operand.addListener(listener);
            }
        }
        this.init();
        this.refresh();
    }

    protected void init() {
    }

    public final Function function() {
        return this.function;
    }

    public final FunctionContext context() {
        return this.context;
    }

    public final List<FunctionResult> operands() {
        return this.operandsReadOnly;
    }

    public final FunctionResult operand(int position) {
        if (position < this.operands.size()) {
            return this.operands.get(position);
        }
        throw new FunctionException(NLS.bind((String)Resources.missingOperandMessage, (Object)this.getClass().getName(), (Object)String.valueOf(position)));
    }

    protected abstract Object evaluate();

    public final Object value() {
        return this.value;
    }

    protected final void refresh() {
        Object newValue;
        try {
            newValue = this.evaluate();
        }
        catch (Exception e) {
            SapphireModelingFrameworkPlugin.log(e);
            return;
        }
        if (!this.equal(this.value, newValue)) {
            this.value = newValue;
            this.notifyListeners();
        }
    }

    protected boolean equal(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    public final void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public final void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    private final void notifyListeners() {
        for (Listener listener : this.listeners) {
            try {
                listener.handleValueChanged();
            }
            catch (Exception e) {
                SapphireModelingFrameworkPlugin.log(e);
            }
        }
    }

    public void dispose() {
        for (FunctionResult operand : this.operands) {
            operand.dispose();
        }
    }

    protected <X> X cast(Object obj, Class<X> type) {
        if (obj instanceof FunctionResult) {
            throw new IllegalArgumentException();
        }
        if (type == String.class) {
            if (obj instanceof String) {
                return (X)obj;
            }
            if (obj == null) {
                return (X)"";
            }
            if (obj instanceof Enum) {
                return (X)((Enum)obj).name();
            }
            if (obj instanceof Value) {
                String res = ((Value)obj).getText();
                res = res == null ? "" : res;
                return (X)res;
            }
            return (X)obj.toString();
        }
        if (Number.class.isAssignableFrom(type)) {
            if (obj instanceof Value) {
                obj = ((Value)obj).getContent();
            }
            if (obj == null || obj instanceof String && ((String)obj).length() == 0) {
                obj = (short)0;
            } else if (obj instanceof Character) {
                obj = (short)((Character)obj).charValue();
            } else if (obj instanceof Boolean) {
                throw new FunctionException(NLS.bind((String)Resources.cannotCastMessage, (Object)obj.getClass().getName(), (Object)type.getName()));
            }
            if (obj.getClass() == type) {
                return (X)obj;
            }
            if (obj instanceof Number) {
                if (type == BigInteger.class) {
                    if (obj instanceof BigDecimal) {
                        return (X)((BigDecimal)obj).toBigInteger();
                    }
                    return (X)BigInteger.valueOf(((Number)obj).longValue());
                }
                if (type == BigDecimal.class) {
                    if (obj instanceof BigInteger) {
                        return (X)new BigDecimal((BigInteger)obj);
                    }
                    return (X)new BigDecimal(((Number)obj).doubleValue());
                }
                if (type == Byte.class) {
                    return (X)new Byte(((Number)obj).byteValue());
                }
                if (type == Short.class) {
                    return (X)new Short(((Number)obj).shortValue());
                }
                if (type == Integer.class) {
                    return (X)new Integer(((Number)obj).intValue());
                }
                if (type == Long.class) {
                    return (X)new Long(((Number)obj).longValue());
                }
                if (type == Float.class) {
                    return (X)new Float(((Number)obj).floatValue());
                }
                if (type == Double.class) {
                    return (X)new Double(((Number)obj).doubleValue());
                }
            } else if (obj instanceof String) {
                if (type == BigDecimal.class) {
                    return (X)new BigDecimal((String)obj);
                }
                if (type == BigInteger.class) {
                    return (X)new BigInteger((String)obj);
                }
                if (type == Byte.class) {
                    return (X)Byte.valueOf((String)obj);
                }
                if (type == Short.class) {
                    return (X)Short.valueOf((String)obj);
                }
                if (type == Integer.class) {
                    return (X)Integer.valueOf((String)obj);
                }
                if (type == Long.class) {
                    return (X)Long.valueOf((String)obj);
                }
                if (type == Float.class) {
                    return (X)Float.valueOf((String)obj);
                }
                if (type == Double.class) {
                    return (X)Double.valueOf((String)obj);
                }
            }
            throw new FunctionException(NLS.bind((String)Resources.cannotCastMessage, (Object)obj.getClass().getName(), (Object)type.getName()));
        }
        if (type == Character.class) {
            if (obj instanceof Value) {
                obj = ((Value)obj).getContent();
            }
            if (obj == null || obj instanceof String && ((String)obj).length() == 0) {
                return (X)Character.valueOf('\u0000');
            }
            if (obj instanceof Character) {
                return (X)obj;
            }
            if (obj instanceof Boolean) {
                throw new FunctionException(NLS.bind((String)Resources.cannotCastMessage, (Object)obj.getClass().getName(), (Object)type.getName()));
            }
            if (obj instanceof Number) {
                return (X)Character.valueOf((char)this.cast(obj, Short.class).shortValue());
            }
            if (obj instanceof String) {
                return (X)Character.valueOf(((String)obj).charAt(0));
            }
            throw new FunctionException(NLS.bind((String)Resources.cannotCastMessage, (Object)obj.getClass().getName(), (Object)type.getName()));
        }
        if (type == Boolean.class) {
            if (obj instanceof Value) {
                obj = ((Value)obj).getContent();
            }
            if (obj == null || obj instanceof String && ((String)obj).length() == 0) {
                return (X)Boolean.FALSE;
            }
            if (obj instanceof Boolean) {
                return (X)obj;
            }
            if (obj instanceof String) {
                return (X)Boolean.valueOf((String)obj);
            }
            throw new FunctionException(NLS.bind((String)Resources.cannotCastMessage, (Object)obj.getClass().getName(), (Object)type.getName()));
        }
        if (Enum.class.isAssignableFrom(type)) {
            if (obj instanceof Value) {
                obj = ((Value)obj).getContent();
            }
            if (obj == null) {
                return null;
            }
            if (type.isInstance(obj)) {
                return (X)obj;
            }
            if (obj instanceof String) {
                String str = (String)obj;
                if (str.length() == 0) {
                    return null;
                }
                return Enum.valueOf(type, str);
            }
            throw new FunctionException(NLS.bind((String)Resources.cannotCastMessage, (Object)obj.getClass().getName(), (Object)type.getName()));
        }
        if (obj instanceof Value) {
            obj = ((Value)obj).getContent();
        }
        if (obj == null) {
            return null;
        }
        if (type.isInstance(obj)) {
            return (X)obj;
        }
        if (obj instanceof String && ((String)obj).length() == 0) {
            return null;
        }
        throw new FunctionException(NLS.bind((String)Resources.cannotCastMessage, (Object)obj.getClass().getName(), (Object)type.getName()));
    }

    public static abstract class Listener {
        public abstract void handleValueChanged();
    }

    private static final class Resources
    extends NLS {
        public static String cannotCastMessage;
        public static String missingOperandMessage;

        static {
            Resources.initializeMessages((String)FunctionResult.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

