/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.internal;

import org.eclipse.help.IContext;
import org.eclipse.help.IContext2;
import org.eclipse.help.IHelpResource;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelMetadataItem;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.DocumentationData;
import org.eclipse.sapphire.modeling.annotations.DocumentationMergeStrategy;
import org.eclipse.sapphire.modeling.annotations.DocumentationProvider;
import org.eclipse.sapphire.modeling.annotations.DocumentationProviderImpl;
import org.eclipse.sapphire.modeling.annotations.NonNullValue;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.ReadOnly;
import org.eclipse.sapphire.modeling.internal.SapphireModelingFrameworkPlugin;
import org.eclipse.sapphire.modeling.localization.LocalizationService;
import org.eclipse.sapphire.modeling.util.internal.DocumentationUtil;
import org.eclipse.sapphire.modeling.util.internal.SapphireCommonUtil;

public class SapphireHelpContext
implements IContext,
IContext2 {
    private static final String LINE_BREAK = "[br/]";
    private String title = null;
    private String content = null;
    private IHelpResource[] topics;

    public SapphireHelpContext(IModelElement modelElement, ModelProperty property) {
        this.title = property.getLabel(true, CapitalizationType.TITLE_STYLE, false);
        ModelProperty p = property;
        while (p != null) {
            DocumentationData data;
            Documentation documentation = p.getAnnotation(Documentation.class, true);
            DocumentationProvider documentationProvider = p.getAnnotation(DocumentationProvider.class, true);
            if (documentation != null) {
                this.initContext(p, p.getName(), documentation, null);
                if (documentation.mergeStrategy() == DocumentationMergeStrategy.REPLACE) {
                    break;
                }
            } else if (documentationProvider != null && (data = this.initContext(documentationProvider, null)) != null && data.getMergeStrategy() == DocumentationMergeStrategy.REPLACE) break;
            p = p.getBase();
        }
        ModelElementType type = property.getModelElementType();
        Documentation typeDocumentation = type.getAnnotation(Documentation.class);
        DocumentationProvider typeDocumentationProvider = type.getAnnotation(DocumentationProvider.class);
        if (typeDocumentation != null) {
            this.initContext(type, "$contentHelp$", typeDocumentation, DocumentationMergeStrategy.APPEND);
        } else if (typeDocumentationProvider != null) {
            this.initContext(typeDocumentationProvider, DocumentationMergeStrategy.APPEND);
        }
        this.addGeneratedInformation(modelElement, property);
    }

    private void addGeneratedInformation(IModelElement modelElement, ModelProperty property) {
        ReadOnly readOnlyAnnotation;
        NonNullValue nonNullAnnotation;
        StringBuffer buffer = new StringBuffer();
        if (property instanceof ValueProperty) {
            NumericRange rangeAnnotation;
            ValueProperty valueProperty = (ValueProperty)property;
            String defaultValue = SapphireCommonUtil.getDefaultValueLabel(modelElement, valueProperty);
            if (defaultValue != null) {
                buffer.append(NLS.bind((String)Resources.defaultValueInfoMessage, (Object)defaultValue));
                buffer.append(LINE_BREAK);
            }
            if ((rangeAnnotation = property.getAnnotation(NumericRange.class)) != null) {
                String min = rangeAnnotation.min();
                String max = rangeAnnotation.max();
                if (min != null && min.length() > 0) {
                    buffer.append(NLS.bind((String)Resources.minValueInfoMessage, (Object)SapphireCommonUtil.normalizeForDisplay(valueProperty, min)));
                    buffer.append(LINE_BREAK);
                }
                if (max != null && max.length() > 0) {
                    buffer.append(NLS.bind((String)Resources.maxValueInfoMessage, (Object)SapphireCommonUtil.normalizeForDisplay(valueProperty, max)));
                    buffer.append(LINE_BREAK);
                }
            }
        }
        if ((nonNullAnnotation = property.getAnnotation(NonNullValue.class)) != null) {
            buffer.append(NLS.bind((String)Resources.nonNullMessage, (Object)property.getLabel(false, CapitalizationType.FIRST_WORD_ONLY, false)));
            buffer.append(LINE_BREAK);
        }
        if ((readOnlyAnnotation = property.getAnnotation(ReadOnly.class)) != null) {
            buffer.append(NLS.bind((String)Resources.readOnlyMessage, (Object)property.getLabel(false, CapitalizationType.FIRST_WORD_ONLY, false)));
            buffer.append(LINE_BREAK);
        }
        if (buffer.length() > 0) {
            this.appendContent(buffer.toString());
        }
    }

    private void initContext(ModelMetadataItem property, String key, Documentation documentation, DocumentationMergeStrategy strategy) {
        if (strategy == null) {
            strategy = documentation.mergeStrategy();
        }
        LocalizationService localization = property.getLocalizationService();
        String res = localization.text(documentation.content(), CapitalizationType.NO_CAPS, false);
        if (strategy == DocumentationMergeStrategy.PREPEND) {
            this.prependContent(res);
        } else {
            this.appendContent(res);
        }
        Documentation.Topic[] relatedTopicAnnotations = documentation.topics();
        IHelpResource[] topics = new IHelpResource[relatedTopicAnnotations.length];
        int i = 0;
        int n = relatedTopicAnnotations.length;
        while (i < n) {
            final Documentation.Topic topic = relatedTopicAnnotations[i];
            final String label = localization.text(topic.label(), CapitalizationType.TITLE_STYLE, false);
            topics[i] = new IHelpResource(){

                public String getHref() {
                    return topic.href();
                }

                public String getLabel() {
                    return label;
                }
            };
            ++i;
        }
        if (strategy == DocumentationMergeStrategy.PREPEND) {
            this.prependTopics(topics);
        } else {
            this.appendTopics(topics);
        }
    }

    private DocumentationData initContext(DocumentationProvider documentationProvider, DocumentationMergeStrategy strategy) {
        Class<? extends DocumentationProviderImpl> documentationProviderClass = documentationProvider.impl();
        try {
            DocumentationProviderImpl provider = documentationProviderClass.newInstance();
            DocumentationData data = provider.getDocumentationData();
            if (data != null) {
                if (strategy == null) {
                    strategy = data.getMergeStrategy();
                }
                if (strategy == DocumentationMergeStrategy.PREPEND) {
                    this.prependContent(data.getContent());
                    this.prependTopics(data.getTopics());
                } else {
                    this.appendContent(data.getContent());
                    this.appendTopics(data.getTopics());
                }
                return data;
            }
        }
        catch (Exception e) {
            SapphireModelingFrameworkPlugin.log(e);
        }
        return null;
    }

    private void appendContent(String str) {
        if (str == null || str.length() == 0) {
            return;
        }
        String decodedStr = DocumentationUtil.decodeDocumentationTags(str);
        if (this.content == null) {
            this.content = decodedStr;
        } else {
            StringBuffer buf = new StringBuffer(this.content);
            if (this.content.endsWith("\r\n")) {
                buf.append("\r\n");
            } else {
                buf.append("\r\n\r\n");
            }
            buf.append(decodedStr);
            this.content = buf.toString();
        }
    }

    private void prependContent(String str) {
        if (str == null || str.length() == 0) {
            return;
        }
        String decodedStr = DocumentationUtil.decodeDocumentationTags(str);
        if (this.content == null) {
            this.content = decodedStr;
        } else {
            StringBuffer buf = new StringBuffer(decodedStr);
            if (decodedStr.endsWith("\r\n")) {
                buf.append("\r\n");
            } else {
                buf.append("\r\n\r\n");
            }
            buf.append(this.content);
            this.content = buf.toString();
        }
    }

    private void appendTopics(IHelpResource[] resources) {
        if (this.topics == null) {
            this.topics = resources;
        } else {
            IHelpResource[] temp = new IHelpResource[this.topics.length + resources.length];
            System.arraycopy(this.topics, 0, temp, 0, this.topics.length);
            System.arraycopy(resources, 0, temp, this.topics.length, resources.length);
            this.topics = temp;
        }
    }

    private void prependTopics(IHelpResource[] resources) {
        if (this.topics == null) {
            this.topics = resources;
        } else {
            IHelpResource[] temp = new IHelpResource[this.topics.length + resources.length];
            System.arraycopy(resources, 0, temp, 0, resources.length);
            System.arraycopy(this.topics, 0, temp, resources.length, this.topics.length);
            this.topics = temp;
        }
    }

    public String getTitle() {
        return this.title;
    }

    public String getStyledText() {
        return null;
    }

    public String getCategory(IHelpResource topic) {
        return null;
    }

    public IHelpResource[] getRelatedTopics() {
        return this.topics;
    }

    public String getText() {
        return this.content;
    }

    private static final class Resources
    extends NLS {
        public static String minValueInfoMessage;
        public static String maxValueInfoMessage;
        public static String defaultValueInfoMessage;
        public static String nonNullMessage;
        public static String readOnlyMessage;

        static {
            Resources.initializeMessages((String)SapphireHelpContext.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

