/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.xml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.LayeredListBindingImpl;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.util.internal.MiscUtil;
import org.eclipse.sapphire.modeling.xml.ChildXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlPath;
import org.eclipse.sapphire.modeling.xml.XmlResource;
import org.eclipse.sapphire.modeling.xml.annotations.XmlListBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardXmlListBindingImpl
extends LayeredListBindingImpl {
    protected XmlPath path;
    protected String[] xmlElementNames;
    protected ModelElementType[] modelElementTypes;

    @Override
    public void init(IModelElement element, ModelProperty property, String[] params) {
        super.init(element, property, params);
        this.initBindingMetadata(element, property, params);
    }

    protected void initBindingMetadata(IModelElement element, ModelProperty property, String[] params) {
        XmlListBinding annotation = property.getAnnotation(XmlListBinding.class);
        if (annotation != null) {
            if (annotation.path().length() > 0) {
                this.path = new XmlPath(annotation.path(), ((XmlResource)element.resource()).getXmlNamespaceResolver());
            }
            XmlListBinding.Mapping[] mappings = annotation.mappings();
            this.xmlElementNames = new String[mappings.length];
            this.modelElementTypes = new ModelElementType[mappings.length];
            int i = 0;
            while (i < mappings.length) {
                XmlListBinding.Mapping mapping = mappings[i];
                this.xmlElementNames[i] = mapping.element();
                this.modelElementTypes[i] = ModelElementType.getModelElementType(mapping.type());
                ++i;
            }
        } else {
            this.path = new XmlPath(property.getName(), ((XmlResource)element.resource()).getXmlNamespaceResolver());
            List<ModelElementType> types = property.getAllPossibleTypes();
            this.modelElementTypes = types.toArray(new ModelElementType[types.size()]);
            this.xmlElementNames = new String[this.modelElementTypes.length];
            int i = 0;
            while (i < this.modelElementTypes.length) {
                this.xmlElementNames[i] = this.modelElementTypes[i].getSimpleName().substring(1);
                ++i;
            }
        }
    }

    @Override
    public ModelElementType type(Resource resource) {
        XmlElement xmlElement = ((XmlResource)resource).getXmlElement();
        String xmlElementName = xmlElement.getDomNode().getLocalName();
        int i = 0;
        while (i < this.xmlElementNames.length) {
            if (this.xmlElementNames[i].equals(xmlElementName)) {
                return this.modelElementTypes[i];
            }
            ++i;
        }
        throw new IllegalStateException();
    }

    @Override
    protected List<?> readUnderlyingList() {
        XmlElement parent = this.getXmlElement(false);
        if (parent == null) {
            return Collections.emptyList();
        }
        ArrayList<XmlElement> list = new ArrayList<XmlElement>();
        for (XmlElement element : parent.getChildElements()) {
            String xmlElementName = element.getDomNode().getLocalName();
            if (!MiscUtil.contains(this.xmlElementNames, xmlElementName)) continue;
            list.add(element);
        }
        return list;
    }

    @Override
    protected Object addUnderlyingObject(ModelElementType type) {
        String xmlElementName = this.xmlElementNames[MiscUtil.indexOf(this.modelElementTypes, type)];
        return this.getXmlElement(true).addChildElement(xmlElementName);
    }

    @Override
    protected Resource createResource(Object obj) {
        XmlElement xmlElement = (XmlElement)obj;
        XmlResource parentXmlResource = (XmlResource)this.element().resource();
        return new ChildXmlResource(parentXmlResource, xmlElement);
    }

    @Override
    public void remove(Resource resource) {
        XmlElement parent;
        XmlElement base;
        XmlResource xmlResource = (XmlResource)resource;
        XmlElement xmlElement = xmlResource.getXmlElement();
        xmlElement.remove();
        if (this.path != null && (base = this.getBaseXmlElement(false)) != null && (parent = (XmlElement)base.getChildNode(this.path, false)) != null && parent.isEmpty()) {
            base.removeChildNode(this.path);
        }
    }

    @Override
    public void swap(Resource a, Resource b) {
        XmlElement x = ((XmlResource)a).getXmlElement();
        XmlElement y = ((XmlResource)b).getXmlElement();
        x.swap(y);
    }

    protected XmlElement getXmlElement(boolean createIfNecessary) {
        XmlElement parent = this.getBaseXmlElement(createIfNecessary);
        if (parent != null && this.path != null) {
            parent = (XmlElement)parent.getChildNode(this.path, createIfNecessary);
        }
        return parent;
    }

    protected XmlElement getBaseXmlElement(boolean createIfNecessary) {
        XmlResource resource = (XmlResource)this.element().resource();
        return resource.getXmlElement(createIfNecessary);
    }
}

