/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.xml;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.sapphire.modeling.IdentityCache;
import org.eclipse.sapphire.modeling.util.ListFactory;
import org.eclipse.sapphire.modeling.xml.XmlAttribute;
import org.eclipse.sapphire.modeling.xml.XmlComment;
import org.eclipse.sapphire.modeling.xml.XmlMetaComment;
import org.eclipse.sapphire.modeling.xml.XmlNode;
import org.eclipse.sapphire.modeling.xml.XmlPath;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.modeling.xml.schema.XmlContentModel;
import org.eclipse.sapphire.modeling.xml.schema.XmlDocumentSchema;
import org.eclipse.sapphire.modeling.xml.schema.XmlDocumentSchemasCache;
import org.eclipse.sapphire.modeling.xml.schema.XmlElementDefinition;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XmlElement
extends XmlNode {
    private final IdentityCache<Element, XmlElement> elementsCache = new IdentityCache();
    private final IdentityCache<Attr, XmlAttribute> attributesCache = new IdentityCache();
    private final IdentityCache<Comment, XmlComment> commentsCache = new IdentityCache();
    private final IdentityCache<Comment, XmlMetaComment> metaCommentsCache = new IdentityCache();
    private QName qname = null;
    private XmlContentModel contentModel = null;
    private boolean contentModelInitialized = false;

    public XmlElement(XmlResourceStore store, Element domElement) {
        this(store, null, domElement);
    }

    public XmlElement(XmlElement parent, Element domElement) {
        this(parent.getResourceStore(), parent, domElement);
    }

    private XmlElement(XmlResourceStore store, XmlElement parent, Element domElement) {
        super(store, parent, domElement);
    }

    @Override
    public Element getDomNode() {
        return (Element)super.getDomNode();
    }

    public String getLocalName() {
        return this.getDomNode().getLocalName();
    }

    public String getNamespace() {
        return this.getDomNode().getNamespaceURI();
    }

    public QName getQualifiedName() {
        if (this.qname == null) {
            this.qname = new QName(this.getNamespace(), this.getLocalName());
        }
        return this.qname;
    }

    public String getSchemaLocation() {
        String namespace = this.getNamespace();
        if (namespace != null) {
            Element root = this.getDomNode().getOwnerDocument().getDocumentElement();
            NamedNodeMap attributes = root.getAttributes();
            int i = 0;
            int n = attributes.getLength();
            while (i < n) {
                Attr attr = (Attr)attributes.item(i);
                String attrLocalName = attr.getLocalName();
                if (attrLocalName != null && attrLocalName.equals("schemaLocation")) {
                    String[] segments = attr.getValue().split("[\\s]+");
                    boolean grabNextSegment = false;
                    int j = 0;
                    int m = segments.length;
                    while (j < m) {
                        if (j % 2 == 0) {
                            if (segments[j].equals(namespace)) {
                                grabNextSegment = true;
                            }
                        } else if (grabNextSegment) {
                            return segments[j];
                        }
                        ++j;
                    }
                    return namespace;
                }
                ++i;
            }
            return namespace;
        }
        return null;
    }

    public XmlContentModel getContentModel() {
        if (!this.contentModelInitialized) {
            XmlElement parent = this.getParent();
            if (parent == null) {
                XmlElementDefinition xmlElementDefinition;
                XmlDocumentSchema xmlDocumentSchema;
                DocumentType type;
                String schemaLocation = this.getSchemaLocation();
                String baseLocation = null;
                if (schemaLocation == null && (type = this.getDomNode().getOwnerDocument().getDoctype()) != null) {
                    File file = this.getResourceStore().adapt(File.class);
                    if (file != null) {
                        baseLocation = file.getAbsolutePath();
                    }
                    schemaLocation = type.getSystemId();
                }
                if (schemaLocation != null && (xmlDocumentSchema = XmlDocumentSchemasCache.getSchema(schemaLocation, baseLocation)) != null && (xmlElementDefinition = xmlDocumentSchema.getElement(this.getLocalName())) != null) {
                    this.contentModel = xmlElementDefinition.getContentModel();
                }
            } else {
                XmlContentModel parentXmlContentModel = parent.getContentModel();
                if (parentXmlContentModel != null) {
                    this.contentModel = parentXmlContentModel.findChildElementContentModel(this.getQualifiedName());
                }
            }
            this.contentModelInitialized = true;
        }
        return this.contentModel;
    }

    @Override
    protected String getTextInternal() {
        NodeList nodes = this.getDomNode().getChildNodes();
        String str = null;
        StringBuilder buf = null;
        int i = 0;
        int n = nodes.getLength();
        while (i < n) {
            Node node = nodes.item(i);
            short nodeType = node.getNodeType();
            if (nodeType == 3 || nodeType == 4) {
                String val = node.getNodeValue();
                if (buf != null) {
                    buf.append(val);
                } else if (str != null) {
                    buf = new StringBuilder();
                    buf.append(str);
                    buf.append(val);
                    str = null;
                } else {
                    str = val;
                }
            }
            ++i;
        }
        if (buf != null) {
            return buf.toString();
        }
        return str != null ? str : "";
    }

    @Override
    public void setText(String elementText) {
        this.validateEdit();
        if (elementText == null) {
            elementText = "";
        }
        Element domElement = this.getDomNode();
        NodeList elementChildren = domElement.getChildNodes();
        CharacterData text = null;
        int i = 0;
        int n = elementChildren.getLength();
        while (i < n) {
            Node child = elementChildren.item(i);
            if (text == null && child.getNodeType() == 3) {
                text = (Text)child;
            } else {
                domElement.removeChild(elementChildren.item(i));
            }
            ++i;
        }
        if (text != null) {
            text.setData(elementText);
        } else {
            domElement.appendChild(domElement.getOwnerDocument().createTextNode(elementText));
        }
    }

    public List<XmlAttribute> getAttributes() {
        ListFactory<XmlAttribute> result = new ListFactory<XmlAttribute>();
        NamedNodeMap attributes = this.getDomNode().getAttributes();
        this.attributesCache.track();
        int i = 0;
        int count = attributes.getLength();
        while (i < count) {
            Attr attribute = (Attr)attributes.item(i);
            XmlAttribute xmlAttribute = this.attributesCache.get(attribute);
            if (xmlAttribute == null) {
                xmlAttribute = new XmlAttribute(this, attribute);
                this.attributesCache.put(attribute, xmlAttribute);
            }
            result.add(xmlAttribute);
            ++i;
        }
        this.attributesCache.purge();
        return result.create();
    }

    public XmlAttribute getAttribute(String name, boolean createIfNecessary) {
        XmlAttribute attribute = null;
        for (XmlAttribute attr : this.getAttributes()) {
            if (!XmlElement.equal(attr.getLocalName(), name)) continue;
            attribute = attr;
            break;
        }
        if (attribute == null && createIfNecessary) {
            this.validateEdit();
            Element domElement = this.getDomNode();
            Attr attr = domElement.getOwnerDocument().createAttribute(name);
            domElement.setAttributeNode(attr);
            attribute = new XmlAttribute(this, attr);
            this.attributesCache.put(attr, attribute);
        }
        return attribute;
    }

    public String getAttributeText(String name) {
        XmlAttribute attr = this.getAttribute(name, false);
        if (attr == null) {
            return "";
        }
        return attr.getText();
    }

    public void setAttributeText(String name, String value, boolean removeIfNullOrEmpty) {
        String val;
        this.validateEdit();
        String string = val = value == null ? "" : value;
        if (val.length() == 0) {
            XmlAttribute attr = this.getAttribute(name, false);
            if (attr != null) {
                if (removeIfNullOrEmpty) {
                    attr.remove();
                } else {
                    this.getAttribute(name, true).setText(val);
                }
            }
        } else {
            this.getAttribute(name, true).setText(val);
        }
    }

    public List<XmlElement> getChildElements() {
        ListFactory<XmlElement> result = new ListFactory<XmlElement>();
        NodeList children = this.getDomNode().getChildNodes();
        this.elementsCache.track();
        int i = 0;
        int count = children.getLength();
        while (i < count) {
            Node n = children.item(i);
            if (n.getNodeType() == 1) {
                Element element = (Element)n;
                XmlElement xmlElement = this.elementsCache.get(element);
                if (xmlElement == null) {
                    xmlElement = new XmlElement(this, element);
                    this.elementsCache.put(element, xmlElement);
                }
                result.add(xmlElement);
            }
            ++i;
        }
        this.elementsCache.purge();
        return result.create();
    }

    public List<XmlElement> getChildElements(QName name) {
        ListFactory<XmlElement> result = new ListFactory<XmlElement>();
        for (XmlElement element : this.getChildElements()) {
            if (!XmlElement.equal(XmlElement.normalizeToNull(element.getNamespace()), XmlElement.normalizeToNull(name.getNamespaceURI())) || !XmlElement.equal(element.getLocalName(), name.getLocalPart())) continue;
            result.add(element);
        }
        return result.create();
    }

    public List<XmlElement> getChildElements(String name) {
        return this.getChildElements(this.createQualifiedName(name));
    }

    public XmlElement getChildElement(QName name, boolean createIfNecessary) {
        for (XmlElement element : this.getChildElements()) {
            if (!XmlElement.equal(XmlElement.normalizeToNull(element.getNamespace()), XmlElement.normalizeToNull(name.getNamespaceURI())) || !XmlElement.equal(element.getLocalName(), name.getLocalPart())) continue;
            return element;
        }
        if (createIfNecessary) {
            return this.addChildElement(name);
        }
        return null;
    }

    public XmlElement getChildElement(String name, boolean createIfNecessary) {
        return this.getChildElement(this.createQualifiedName(name), createIfNecessary);
    }

    public XmlElement addChildElement(QName name) {
        Element element;
        Node prevChild;
        this.validateEdit();
        Element domElement = this.getDomNode();
        Document document = domElement.getOwnerDocument();
        NodeList nodes = domElement.getChildNodes();
        XmlContentModel xmlContentModel = this.getContentModel();
        int position = xmlContentModel == null ? nodes.getLength() : xmlContentModel.findInsertionPosition(nodes, name);
        Node refChild = position < nodes.getLength() ? nodes.item(position) : null;
        int prevPosition = position - 1;
        Node node = prevChild = prevPosition < nodes.getLength() ? nodes.item(prevPosition) : null;
        if (prevChild != null && prevChild.getNodeType() == 3 && prevChild.getNodeValue().trim().length() == 0) {
            refChild = prevChild;
            position = prevPosition;
        }
        prevChild = (prevPosition = position - 1) < nodes.getLength() ? nodes.item(prevPosition) : null;
        String namespace = name.getNamespaceURI();
        if (namespace == null || namespace.length() == 0) {
            element = document.createElementNS(null, name.getLocalPart());
        } else {
            String prefix = this.findNamespacePrefix(namespace, name.getPrefix());
            String qname = prefix == null || prefix.length() == 0 ? name.getLocalPart() : String.valueOf(prefix) + ":" + name.getLocalPart();
            element = document.createElementNS(namespace, qname);
        }
        domElement.insertBefore(element, refChild);
        XmlElement wrappedElement = new XmlElement(this, element);
        this.elementsCache.put(element, wrappedElement);
        if (domElement.getNodeType() == 1 && domElement.getChildNodes().getLength() == 1) {
            this.format();
        } else {
            wrappedElement.format();
        }
        return wrappedElement;
    }

    public XmlElement addChildElement(String name) {
        return this.addChildElement(this.createQualifiedName(name));
    }

    private String findNamespacePrefix(String namespace, String defaultPrefix) {
        Element domElement = this.getDomNode();
        String prefix = null;
        if (namespace != null && namespace.length() > 0) {
            String ns = this.getNamespace();
            if (ns != null && ns.equals(namespace)) {
                prefix = domElement.getPrefix();
            } else {
                Element el = domElement;
                boolean found = false;
                while (el != null && !found) {
                    NamedNodeMap attributes = el.getAttributes();
                    int i = 0;
                    int n = attributes.getLength();
                    while (i < n) {
                        Attr attr = (Attr)attributes.item(i);
                        String attrName = attr.getName();
                        String attrValue = attr.getValue();
                        if (attrName.equals("xmlns")) {
                            if (attrValue.equals(namespace)) {
                                found = true;
                                break;
                            }
                        } else if (attrName.startsWith("xmlns:") && attrValue.equals(namespace)) {
                            prefix = attrName.substring(6);
                            found = true;
                            break;
                        }
                        ++i;
                    }
                    Node parent = el.getParentNode();
                    el = parent instanceof Element ? (Element)parent : null;
                }
                if (!found) {
                    prefix = defaultPrefix;
                    String xmlnsAttrName = "xmlns:" + defaultPrefix;
                    Element root = domElement.getOwnerDocument().getDocumentElement();
                    root.setAttribute(xmlnsAttrName, namespace);
                    if (!namespace.equals("http://www.w3.org/2001/XMLSchema-instance")) {
                        XmlContentModel xmlContentModel = this.getContentModel();
                        String schemaLocation = null;
                        if (xmlContentModel != null) {
                            schemaLocation = xmlContentModel.getSchema().getSchemaLocation(namespace);
                        }
                        this.addSchemaLocation(namespace, schemaLocation);
                    }
                }
            }
        }
        return prefix;
    }

    private void addSchemaLocation(String namespace, String schemaLocation) {
        if (schemaLocation != null) {
            String xsiNamespacePrefix = this.findNamespacePrefix("http://www.w3.org/2001/XMLSchema-instance", "xsi");
            String schemaLocationAttrName = xsiNamespacePrefix == null ? "schemaLocation" : String.valueOf(xsiNamespacePrefix) + ":schemaLocation";
            Element root = this.getDomNode().getOwnerDocument().getDocumentElement();
            String existingSchemaLocations = root.getAttribute(schemaLocationAttrName);
            LinkedHashMap<String, String> schemaLocations = new LinkedHashMap<String, String>();
            if (existingSchemaLocations != null && existingSchemaLocations.length() > 0) {
                String ns = null;
                String[] stringArray = existingSchemaLocations.split("[\\s]+");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String segment = stringArray[n2];
                    if (ns == null) {
                        ns = segment;
                    } else {
                        schemaLocations.put(ns, segment);
                        ns = null;
                    }
                    ++n2;
                }
            }
            schemaLocations.put(namespace, schemaLocation);
            StringBuilder buf = new StringBuilder();
            for (Map.Entry entry : schemaLocations.entrySet()) {
                if (buf.length() > 0) {
                    buf.append(' ');
                }
                buf.append((String)entry.getKey());
                buf.append(' ');
                buf.append((String)entry.getValue());
            }
            root.setAttribute(schemaLocationAttrName, buf.toString());
        }
    }

    public XmlNode getChildNode(XmlPath path, boolean createIfNecessary) {
        XmlElement el = this;
        for (XmlPath.Segment segment : path.getSegments()) {
            XmlNode node = el.getChildNode(segment, createIfNecessary);
            if (node instanceof XmlElement) {
                el = (XmlElement)node;
                continue;
            }
            return node;
        }
        return el;
    }

    public XmlNode getChildNode(XmlPath.Segment pathSegment, boolean createIfNecessary) {
        XmlPath.Segment resolvedPathSegment = this.resolveXmlPathSegment(pathSegment);
        QName qname = resolvedPathSegment.getQualifiedName();
        if (resolvedPathSegment.isAttribute()) {
            return this.getAttribute(qname.getLocalPart(), createIfNecessary);
        }
        if (resolvedPathSegment.isComment()) {
            return this.getMetaComment(qname.getLocalPart(), createIfNecessary);
        }
        return this.getChildElement(qname, createIfNecessary);
    }

    public String getChildNodeText(XmlPath path) {
        return this.getChildNodeText(path, false);
    }

    public String getChildNodeText(XmlPath path, boolean removeExtraWhitespace) {
        XmlNode node = this.getChildNode(path, false);
        if (node != null) {
            return node.getText(removeExtraWhitespace);
        }
        return "";
    }

    public String getChildNodeText(String path) {
        return this.getChildNodeText(new XmlPath(path));
    }

    public String getChildNodeText(String path, boolean removeExtraWhitespace) {
        return this.getChildNodeText(new XmlPath(path), removeExtraWhitespace);
    }

    public void setChildNodeText(XmlPath path, String text, boolean removeIfNullOrEmpty) {
        this.validateEdit();
        if (removeIfNullOrEmpty && (text == null || text.trim().length() == 0) && path.getSegmentCount() > 0) {
            this.removeChildNode(path);
        } else {
            this.getChildNode(path, true).setText(text);
        }
    }

    public void setChildNodeText(String path, String text, boolean removeIfNullOrEmpty) {
        this.setChildNodeText(new XmlPath(path), text, removeIfNullOrEmpty);
    }

    public void removeChildNode(XmlPath path) {
        this.removeChildNode(this, path, 0);
    }

    private void removeChildNode(XmlElement el, XmlPath path, int pathPosition) {
        this.validateEdit();
        XmlPath.Segment segment = path.getSegment(pathPosition);
        XmlNode child = el.getChildNode(segment, false);
        if (child != null) {
            if (pathPosition == path.getSegmentCount() - 1) {
                child.remove();
            } else if (child instanceof XmlElement) {
                XmlElement childElement = (XmlElement)child;
                this.removeChildNode(childElement, path, pathPosition + 1);
                if (childElement.isEmpty()) {
                    childElement.remove();
                }
            }
        }
    }

    public void swap(XmlElement y) {
        this.validateEdit();
        Element domElement = this.getDomNode();
        Node parent = domElement.getParentNode();
        Document document = parent.getOwnerDocument();
        Text xBookmark = document.createTextNode("");
        parent.insertBefore(xBookmark, domElement);
        Text yBookmark = document.createTextNode("");
        parent.insertBefore(yBookmark, y.getDomNode());
        parent.removeChild(domElement);
        parent.removeChild(y.getDomNode());
        parent.insertBefore(domElement, yBookmark);
        parent.insertBefore(y.getDomNode(), xBookmark);
        parent.removeChild(xBookmark);
        parent.removeChild(yBookmark);
    }

    @Override
    public void remove() {
        this.validateEdit();
        Element domElement = this.getDomNode();
        Node parentDomNode = domElement.getParentNode();
        if (parentDomNode != null) {
            Node previousSibling = domElement.getPreviousSibling();
            parentDomNode.removeChild(domElement);
            if (previousSibling != null && previousSibling.getNodeType() == 3 && previousSibling.getNodeValue().trim().length() == 0) {
                parentDomNode.removeChild(previousSibling);
            }
        }
    }

    public boolean isEmpty() {
        NodeList nodes = this.getDomNode().getChildNodes();
        int i = 0;
        int n = nodes.getLength();
        while (i < n) {
            Node child = nodes.item(i);
            if (child.getNodeType() != 3 || child.getNodeValue().trim().length() > 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public List<XmlComment> getComments() {
        ListFactory<XmlComment> result = new ListFactory<XmlComment>();
        NodeList children = this.getDomNode().getChildNodes();
        this.commentsCache.track();
        int i = 0;
        int count = children.getLength();
        while (i < count) {
            Node n = children.item(i);
            if (n.getNodeType() == 8) {
                Comment comment = (Comment)n;
                XmlComment xmlComment = this.commentsCache.get(comment);
                if (xmlComment == null) {
                    xmlComment = new XmlComment(this, comment);
                    this.commentsCache.put(comment, xmlComment);
                }
                result.add(xmlComment);
            }
            ++i;
        }
        this.commentsCache.purge();
        return result.create();
    }

    public XmlComment addComment(String commentText) {
        Node prevChild;
        this.validateEdit();
        Element domElement = this.getDomNode();
        Document document = domElement.getOwnerDocument();
        NodeList nodes = domElement.getChildNodes();
        int position = 0;
        int n = nodes.getLength();
        while (position < n) {
            Node child = nodes.item(position);
            if (child.getNodeType() != 8 && child.getNodeType() != 3) break;
            ++position;
        }
        Node refChild = position < nodes.getLength() ? nodes.item(position) : null;
        int prevPosition = position - 1;
        Node node = prevChild = prevPosition < nodes.getLength() ? nodes.item(prevPosition) : null;
        if (prevChild != null && prevChild.getNodeType() == 3 && prevChild.getNodeValue().trim().length() == 0) {
            refChild = prevChild;
            position = prevPosition;
        }
        prevChild = (prevPosition = position - 1) < nodes.getLength() ? nodes.item(prevPosition) : null;
        Comment comment = document.createComment(commentText);
        domElement.insertBefore(comment, refChild);
        XmlComment wrappedComment = new XmlComment(this, comment);
        this.commentsCache.put(comment, wrappedComment);
        if (domElement.getNodeType() == 1 && domElement.getChildNodes().getLength() == 1) {
            this.format();
        } else {
            wrappedComment.format();
        }
        return wrappedComment;
    }

    public List<XmlMetaComment> getMetaComments() {
        ListFactory<XmlMetaComment> result = new ListFactory<XmlMetaComment>();
        NodeList children = this.getDomNode().getChildNodes();
        this.metaCommentsCache.track();
        int i = 0;
        int count = children.getLength();
        while (i < count) {
            Node n = children.item(i);
            if (n.getNodeType() == 8 && n.getNodeValue().indexOf(58) != -1) {
                Comment metaComment = (Comment)n;
                XmlMetaComment xmlMetaComment = this.metaCommentsCache.get(metaComment);
                if (xmlMetaComment == null) {
                    xmlMetaComment = new XmlMetaComment(this, metaComment);
                    this.metaCommentsCache.put(metaComment, xmlMetaComment);
                }
                result.add(xmlMetaComment);
            }
            ++i;
        }
        this.metaCommentsCache.purge();
        return result.create();
    }

    public XmlMetaComment getMetaComment(String name, boolean createIfNecessary) {
        XmlMetaComment xmlMetaComment = null;
        for (XmlMetaComment x : this.getMetaComments()) {
            if (!XmlElement.equal(x.getName(), name)) continue;
            xmlMetaComment = x;
            break;
        }
        if (xmlMetaComment == null && createIfNecessary) {
            Comment comment = this.addComment(String.valueOf(name) + ":").getDomNode();
            xmlMetaComment = new XmlMetaComment(this, comment);
            this.metaCommentsCache.put(comment, xmlMetaComment);
        }
        return xmlMetaComment;
    }

    public String getMetaCommentText(String name) {
        XmlMetaComment comment = this.getMetaComment(name, false);
        if (comment != null) {
            return comment.getText();
        }
        return null;
    }

    public void setMetaCommentText(String name, String value) {
        this.validateEdit();
        if (value != null && value.length() == 0) {
            value = null;
        }
        XmlMetaComment comment = this.getMetaComment(name, true);
        if (value != null) {
            comment.setText(value);
        } else {
            comment.remove();
        }
    }

    private XmlPath.Segment resolveXmlPathSegment(XmlPath.Segment pathSegment) {
        String namespace = pathSegment.getQualifiedName().getNamespaceURI();
        if (pathSegment.isAttribute() || pathSegment.isComment() || namespace.length() != 0) {
            return pathSegment;
        }
        String prefix = pathSegment.getQualifiedName().getPrefix();
        if (prefix.length() == 0) {
            namespace = this.getDomNode().getNamespaceURI();
        }
        QName newQualifiedName = new QName(namespace, pathSegment.getQualifiedName().getLocalPart(), prefix);
        return new XmlPath.Segment(newQualifiedName, false, false);
    }

    private QName createQualifiedName(String localName) {
        String namespace = this.getDomNode().getNamespaceURI();
        return new QName(namespace, localName);
    }

    private static final boolean equal(Object obj1, Object obj2) {
        boolean objectsAreEqual = false;
        if (obj1 == obj2) {
            objectsAreEqual = true;
        } else if (obj1 != null && obj2 != null) {
            objectsAreEqual = obj1.equals(obj2);
        }
        return objectsAreEqual;
    }

    private static final String normalizeToNull(String str) {
        if (str != null && str.equals("")) {
            return null;
        }
        return str;
    }
}

