/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sapphire.ui.SapphireImageCache;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public final class ProblemOverlayImageDescriptor
extends CompositeImageDescriptor {
    private static final ImageData IMG_DATA_ERROR_OVERLAY = SapphireImageCache.OVERLAY_ERROR.getImageData();
    private static final ImageData IMG_DATA_WARNING_OVERLAY = SapphireImageCache.OVERLAY_WARNING.getImageData();
    private final ImageData base;
    private final ImageData overlay;
    private final Point size;

    public ProblemOverlayImageDescriptor(ImageDescriptor base, int severity) {
        this.base = base.getImageData();
        this.overlay = this.getOverlay(severity);
        this.size = new Point(this.base.width, this.base.height);
    }

    protected void drawCompositeImage(int width, int height) {
        this.drawImage(this.base, 0, 0);
        this.drawImage(this.overlay, 0, height - this.overlay.height);
    }

    protected Point getSize() {
        return this.size;
    }

    private ImageData getOverlay(int severity) {
        if (severity == 4) {
            return IMG_DATA_ERROR_OVERLAY;
        }
        if (severity == 2) {
            return IMG_DATA_WARNING_OVERLAY;
        }
        throw new IllegalArgumentException();
    }
}

