/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import java.util.Collections;
import java.util.Set;
import org.eclipse.help.IContext;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.localization.LocalizationService;
import org.eclipse.sapphire.ui.SapphireActionGroup;
import org.eclipse.sapphire.ui.SapphireComposite;
import org.eclipse.sapphire.ui.SapphireCondition;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.def.ISapphireDocumentation;
import org.eclipse.sapphire.ui.def.ISapphireDocumentationDef;
import org.eclipse.sapphire.ui.def.ISapphireDocumentationRef;
import org.eclipse.sapphire.ui.def.ISapphireSectionDef;
import org.eclipse.sapphire.ui.internal.TableWrapLayoutUtil;
import org.eclipse.sapphire.ui.swt.SapphireTextPopup;
import org.eclipse.sapphire.ui.swt.renderer.GridLayoutUtil;
import org.eclipse.sapphire.ui.swt.renderer.SapphireActionPresentationManager;
import org.eclipse.sapphire.ui.swt.renderer.SapphireToolBarActionPresentation;
import org.eclipse.sapphire.ui.swt.renderer.internal.formtext.SapphireFormText;
import org.eclipse.sapphire.ui.util.SapphireHelpSystem;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SapphireSection
extends SapphireComposite {
    private static final String BREAK_TOKEN = "###brk###";
    private ISapphireSectionDef definition;
    private SapphireCondition visibleWhenCondition;
    private Section section;
    private FunctionResult titleFunctionResult;
    private SapphireFormText descriptionFormText;
    private FunctionResult descriptionFunctionResult;
    private String descriptionExtendedContent;

    @Override
    protected void init() {
        super.init();
        this.definition = (ISapphireSectionDef)((SapphireComposite)this).definition;
        this.visibleWhenCondition = null;
        Class visibleWhenConditionClass = (Class)this.definition.getVisibleWhenConditionClass().resolve();
        if (visibleWhenConditionClass != null) {
            String parameter = this.definition.getVisibleWhenConditionParameter().getText();
            this.visibleWhenCondition = SapphireCondition.create(this, visibleWhenConditionClass, parameter);
        }
    }

    @Override
    protected Composite createOuterComposite(SapphireRenderingContext context) {
        String description = this.definition.getDescription().getLocalizedText();
        FormToolkit toolkit = new FormToolkit(context.getDisplay());
        this.section = toolkit.createSection(context.getComposite(), 256);
        this.section.setLayoutData((Object)TableWrapLayoutUtil.twd());
        this.titleFunctionResult = this.initExpression(this.definition.getLabel(), new Runnable(){

            public void run() {
                SapphireSection.this.refreshTitle();
            }
        });
        this.refreshTitle();
        Composite outerComposite = new Composite((Composite)this.section, 0);
        outerComposite.setLayout((Layout)TableWrapLayoutUtil.twlayout(1, 0, 0, 0, 0));
        context.adapt((Control)outerComposite);
        this.descriptionFunctionResult = this.initExpression(this.definition.getDescription(), new Runnable(){

            public void run() {
                SapphireSection.this.refreshDescription();
            }
        });
        if (this.descriptionFunctionResult != null) {
            this.descriptionFormText = new SapphireFormText(outerComposite, 0);
            this.descriptionFormText.setLayoutData(TableWrapLayoutUtil.twdindent(TableWrapLayoutUtil.twd(), 9));
            context.adapt((Control)this.descriptionFormText);
            this.descriptionFormText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent event) {
                    SapphireSection.this.activateExtendedDescriptionContentPopup();
                }
            });
            this.refreshDescription();
        }
        Composite innerComposite = new Composite(outerComposite, 0);
        innerComposite.setLayout((Layout)GridLayoutUtil.glayout(2, 0, 0, description != null ? 8 : 0, 0));
        innerComposite.setLayoutData((Object)TableWrapLayoutUtil.twd());
        context.adapt((Control)innerComposite);
        SapphireActionGroup actions = this.getActions();
        SapphireActionPresentationManager actionPresentationManager = new SapphireActionPresentationManager(context, actions);
        SapphireToolBarActionPresentation toolBarActionsPresentation = new SapphireToolBarActionPresentation(actionPresentationManager);
        ToolBar toolbar = new ToolBar((Composite)this.section, 0x800100);
        toolBarActionsPresentation.setToolBar(toolbar);
        toolBarActionsPresentation.render();
        this.section.setTextClient((Control)toolbar);
        toolkit.paintBordersFor((Composite)this.section);
        this.section.setClient((Control)outerComposite);
        return innerComposite;
    }

    private void refreshTitle() {
        String title = null;
        if (this.titleFunctionResult != null) {
            title = (String)this.titleFunctionResult.value();
        }
        if (title == null) {
            title = "#null#";
        } else {
            title = title.trim();
            title = ((LocalizationService)this.definition.adapt(LocalizationService.class)).transform(title, CapitalizationType.TITLE_STYLE, false);
        }
        this.section.setText(title.trim());
    }

    private void refreshDescription() {
        String description = null;
        if (this.descriptionFunctionResult != null) {
            description = (String)this.descriptionFunctionResult.value();
        }
        description = description == null ? "#null#" : description.trim();
        int index = description.indexOf(BREAK_TOKEN);
        StringBuilder buf = new StringBuilder();
        buf.append("<form><p vspace=\"false\">");
        if (index > 0) {
            String displayDescription = description.substring(0, index);
            buf.append(displayDescription);
            buf.append("<a href=\"action\" nowrap=\"true\">");
            buf.append(Resources.moreDetails);
            buf.append("</a>");
            this.descriptionExtendedContent = String.valueOf(displayDescription) + description.substring(index + BREAK_TOKEN.length(), description.length());
        } else {
            buf.append(description);
            this.descriptionExtendedContent = null;
        }
        buf.append("</p></form>");
        this.descriptionFormText.setText(buf.toString(), true, false);
    }

    private void activateExtendedDescriptionContentPopup() {
        if (this.descriptionExtendedContent != null) {
            Point cursor = this.descriptionFormText.getDisplay().getCursorLocation();
            Rectangle bounds = this.descriptionFormText.getBounds();
            Point location = this.descriptionFormText.toDisplay(new Point(bounds.x, bounds.y));
            Rectangle displayBounds = new Rectangle(location.x, location.y, bounds.width, bounds.height);
            Point position = displayBounds.contains(cursor) ? cursor : new Point(location.x, location.y + bounds.height + 2);
            SapphireTextPopup popup = new SapphireTextPopup(this.descriptionFormText.getDisplay(), position);
            popup.setText(this.descriptionExtendedContent);
            popup.open();
        }
    }

    @Override
    public Set<String> getActionContexts() {
        return Collections.singleton("Sapphire.Section");
    }

    @Override
    public IContext getDocumentationContext() {
        ISapphireDocumentation doc = (ISapphireDocumentation)this.definition.getDocumentation().element();
        if (doc != null) {
            ISapphireDocumentationDef docdef = null;
            docdef = doc instanceof ISapphireDocumentationDef ? (ISapphireDocumentationDef)doc : ((ISapphireDocumentationRef)doc).resolve();
            if (docdef != null) {
                SapphireHelpSystem.getContext(docdef);
            }
        }
        return null;
    }

    public SapphireCondition getVisibleWhenCondition() {
        return this.visibleWhenCondition;
    }

    public boolean checkVisibleWhenCondition() {
        if (this.visibleWhenCondition != null) {
            return this.visibleWhenCondition.getConditionState();
        }
        return true;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.visibleWhenCondition != null) {
            this.visibleWhenCondition.dispose();
        }
    }

    private static final class Resources
    extends NLS {
        public static String moreDetails;

        static {
            Resources.initializeMessages((String)SapphireSection.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

