/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.renderers.swt;

import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.ui.renderers.swt.CompactListPropertyEditorRenderer;
import org.eclipse.sapphire.ui.renderers.swt.CompactListTextAssistDecorator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;

public final class CompactTextBinding
implements ModifyListener {
    private final CompactListPropertyEditorRenderer compactListPropertyEditorRenderer;
    private Text text;
    private ToolBar toolbar;
    private CompactListPropertyEditorRenderer.DeleteActionHandler deleteActionHandler;
    private CompactListTextAssistDecorator decorator;
    private IModelElement element;
    private boolean modifying = false;

    public CompactTextBinding(CompactListPropertyEditorRenderer compactListPropertyEditorRenderer, Text text) {
        this.compactListPropertyEditorRenderer = compactListPropertyEditorRenderer;
        this.text = text;
        this.text.addModifyListener((ModifyListener)this);
    }

    public void removeListener() {
        this.text.removeModifyListener((ModifyListener)this);
    }

    public Text getText() {
        return this.text;
    }

    public void setModelElement(IModelElement element) {
        this.element = element;
    }

    public IModelElement getModelElement() {
        return this.element;
    }

    public boolean isModifying() {
        return this.modifying;
    }

    public void setModifying(boolean modifying) {
        this.modifying = modifying;
    }

    public ToolBar getToolbar() {
        return this.toolbar;
    }

    public void setToolbar(ToolBar toolbar) {
        this.toolbar = toolbar;
    }

    public CompactListPropertyEditorRenderer.DeleteActionHandler getDeleteActionHandler() {
        return this.deleteActionHandler;
    }

    public void setDeleteActionHandler(CompactListPropertyEditorRenderer.DeleteActionHandler deleteActionHandler) {
        this.deleteActionHandler = deleteActionHandler;
    }

    public CompactListTextAssistDecorator getDecorator() {
        return this.decorator;
    }

    public void setDecorator(CompactListTextAssistDecorator decorator) {
        this.decorator = decorator;
    }

    public void modifyText(ModifyEvent e) {
        if (!this.text.isDisposed() && (this.text.getStyle() & 8) == 0) {
            String value = this.text.getText();
            if (this.element != null || value.length() > 0) {
                this.modifying = true;
                boolean createNew = false;
                if (this.element == null) {
                    this.setModelElement(this.compactListPropertyEditorRenderer.getList().addNewElement());
                    createNew = true;
                }
                this.element.write(this.compactListPropertyEditorRenderer.memberProperty, (Object)value);
                if (createNew) {
                    this.text.setSelection(value.length(), value.length());
                }
                this.modifying = false;
            }
        }
    }
}

