/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.renderers.swt;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.OwnerDrawLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.EnumValueType;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelPropertyChangeEvent;
import org.eclipse.sapphire.modeling.ModelPropertyListener;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.FixedOrderList;
import org.eclipse.sapphire.modeling.annotations.Image;
import org.eclipse.sapphire.modeling.serialization.ValueSerializationService;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionGroup;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphireActionSystem;
import org.eclipse.sapphire.ui.SapphireActionSystemPart;
import org.eclipse.sapphire.ui.SapphireImageCache;
import org.eclipse.sapphire.ui.SapphirePropertyEditor;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.assist.internal.PropertyEditorAssistDecorator;
import org.eclipse.sapphire.ui.def.ISapphireActionHandlerDef;
import org.eclipse.sapphire.ui.internal.EnhancedComposite;
import org.eclipse.sapphire.ui.internal.ReadOnlyComboBoxCellEditor;
import org.eclipse.sapphire.ui.internal.binding.AbstractBinding;
import org.eclipse.sapphire.ui.renderers.swt.ListPropertyEditorRenderer;
import org.eclipse.sapphire.ui.renderers.swt.PropertyEditorRenderer;
import org.eclipse.sapphire.ui.renderers.swt.PropertyEditorRendererFactory;
import org.eclipse.sapphire.ui.swt.renderer.GridLayoutUtil;
import org.eclipse.sapphire.ui.swt.renderer.HyperlinkTable;
import org.eclipse.sapphire.ui.swt.renderer.SapphireActionPresentationManager;
import org.eclipse.sapphire.ui.swt.renderer.SapphireMenuActionPresentation;
import org.eclipse.sapphire.ui.swt.renderer.SapphireTextCellEditor;
import org.eclipse.sapphire.ui.swt.renderer.SapphireToolBarActionPresentation;
import org.eclipse.sapphire.ui.swt.renderer.SwtUtil;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultListPropertyEditorRenderer
extends ListPropertyEditorRenderer {
    public static final String DATA_SELECTION_PROVIDER = "selection.provider";
    private boolean exposeAddAction = true;
    private boolean exposeDeleteAction = true;
    private Table table;
    private TableViewer tableViewer;
    private SelectionProvider selectionProvider;
    private List<ColumnHandler> columnHandlers;
    private Runnable refreshOperation;

    public DefaultListPropertyEditorRenderer(SapphireRenderingContext context, SapphirePropertyEditor part) {
        super(context, part);
    }

    @Override
    protected void createContents(Composite parent) {
        this.createContents(parent, false, false);
    }

    protected Control createContents(Composite parent, boolean suppressLabel, boolean ignoreLeftMarginHint) {
        TableColumnLayout tableColumnLayout;
        EnhancedComposite tableParentComposite;
        boolean renderAsList;
        EnhancedComposite innerComposite;
        Label label;
        SapphirePropertyEditor part = this.getPart();
        part.getModelElement();
        ListProperty property = (ListProperty)part.getProperty();
        boolean isReadOnly = property.isReadOnly() || part.getRenderingHint("read.only", false);
        boolean showLabelAbove = part.getRenderingHint("show.label.above", false);
        boolean showLabelInline = part.getRenderingHint("show.label", suppressLabel ? false : !showLabelAbove);
        int leftMargin = ignoreLeftMarginHint ? 0 : part.getLeftMarginHint();
        boolean showHeader = part.getRenderingHint("show.header", true);
        final SapphireActionGroup actions = this.getActions();
        SapphireActionPresentationManager actionPresentationManager = this.getActionPresentationManager();
        SapphireToolBarActionPresentation toolBarActionsPresentation = new SapphireToolBarActionPresentation(actionPresentationManager);
        toolBarActionsPresentation.addFilter(SapphireActionSystem.createFilterByActionId("Sapphire.Assist"));
        toolBarActionsPresentation.addFilter(SapphireActionSystem.createFilterByActionId("Sapphire.Jump"));
        SapphireMenuActionPresentation menuActionsPresentation = new SapphireMenuActionPresentation(actionPresentationManager);
        menuActionsPresentation.addFilter(SapphireActionSystem.createFilterByActionId("Sapphire.Assist"));
        menuActionsPresentation.addFilter(SapphireActionSystem.createFilterByActionId("Sapphire.Jump"));
        if (showLabelInline || showLabelAbove) {
            String labelText = String.valueOf(property.getLabel(false, CapitalizationType.FIRST_WORD_ONLY, true)) + ":";
            label = new Label(parent, 0);
            label.setLayoutData((Object)GridLayoutUtil.gdhindent(GridLayoutUtil.gdhspan(GridLayoutUtil.gdvalign(GridLayoutUtil.gd(), 128), showLabelAbove ? 2 : 1), leftMargin + 9));
            label.setText(labelText);
            this.context.adapt((Control)label);
        } else {
            label = null;
        }
        boolean expandVertically = part.getRenderingHint("expand.vertically", false);
        int heightHint = part.getRenderingHint("height", 10) * 15;
        GridData gd = expandVertically ? GridLayoutUtil.gdfill() : GridLayoutUtil.gdhhint(GridLayoutUtil.gdhfill(), heightHint);
        gd = GridLayoutUtil.gdhindent(GridLayoutUtil.gdhspan(gd, showLabelInline ? 1 : 2), showLabelInline ? 0 : leftMargin);
        EnhancedComposite tableComposite = new EnhancedComposite(parent, 0);
        tableComposite.setLayoutData(gd);
        tableComposite.setLayout((Layout)GridLayoutUtil.glayout(isReadOnly ? 1 : 2, 0, 0, 0, 0));
        this.context.adapt((Control)tableComposite);
        if (this.decorator == null) {
            innerComposite = new Composite((Composite)tableComposite, 0);
            innerComposite.setLayoutData(GridLayoutUtil.gdfill());
            innerComposite.setLayout((Layout)GridLayoutUtil.glspacing(GridLayoutUtil.glayout(2, 0, 0), 2));
            this.context.adapt((Control)innerComposite);
            this.decorator = this.createDecorator(innerComposite);
            this.decorator.getControl().setLayoutData((Object)GridLayoutUtil.gdvalign(GridLayoutUtil.gd(), 128));
            this.decorator.addEditorControl((Control)innerComposite);
        } else {
            innerComposite = tableComposite;
        }
        this.decorator.addEditorControl((Control)tableComposite);
        final ArrayList<ValueProperty> columnProperties = new ArrayList<ValueProperty>();
        for (ModelProperty childProperty : part.getChildProperties()) {
            if (!(childProperty instanceof ValueProperty)) continue;
            columnProperties.add((ValueProperty)childProperty);
        }
        boolean singleColumnTable = columnProperties.size() == 1;
        boolean bl = renderAsList = singleColumnTable && !showHeader && !((ValueProperty)columnProperties.get(0)).isOfType(Boolean.class);
        if (renderAsList) {
            tableParentComposite = innerComposite;
            tableColumnLayout = null;
        } else {
            tableParentComposite = new Composite((Composite)innerComposite, 0);
            tableParentComposite.setLayoutData(GridLayoutUtil.gdwhint(GridLayoutUtil.gdfill(), 1));
            tableColumnLayout = new TableColumnLayout();
            tableParentComposite.setLayout((Layout)tableColumnLayout);
        }
        this.tableViewer = new TableViewer((Composite)tableParentComposite, 67586);
        this.table = this.tableViewer.getTable();
        this.table.setLayoutData(renderAsList ? GridLayoutUtil.gdwhint(GridLayoutUtil.gdfill(), 200) : null);
        this.table.setData("assist-decorator", (Object)this.decorator);
        this.context.adapt((Control)this.table);
        this.decorator.addEditorControl((Control)this.table);
        ArrayList<Label> relatedControls = new ArrayList<Label>();
        this.table.setData("related-controls", relatedControls);
        if (label != null) {
            relatedControls.add(label);
        }
        this.table.addListener(41, new Listener(){

            public void handleEvent(Event event) {
                event.height = Math.max(event.height, 18);
            }
        });
        this.columnHandlers = new ArrayList<ColumnHandler>();
        ColumnViewerEditorActivationStrategy activationStrategy = new ColumnViewerEditorActivationStrategy((ColumnViewer)this.tableViewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                int columnIndex = ((ViewerCell)event.getSource()).getColumnIndex();
                ColumnHandler columnHandler = DefaultListPropertyEditorRenderer.this.getColumnHandler(columnIndex);
                return columnHandler.isEditorActivationEvent(event);
            }
        };
        TableViewerEditor.create((TableViewer)this.tableViewer, null, (ColumnViewerEditorActivationStrategy)activationStrategy, (int)20);
        this.table.setHeaderVisible(showHeader);
        this.selectionProvider = new SelectionProvider(this.tableViewer);
        this.table.setData(DATA_SELECTION_PROVIDER, (Object)this.selectionProvider);
        this.table.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent event) {
                DefaultListPropertyEditorRenderer.this.handleTableFocusGainedEvent();
            }
        });
        this.refreshOperation = new Runnable(){
            boolean running = false;

            public void run() {
                if (DefaultListPropertyEditorRenderer.this.table.isDisposed()) {
                    return;
                }
                if (this.running) {
                    return;
                }
                this.running = true;
                try {
                    DefaultListPropertyEditorRenderer.this.tableViewer.refresh();
                    DefaultListPropertyEditorRenderer.this.table.notifyListeners(13, null);
                }
                finally {
                    this.running = false;
                }
            }
        };
        this.binding = new AbstractBinding(this.getPart(), this.context, (Control)this.table){

            protected void doUpdateModel() {
            }

            protected void doUpdateTarget() {
                DefaultListPropertyEditorRenderer.this.refreshOperation.run();
            }
        };
        this.table.setData("binding", (Object)this.binding);
        if (renderAsList) {
            ValueProperty memberProperty = (ValueProperty)columnProperties.get(0);
            ColumnHandler columnHandler = this.createColumnHandler(this.columnHandlers, memberProperty, true);
            TableLabelProvider labelProvider = new TableLabelProvider((ColumnLabelProvider)columnHandler.getLabelProvider());
            this.tableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
            if (!memberProperty.isReadOnly()) {
                final AbstractColumnEditingSupport abstractColumnEditingSupport = columnHandler.getEditingSupport();
                this.tableViewer.setColumnProperties(new String[]{"a"});
                ICellModifier cellModifier = new ICellModifier(){

                    public boolean canModify(Object element, String property) {
                        return abstractColumnEditingSupport.canEdit(element);
                    }

                    public Object getValue(Object element, String property) {
                        return abstractColumnEditingSupport.getValue(element);
                    }

                    public void modify(Object element, String property, Object value) {
                        TableItem tableItem = (TableItem)element;
                        abstractColumnEditingSupport.setValue(tableItem.getData(), value);
                    }
                };
                this.tableViewer.setCellModifier(cellModifier);
                this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        IStructuredSelection ssel = (IStructuredSelection)DefaultListPropertyEditorRenderer.this.tableViewer.getSelection();
                        Object sel = ssel.getFirstElement();
                        if (sel != null) {
                            CellEditor cellEditor = abstractColumnEditingSupport.getCellEditor(sel);
                            DefaultListPropertyEditorRenderer.this.tableViewer.setCellEditors(new CellEditor[]{cellEditor});
                        }
                    }
                });
            }
        } else {
            boolean showImages = true;
            for (ModelElementType modelElementType : property.getAllPossibleTypes()) {
                if (modelElementType.getAnnotation(Image.class) != null) continue;
                showImages = false;
                break;
            }
            String columnWidthsHint = part.getRenderingHint("column.widths", "");
            StringTokenizer columnWidthsHintTokenizer = new StringTokenizer(columnWidthsHint, ",");
            for (ValueProperty valueProperty : columnProperties) {
                String columnWidthHint;
                String[] columnWidthHintSplit;
                TableViewerColumn col2 = new TableViewerColumn(this.tableViewer, 0);
                col2.getColumn().setText(valueProperty.getLabel(false, CapitalizationType.TITLE_STYLE, false));
                ColumnWeightData columnWeightData = null;
                if (columnWidthsHintTokenizer.hasMoreTokens() && ((columnWidthHintSplit = (columnWidthHint = columnWidthsHintTokenizer.nextToken()).split(":")).length == 1 || columnWidthHintSplit.length == 2)) {
                    try {
                        int minColumnWidth = Integer.parseInt(columnWidthHintSplit[0].trim());
                        int columnWeight = columnWidthHintSplit.length == 2 ? Integer.parseInt(columnWidthHintSplit[1].trim()) : 0;
                        columnWeightData = new ColumnWeightData(columnWeight, minColumnWidth, true);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                if (columnWeightData == null) {
                    columnWeightData = new ColumnWeightData(1, 100, true);
                }
                tableColumnLayout.setColumnData((Widget)col2.getColumn(), columnWeightData);
                final ColumnHandler columnHandler = this.createColumnHandler(this.columnHandlers, valueProperty, showImages);
                showImages = false;
                col2.setLabelProvider(columnHandler.getLabelProvider());
                col2.setEditingSupport((EditingSupport)columnHandler.getEditingSupport());
                final TableColumn tableColumn = col2.getColumn();
                tableColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        TableColumn currentSortColumn = DefaultListPropertyEditorRenderer.this.table.getSortColumn();
                        if (currentSortColumn != tableColumn) {
                            DefaultListPropertyEditorRenderer.this.table.setSortColumn(tableColumn);
                            DefaultListPropertyEditorRenderer.this.table.setSortDirection(1024);
                            DefaultListPropertyEditorRenderer.this.tableViewer.setComparator((ViewerComparator)new TableSorter(columnHandler, 1024));
                        } else {
                            int currentSortDirection = DefaultListPropertyEditorRenderer.this.table.getSortDirection();
                            if (currentSortDirection == 1024) {
                                DefaultListPropertyEditorRenderer.this.table.setSortDirection(128);
                                DefaultListPropertyEditorRenderer.this.tableViewer.setComparator((ViewerComparator)new TableSorter(columnHandler, 128));
                            } else {
                                DefaultListPropertyEditorRenderer.this.table.setSortColumn(null);
                                DefaultListPropertyEditorRenderer.this.tableViewer.setComparator(null);
                            }
                        }
                        for (SapphireAction action : actions.getActions()) {
                            for (SapphireActionHandler handler : action.getActiveHandlers()) {
                                if (!(handler instanceof AbstractActionHandler)) continue;
                                ((AbstractActionHandler)handler).refreshEnablement();
                            }
                        }
                    }
                });
            }
        }
        IStructuredContentProvider contentProvider = new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                ModelElementList<IModelElement> list = DefaultListPropertyEditorRenderer.this.getList();
                if (list != null) {
                    return list.toArray();
                }
                return new Object[0];
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        };
        this.tableViewer.setContentProvider((IContentProvider)contentProvider);
        this.tableViewer.setInput((Object)contentProvider);
        if (!isReadOnly) {
            this.table.addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent event) {
                    DefaultListPropertyEditorRenderer.this.handleTableTraverseEvent(event);
                }
            });
            if (this.exposeAddAction) {
                final SapphireAction addAction = actions.getAction("Sapphire.Add");
                for (ModelElementType memberType : this.getProperty().getAllPossibleTypes()) {
                    final AddActionHandler addActionHandler = new AddActionHandler(memberType);
                    ((SapphireActionHandler)addActionHandler).init(addAction, null);
                    addAction.addHandler(addActionHandler);
                    this.addOnDisposeOperation(new Runnable(){

                        public void run() {
                            addAction.removeHandler(addActionHandler);
                        }
                    });
                }
                SapphireActionSystemPart.Listener addActionHandlerListener = new SapphireActionSystemPart.Listener(){

                    public void handleEvent(SapphireActionSystemPart.Event event) {
                        if (event.getType().equals("post-execute")) {
                            if (DefaultListPropertyEditorRenderer.this.table.isDisposed()) {
                                return;
                            }
                            IModelElement newListElement = (IModelElement)((SapphireActionHandler.PostExecuteEvent)event).getResult();
                            if (newListElement != null) {
                                DefaultListPropertyEditorRenderer.this.refreshOperation.run();
                                DefaultListPropertyEditorRenderer.this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)newListElement), true);
                                DefaultListPropertyEditorRenderer.this.tableViewer.editElement((Object)newListElement, 0);
                                DefaultListPropertyEditorRenderer.this.table.notifyListeners(13, null);
                            }
                        }
                    }
                };
                for (SapphireActionHandler sapphireActionHandler : addAction.getActiveHandlers()) {
                    sapphireActionHandler.addListener(addActionHandlerListener);
                }
            }
            if (this.exposeDeleteAction) {
                final SapphireAction deleteAction = actions.getAction("Sapphire.Delete");
                final DeleteActionHandler deleteActionHandler = new DeleteActionHandler();
                ((SapphireActionHandler)deleteActionHandler).init(deleteAction, null);
                deleteAction.addHandler(deleteActionHandler);
                this.addOnDisposeOperation(new Runnable(){

                    public void run() {
                        deleteAction.removeHandler(deleteActionHandler);
                    }
                });
            }
            if (!property.hasAnnotation(FixedOrderList.class)) {
                final SapphireAction moveUpAction = actions.getAction("Sapphire.Move.Up");
                final MoveUpActionHandler moveUpActionHandler = new MoveUpActionHandler();
                ((SapphireActionHandler)moveUpActionHandler).init(moveUpAction, null);
                moveUpAction.addHandler(moveUpActionHandler);
                this.addOnDisposeOperation(new Runnable(){

                    public void run() {
                        moveUpAction.removeHandler(moveUpActionHandler);
                    }
                });
                final SapphireAction sapphireAction = actions.getAction("Sapphire.Move.Down");
                final MoveDownActionHandler moveDownActionHandler = new MoveDownActionHandler();
                ((SapphireActionHandler)moveDownActionHandler).init(sapphireAction, null);
                sapphireAction.addHandler(moveDownActionHandler);
                this.addOnDisposeOperation(new Runnable(){

                    public void run() {
                        sapphireAction.removeHandler(moveDownActionHandler);
                    }
                });
                SapphireActionSystemPart.Listener moveActionHandlerListener = new SapphireActionSystemPart.Listener(){

                    public void handleEvent(SapphireActionSystemPart.Event event) {
                        if (event.getType().equals("post-execute")) {
                            DefaultListPropertyEditorRenderer.this.refreshOperation.run();
                            IModelElement element = DefaultListPropertyEditorRenderer.this.getSelectedElement();
                            TableItem[] items = DefaultListPropertyEditorRenderer.this.table.getItems();
                            int i = 0;
                            while (i < items.length) {
                                if (items[i].getData() == element) {
                                    DefaultListPropertyEditorRenderer.this.table.setSelection(i);
                                    break;
                                }
                                ++i;
                            }
                        }
                    }
                };
                moveUpAction.addListener(moveActionHandlerListener);
                sapphireAction.addListener(moveActionHandlerListener);
            }
            ToolBar toolbar = new ToolBar((Composite)tableComposite, 0x800200);
            toolbar.setLayoutData((Object)GridLayoutUtil.gdvfill());
            toolBarActionsPresentation.setToolBar(toolbar);
            toolBarActionsPresentation.render();
            this.context.adapt((Control)toolbar);
            this.decorator.addEditorControl((Control)toolbar);
            Menu menu = new Menu((Control)this.table);
            this.table.setMenu(menu);
            menuActionsPresentation.setMenu(menu);
            menuActionsPresentation.render();
        }
        HyperlinkTable hyperlinkTable = new HyperlinkTable(this.table, actions);
        hyperlinkTable.setController(new HyperlinkTable.Controller(){

            public boolean isHyperlinkEnabled(TableItem item, int column) {
                SapphireActionHandler jumpHandler = this.getJumpHandler(item, column);
                if (jumpHandler != null) {
                    return jumpHandler.isEnabled();
                }
                return false;
            }

            public void handleHyperlinkEvent(TableItem item, int column) {
                SapphireActionHandler jumpHandler = this.getJumpHandler(item, column);
                if (jumpHandler != null) {
                    jumpHandler.execute(DefaultListPropertyEditorRenderer.this.context);
                }
            }

            private SapphireActionHandler getJumpHandler(TableItem item, int column) {
                IModelElement element = (IModelElement)item.getData();
                ValueProperty property = (ValueProperty)columnProperties.get(column);
                SapphirePropertyEditor propertyEditor = DefaultListPropertyEditorRenderer.this.getPart().getChildPropertyEditor(element, (ModelProperty)property);
                SapphireActionGroup actions = propertyEditor.getActions();
                return actions.getAction("Sapphire.Jump").getFirstActiveHandler();
            }
        });
        SwtUtil.suppressDashedTableEntryBorder(this.table);
        this.addControl((Control)this.table);
        return this.table;
    }

    public final PropertyEditorAssistDecorator getDecorator() {
        return this.decorator;
    }

    public final void setDecorator(PropertyEditorAssistDecorator decorator) {
        this.decorator = decorator;
    }

    public final boolean isAddActionDesired() {
        return this.exposeAddAction;
    }

    public final void setAddActionDesired(boolean exposeAddAction) {
        this.exposeAddAction = exposeAddAction;
    }

    public final boolean isDeleteActionDesired() {
        return this.exposeDeleteAction;
    }

    public final void setDeleteActionDesired(boolean exposeDeleteAction) {
        this.exposeDeleteAction = exposeDeleteAction;
    }

    public final IModelElement getSelectedElement() {
        IStructuredSelection sel = (IStructuredSelection)this.tableViewer.getSelection();
        if (sel == null) {
            return null;
        }
        return (IModelElement)sel.getFirstElement();
    }

    public final List<IModelElement> getSelectedElements() {
        IStructuredSelection sel = (IStructuredSelection)this.tableViewer.getSelection();
        ArrayList<IModelElement> elements = new ArrayList<IModelElement>();
        if (sel != null) {
            Iterator itr = sel.iterator();
            while (itr.hasNext()) {
                elements.add((IModelElement)itr.next());
            }
        }
        return elements;
    }

    public final void setSelection(List<IModelElement> selection) {
        StructuredSelection sel = new StructuredSelection(selection);
        this.tableViewer.setSelection((ISelection)sel);
    }

    public final void setFocusOnTable() {
        this.table.setFocus();
    }

    @Override
    protected void handlePropertyChangedEvent() {
        super.handlePropertyChangedEvent();
        this.refreshOperation.run();
    }

    @Override
    protected void handleListElementChangedEvent(final ModelPropertyChangeEvent event) {
        super.handleListElementChangedEvent(event);
        this.table.getDisplay().asyncExec(new Runnable(){

            public void run() {
                DefaultListPropertyEditorRenderer.this.tableViewer.update((Object)event.getModelElement(), null);
                DefaultListPropertyEditorRenderer.this.binding.updateTargetAttributes();
            }
        });
    }

    protected void handleTableFocusGainedEvent() {
        if (this.tableViewer.getSelection().isEmpty() && this.table.getItemCount() > 0) {
            IModelElement firstItem = (IModelElement)this.table.getItem(0).getData();
            this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)firstItem));
        }
    }

    private void handleTableTraverseEvent(TraverseEvent event) {
        if (event.detail == 4) {
            event.doit = false;
            IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
            if (selection.size() == 1) {
                IModelElement element = (IModelElement)selection.getFirstElement();
                int firstEditableColumn = -1;
                int i = 0;
                int n = this.getColumnCount();
                while (i < n) {
                    ColumnHandler handler = this.getColumnHandler(i);
                    if (handler.getEditingSupport().canEdit(element)) {
                        firstEditableColumn = i;
                        break;
                    }
                    ++i;
                }
                if (firstEditableColumn != -1) {
                    this.tableViewer.editElement((Object)element, firstEditableColumn);
                }
            }
        }
    }

    @Override
    protected void handleFocusReceivedEvent() {
        this.table.setFocus();
    }

    private ColumnHandler createColumnHandler(List<ColumnHandler> allColumnHandlers, ValueProperty property, boolean showImages) {
        ColumnHandler columnHandler = property.isOfType(Boolean.class) ? new BooleanPropertyColumnHandler(this.context, this.tableViewer, this.selectionProvider, this.getPart(), allColumnHandlers, property, showImages) : (property.isOfType(Enum.class) ? new EnumPropertyColumnHandler(this.context, this.tableViewer, this.selectionProvider, this.getPart(), allColumnHandlers, property, showImages) : new ColumnHandler(this.context, this.tableViewer, this.selectionProvider, this.getPart(), allColumnHandlers, property, showImages));
        allColumnHandlers.add(columnHandler);
        return columnHandler;
    }

    private int getColumnCount() {
        return this.table.getColumnCount();
    }

    private ColumnHandler getColumnHandler(int column) {
        return this.columnHandlers.get(column);
    }

    private abstract class AbstractActionHandler
    extends SapphireActionHandler {
        private ModelPropertyListener listPropertyListener;

        private AbstractActionHandler() {
        }

        public void init(SapphireAction action, ISapphireActionHandlerDef def) {
            super.init(action, def);
            this.listPropertyListener = new ModelPropertyListener(){

                public void handlePropertyChangedEvent(ModelPropertyChangeEvent event) {
                    AbstractActionHandler.this.refreshEnablement();
                }
            };
            this.getModelElement().addListener(this.listPropertyListener, DefaultListPropertyEditorRenderer.this.getProperty().getName());
        }

        public final void refreshEnablement() {
            this.setEnabled(this.computeEnablementState());
        }

        protected boolean computeEnablementState() {
            return this.getModelElement().isPropertyEnabled((ModelProperty)DefaultListPropertyEditorRenderer.this.getProperty());
        }

        public void dispose() {
            super.dispose();
            this.getModelElement().removeListener(this.listPropertyListener, DefaultListPropertyEditorRenderer.this.getProperty().getName());
        }
    }

    private static abstract class AbstractColumnEditingSupport
    extends EditingSupport {
        protected final ColumnHandler columnHandler;

        public AbstractColumnEditingSupport(ColumnHandler columnHandler) {
            super((ColumnViewer)columnHandler.getTableViewer());
            this.columnHandler = columnHandler;
        }

        public boolean canEdit(Object element) {
            ValueProperty property = this.columnHandler.getProperty();
            return !property.isReadOnly() && ((IModelElement)element).isPropertyEnabled((ModelProperty)property);
        }

        public abstract CellEditor getCellEditor(Object var1);

        public abstract Object getValue(Object var1);

        public abstract void setValue(Object var1, Object var2);
    }

    private final class AddActionHandler
    extends AbstractActionHandler {
        private final ModelElementType type;

        public AddActionHandler(ModelElementType type) {
            this.type = type;
        }

        public void init(SapphireAction action, ISapphireActionHandlerDef def) {
            super.init(action, def);
            ImageDescriptor typeSpecificAddImage = this.getPart().getImageCache().getImageDescriptor(this.type);
            if (typeSpecificAddImage != null) {
                this.addImage(typeSpecificAddImage);
            }
            this.setLabel(this.type.getLabel(false, CapitalizationType.TITLE_STYLE, false));
        }

        protected Object run(SapphireRenderingContext context) {
            return DefaultListPropertyEditorRenderer.this.getList().addNewElement(this.type);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BooleanPropertyColumnHandler
    extends ColumnHandler {
        private static final int CHECKBOX_IMAGE_WIDTH = 16;
        private static final int CHECKBOX_IMAGE_HEIGHT = 16;

        public BooleanPropertyColumnHandler(SapphireRenderingContext context, TableViewer tableViewer, SelectionProvider selectionProvider, SapphirePropertyEditor listPropertyEditor, List<ColumnHandler> allColumnHandlers, ValueProperty property, boolean showElementImage) {
            super(context, tableViewer, selectionProvider, listPropertyEditor, allColumnHandlers, property, showElementImage);
        }

        @Override
        protected CellLabelProvider createLabelProvider() {
            return new OwnerDrawLabelProvider(){

                protected void erase(Event event, Object element) {
                }

                protected void measure(Event event, Object element) {
                }

                protected void paint(Event event, Object object) {
                    TableItem item = (TableItem)event.item;
                    IModelElement element = (IModelElement)item.getData();
                    if (element.isPropertyEnabled((ModelProperty)BooleanPropertyColumnHandler.this.getProperty())) {
                        boolean value = BooleanPropertyColumnHandler.this.getPropertyValueAsBoolean(element);
                        org.eclipse.swt.graphics.Image image = BooleanPropertyColumnHandler.this.getImageCache().getImage(value ? SapphireImageCache.OBJECT_CHECK_ON : SapphireImageCache.OBJECT_CHECK_OFF);
                        Rectangle cellBounds = item.getBounds(event.index);
                        Rectangle imageBounds = image.getBounds();
                        int x = event.x + (cellBounds.width - imageBounds.width) / 2;
                        int y = event.y + (cellBounds.height - imageBounds.height) / 2;
                        event.gc.drawImage(image, x, y);
                    }
                }
            };
        }

        @Override
        protected AbstractColumnEditingSupport createEditingSupport() {
            return new AbstractColumnEditingSupport(this){
                private CheckboxCellEditor cellEditor;

                public CellEditor getCellEditor(Object element) {
                    if (this.cellEditor == null) {
                        this.cellEditor = new CheckboxCellEditor((Composite)BooleanPropertyColumnHandler.this.getTable());
                    }
                    return this.cellEditor;
                }

                public Object getValue(Object element) {
                    Value<?> value = BooleanPropertyColumnHandler.this.getPropertyValue((IModelElement)element);
                    Boolean val = (Boolean)value.getContent();
                    return val != null ? val : Boolean.FALSE;
                }

                public void setValue(Object element, Object value) {
                    String str = String.valueOf((Boolean)value);
                    BooleanPropertyColumnHandler.this.setPropertyValue((IModelElement)element, str);
                }
            };
        }

        @Override
        public boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
            if (event.eventType == 2) {
                Rectangle cellBounds = ((ViewerCell)event.getSource()).getBounds();
                Rectangle checkBoxBounds = new Rectangle(cellBounds.x + (cellBounds.width - 16) / 2, cellBounds.y + (cellBounds.height - 16) / 2, 16, 16);
                MouseEvent evt = (MouseEvent)event.sourceEvent;
                return checkBoxBounds.contains(evt.x, evt.y);
            }
            return false;
        }

        @Override
        public int comparePropertyValues(IModelElement x, IModelElement y) {
            boolean b;
            boolean a = this.getPropertyValueAsBoolean(x);
            if (a == (b = this.getPropertyValueAsBoolean(y))) {
                return 0;
            }
            if (a) {
                return -1;
            }
            return 1;
        }

        private boolean getPropertyValueAsBoolean(IModelElement element) {
            Value<?> value = this.getPropertyValue(element);
            Boolean val = (Boolean)value.getContent();
            return val != null && val != false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ColumnHandler {
        protected final SapphireRenderingContext context;
        protected final Table table;
        protected final TableViewer tableViewer;
        protected final SelectionProvider selectionProvider;
        protected final SapphirePropertyEditor listPropertyEditor;
        protected final List<ColumnHandler> allColumnHandlers;
        protected final ValueProperty property;
        protected final boolean showElementImage;
        protected final Collator collator;
        private CellLabelProvider labelProvider;
        private AbstractColumnEditingSupport editingSupport;

        public ColumnHandler(SapphireRenderingContext context, TableViewer tableViewer, SelectionProvider selectionProvider, SapphirePropertyEditor listPropertyEditor, List<ColumnHandler> allColumnHandlers, ValueProperty property, boolean showElementImage) {
            this.context = context;
            this.table = tableViewer.getTable();
            this.tableViewer = tableViewer;
            this.selectionProvider = selectionProvider;
            this.listPropertyEditor = listPropertyEditor;
            this.allColumnHandlers = allColumnHandlers;
            this.property = property;
            this.showElementImage = showElementImage;
            this.collator = Collator.getInstance();
        }

        public final SapphireRenderingContext getContext() {
            return this.context;
        }

        public final Table getTable() {
            return this.table;
        }

        public final TableViewer getTableViewer() {
            return this.tableViewer;
        }

        public final SelectionProvider getSelectionProvider() {
            return this.selectionProvider;
        }

        public final SapphirePropertyEditor getListPropertyEditor() {
            return this.listPropertyEditor;
        }

        public final SapphireImageCache getImageCache() {
            return this.listPropertyEditor.getImageCache();
        }

        public final boolean isElementImageDesired() {
            return this.showElementImage;
        }

        public final ValueProperty getProperty() {
            return this.property;
        }

        public final Value<?> getPropertyValue(IModelElement element) {
            return element.read(this.property);
        }

        public final void setPropertyValue(IModelElement element, String value) {
            element.write(this.property, (Object)value);
        }

        public final CellLabelProvider getLabelProvider() {
            if (this.labelProvider == null) {
                this.labelProvider = this.createLabelProvider();
            }
            return this.labelProvider;
        }

        protected CellLabelProvider createLabelProvider() {
            return new DefaultColumnLabelProvider(this);
        }

        public final AbstractColumnEditingSupport getEditingSupport() {
            if (this.editingSupport == null && !this.property.isReadOnly()) {
                this.editingSupport = this.createEditingSupport();
            }
            return this.editingSupport;
        }

        protected AbstractColumnEditingSupport createEditingSupport() {
            return new AbstractColumnEditingSupport(this){
                private SapphireTextCellEditor cellEditor;

                public CellEditor getCellEditor(Object obj) {
                    if (this.cellEditor != null) {
                        this.cellEditor.dispose();
                    }
                    IModelElement element = (IModelElement)obj;
                    ValueProperty property = ColumnHandler.this.property;
                    SapphirePropertyEditor propertyEditor = ColumnHandler.this.getListPropertyEditor().getChildPropertyEditor(element, (ModelProperty)property);
                    SapphireActionGroup actions = propertyEditor.getActions();
                    int style = ColumnHandler.this.getTable().getLinesVisible() ? 0 : 2048;
                    this.cellEditor = new SapphireTextCellEditor(ColumnHandler.this.getContext(), (StructuredViewer)ColumnHandler.this.getTableViewer(), ColumnHandler.this.getSelectionProvider(), element, ColumnHandler.this.getProperty(), actions, style);
                    if (ColumnHandler.this.isElementImageDesired()) {
                        this.cellEditor.setHorizonalIndent(3);
                    }
                    return this.cellEditor;
                }

                public Object getValue(Object element) {
                    return ColumnHandler.this.getPropertyValue((IModelElement)element);
                }

                public void setValue(Object element, Object value) {
                    ColumnHandler.this.setPropertyValue((IModelElement)element, (String)value);
                }
            };
        }

        public boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
            return event.eventType == 3 || event.eventType == 4 || event.eventType == 5;
        }

        public int comparePropertyValues(IModelElement x, IModelElement y) {
            boolean bEmpty;
            String a = this.getPropertyValue(x).getText();
            String b = this.getPropertyValue(y).getText();
            boolean aEmpty = a == null || a.trim().length() == 0;
            boolean bl = bEmpty = b == null || b.trim().length() == 0;
            if (aEmpty && bEmpty) {
                return 0;
            }
            if (aEmpty) {
                return 1;
            }
            if (bEmpty) {
                return -1;
            }
            return this.collator.compare(a, b);
        }

        public boolean isEmptyTextLabelDesired(IModelElement element) {
            if (this.allColumnHandlers.get(0) == this) {
                for (ColumnHandler handler : this.allColumnHandlers) {
                    if (!(handler instanceof BooleanPropertyColumnHandler)) continue;
                    return false;
                }
                for (ColumnHandler handler : this.allColumnHandlers) {
                    if (handler.getPropertyValue(element).getText() == null) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultColumnLabelProvider
    extends ColumnLabelProvider {
        private final ColumnHandler columnHandler;

        public DefaultColumnLabelProvider(ColumnHandler columnHandler) {
            this.columnHandler = columnHandler;
        }

        public String getText(Object element) {
            String str = null;
            IModelElement modelElement = (IModelElement)element;
            if (modelElement.isPropertyEnabled((ModelProperty)this.columnHandler.getProperty())) {
                str = this.getTextInternal(this.columnHandler.getPropertyValue(modelElement));
            }
            if (str == null) {
                str = this.columnHandler.isEmptyTextLabelDesired(modelElement) ? Resources.emptyRowIndicator : "";
            }
            return str;
        }

        protected String getTextInternal(Value<?> value) {
            return value.getText();
        }

        public org.eclipse.swt.graphics.Image getImage(Object element) {
            if (this.columnHandler.isElementImageDesired()) {
                IModelElement modelElement = (IModelElement)element;
                SapphireImageCache imageCache = this.columnHandler.getListPropertyEditor().getImageCache();
                return imageCache.getImage(modelElement, modelElement.validate().getSeverity());
            }
            return null;
        }

        public Color getForeground(Object element) {
            Value value = ((IModelElement)element).read(this.columnHandler.getProperty());
            if (value.getText(false) == null) {
                return Display.getCurrent().getSystemColor(16);
            }
            return null;
        }
    }

    private final class DeleteActionHandler
    extends SelectionBasedActionHandler {
        private DeleteActionHandler() {
        }

        protected final Object run(SapphireRenderingContext context) {
            IStructuredContentProvider contentProvider = (IStructuredContentProvider)DefaultListPropertyEditorRenderer.this.tableViewer.getContentProvider();
            List<IModelElement> elementsToDelete = DefaultListPropertyEditorRenderer.this.getSelectedElements();
            IModelElement elementToSelectAfterDelete = null;
            boolean preferNextElement = true;
            Object[] objectArray = contentProvider.getElements(null);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                boolean toBeDeleted = false;
                for (IModelElement x : elementsToDelete) {
                    if (element != x) continue;
                    toBeDeleted = true;
                    preferNextElement = true;
                    break;
                }
                if (!toBeDeleted && preferNextElement) {
                    elementToSelectAfterDelete = (IModelElement)element;
                    preferNextElement = false;
                }
                ++n2;
            }
            ModelElementList<IModelElement> list = DefaultListPropertyEditorRenderer.this.getList();
            for (IModelElement element : elementsToDelete) {
                list.remove((Object)element);
            }
            DefaultListPropertyEditorRenderer.this.refreshOperation.run();
            if (elementToSelectAfterDelete != null) {
                DefaultListPropertyEditorRenderer.this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)elementToSelectAfterDelete));
            }
            return null;
        }

        protected boolean computeEnablementState() {
            return super.computeEnablementState() && !DefaultListPropertyEditorRenderer.this.getSelectedElements().isEmpty();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EnumPropertyColumnHandler
    extends ColumnHandler {
        private final EnumValueType annotatedEnumeration;
        private final Enum<?>[] enumValues;

        public EnumPropertyColumnHandler(SapphireRenderingContext context, TableViewer tableViewer, SelectionProvider selectionProvider, SapphirePropertyEditor listPropertyEditor, List<ColumnHandler> allColumnHandlers, ValueProperty property, boolean showElementImage) {
            super(context, tableViewer, selectionProvider, listPropertyEditor, allColumnHandlers, property, showElementImage);
            this.annotatedEnumeration = new EnumValueType(property.getTypeClass());
            this.enumValues = this.annotatedEnumeration.getItems();
        }

        @Override
        protected CellLabelProvider createLabelProvider() {
            return new DefaultColumnLabelProvider(this){

                @Override
                protected String getTextInternal(Value<?> value) {
                    Enum enumItem;
                    String str = null;
                    if (EnumPropertyColumnHandler.this.annotatedEnumeration != null && (enumItem = (Enum)value.getContent(true)) != null) {
                        str = EnumPropertyColumnHandler.this.annotatedEnumeration.getLabel(enumItem, false, CapitalizationType.FIRST_WORD_ONLY, false);
                    }
                    if (str == null) {
                        str = value.getText(true);
                    }
                    return str;
                }
            };
        }

        @Override
        protected AbstractColumnEditingSupport createEditingSupport() {
            return new AbstractColumnEditingSupport(this){
                private ReadOnlyComboBoxCellEditor cellEditor;
                private List<String> cellEditorItems;

                public CellEditor getCellEditor(Object element) {
                    if (this.cellEditor == null) {
                        this.cellEditor = new ReadOnlyComboBoxCellEditor((Composite)EnumPropertyColumnHandler.this.getTable(), new String[0], 12);
                        this.cellEditorItems = new ArrayList<String>();
                    }
                    EnumValueType annotatedEnumeration = EnumPropertyColumnHandler.this.annotatedEnumeration;
                    Enum[] enumValues = EnumPropertyColumnHandler.this.enumValues;
                    Value value = ((IModelElement)element).read(EnumPropertyColumnHandler.this.getProperty());
                    String stringValue = value.getText(false);
                    boolean needExtraEntry = false;
                    if (stringValue != null && value.getContent(false) == null) {
                        needExtraEntry = true;
                    }
                    String[] items = new String[enumValues.length + (needExtraEntry ? 1 : 0)];
                    this.cellEditorItems.clear();
                    IModelElement modelElement = (IModelElement)element;
                    int i = 0;
                    while (i < enumValues.length) {
                        Enum enumValue = enumValues[i];
                        String enumValueText = ((ValueSerializationService)modelElement.service((ModelProperty)EnumPropertyColumnHandler.this.getProperty(), ValueSerializationService.class)).encode((Object)enumValue);
                        this.cellEditorItems.add(enumValueText);
                        items[i] = annotatedEnumeration.getLabel(enumValue, false, CapitalizationType.FIRST_WORD_ONLY, false);
                        ++i;
                    }
                    if (needExtraEntry) {
                        items[items.length] = stringValue;
                    }
                    this.cellEditor.setItems(items);
                    return this.cellEditor;
                }

                public Object getValue(Object element) {
                    String str = EnumPropertyColumnHandler.this.getPropertyValue((IModelElement)element).getText(false);
                    str = str != null ? str : "";
                    int i = 0;
                    int n = this.cellEditorItems.size();
                    while (i < n) {
                        if (this.cellEditorItems.get(i).equals(str)) {
                            return i;
                        }
                        ++i;
                    }
                    return -1;
                }

                public void setValue(Object element, Object value) {
                    int index = (Integer)value;
                    String str = index == -1 ? null : this.cellEditorItems.get(index);
                    EnumPropertyColumnHandler.this.setPropertyValue((IModelElement)element, str);
                }
            };
        }
    }

    public static final class Factory
    extends PropertyEditorRendererFactory {
        public boolean isApplicableTo(SapphirePropertyEditor propertyEditorDefinition) {
            return propertyEditorDefinition.getProperty() instanceof ListProperty;
        }

        public PropertyEditorRenderer create(SapphireRenderingContext context, SapphirePropertyEditor part) {
            return new DefaultListPropertyEditorRenderer(context, part);
        }
    }

    private final class MoveDownActionHandler
    extends SelectionBasedActionHandler {
        private MoveDownActionHandler() {
        }

        protected boolean computeEnablementState() {
            if (!super.computeEnablementState() || DefaultListPropertyEditorRenderer.this.getSelectedElements().size() != 1 || DefaultListPropertyEditorRenderer.this.tableViewer.getComparator() != null) {
                return false;
            }
            IModelElement modelElement = DefaultListPropertyEditorRenderer.this.getSelectedElement();
            ModelElementList<IModelElement> list = DefaultListPropertyEditorRenderer.this.getList();
            return list.indexOf((Object)modelElement) < list.size() - 1;
        }

        protected final Object run(SapphireRenderingContext context) {
            DefaultListPropertyEditorRenderer.this.getList().moveDown(DefaultListPropertyEditorRenderer.this.getSelectedElement());
            return null;
        }
    }

    private final class MoveUpActionHandler
    extends SelectionBasedActionHandler {
        private MoveUpActionHandler() {
        }

        protected boolean computeEnablementState() {
            if (!super.computeEnablementState() || DefaultListPropertyEditorRenderer.this.getSelectedElements().size() != 1 || DefaultListPropertyEditorRenderer.this.tableViewer.getComparator() != null) {
                return false;
            }
            IModelElement modelElement = DefaultListPropertyEditorRenderer.this.getSelectedElement();
            return DefaultListPropertyEditorRenderer.this.getList().indexOf((Object)modelElement) > 0;
        }

        protected final Object run(SapphireRenderingContext context) {
            DefaultListPropertyEditorRenderer.this.getList().moveUp(DefaultListPropertyEditorRenderer.this.getSelectedElement());
            return null;
        }
    }

    private static final class Resources
    extends NLS {
        public static String emptyRowIndicator;

        static {
            Resources.initializeMessages((String)DefaultListPropertyEditorRenderer.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }

    private abstract class SelectionBasedActionHandler
    extends AbstractActionHandler {
        public SelectionBasedActionHandler() {
            DefaultListPropertyEditorRenderer.this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    SelectionBasedActionHandler.this.refreshEnablement();
                }
            });
        }
    }

    public static final class SelectionProvider
    implements ISelectionProvider {
        private final TableViewer tableViewer;
        private final Set<ISelectionChangedListener> listeners;
        private ISelection fakeSelection;

        public SelectionProvider(TableViewer tableViewer) {
            this.tableViewer = tableViewer;
            this.listeners = new CopyOnWriteArraySet<ISelectionChangedListener>();
            this.fakeSelection = null;
            this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    SelectionProvider.this.handleSelectionChangedEvent(SelectionProvider.this.getSelection());
                }
            });
        }

        public ISelection getSelection() {
            if (this.fakeSelection != null) {
                return this.fakeSelection;
            }
            return this.tableViewer.getSelection();
        }

        public void setSelection(ISelection selection) {
            throw new UnsupportedOperationException();
        }

        public void setFakeSelection(ISelection selection) {
            this.fakeSelection = selection;
            this.handleSelectionChangedEvent(this.getSelection());
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.listeners.add(listener);
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.listeners.remove(listener);
        }

        private void handleSelectionChangedEvent(ISelection selection) {
            SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
            for (ISelectionChangedListener listener : this.listeners) {
                listener.selectionChanged(event);
            }
        }
    }

    private static final class TableLabelProvider
    implements ITableLabelProvider,
    ITableColorProvider {
        private ColumnLabelProvider columnLabelProvider;

        public TableLabelProvider(ColumnLabelProvider columnLabelProvider) {
            this.columnLabelProvider = columnLabelProvider;
        }

        public String getColumnText(Object element, int columnIndex) {
            return this.columnLabelProvider.getText(element);
        }

        public org.eclipse.swt.graphics.Image getColumnImage(Object element, int columnIndex) {
            return this.columnLabelProvider.getImage(element);
        }

        public Color getForeground(Object element, int columnIndex) {
            return this.columnLabelProvider.getForeground(element);
        }

        public Color getBackground(Object element, int columnIndex) {
            return this.columnLabelProvider.getBackground(element);
        }

        public boolean isLabelProperty(Object element, String property) {
            return true;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }
    }

    private static final class TableSorter
    extends ViewerComparator {
        private final ColumnHandler columnHandler;
        private final int direction;

        public TableSorter(ColumnHandler columnHandler, int direction) {
            this.columnHandler = columnHandler;
            this.direction = direction;
        }

        public int compare(Viewer viewer, Object x, Object y) {
            int result = this.columnHandler.comparePropertyValues((IModelElement)x, (IModelElement)y);
            if (this.direction == 128) {
                result *= -1;
            }
            return result;
        }
    }
}

