/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.renderer.actions.internal;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.ui.SapphireJumpActionHandler;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.swt.widgets.Shell;

public final class JavaTypeJumpActionHandler
extends SapphireJumpActionHandler {
    public static final String ID = "Sapphire.Jump.Java.Type";

    public JavaTypeJumpActionHandler() {
        this.setId(ID);
    }

    protected void refreshEnablementState() {
        IModelElement element = this.getModelElement();
        String typeName = element.read(this.getProperty()).getText(true);
        if (typeName != null && JavaTypeJumpActionHandler.getType(typeName, (IProject)element.adapt(IProject.class)) != null) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }

    protected Object run(SapphireRenderingContext context) {
        IModelElement element = this.getModelElement();
        try {
            String typeName = element.read(this.getProperty()).getText(true);
            if (typeName != null) {
                IType type = JavaTypeJumpActionHandler.getType(typeName, (IProject)element.adapt(IProject.class));
                if (type != null) {
                    JavaUI.openInEditor((IJavaElement)type);
                } else {
                    String message = NLS.bind((String)Resources.couldNotFindTypeDialogMessage, (Object)typeName);
                    MessageDialog.openInformation((Shell)context.getShell(), (String)Resources.couldNotFindTypeDialogTitle, (String)message);
                }
            }
        }
        catch (CoreException e) {
            SapphireUiFrameworkPlugin.log(e);
        }
        return null;
    }

    private static IType getType(String fullyQualifiedType, IProject project) {
        assert (fullyQualifiedType != null) : "Fully qualified type should not be null.";
        if (fullyQualifiedType.trim().length() == 0 || fullyQualifiedType.startsWith(".") || fullyQualifiedType.endsWith(".")) {
            return null;
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject == null || !javaProject.exists()) {
            return null;
        }
        IType type = null;
        try {
            type = javaProject.findType(fullyQualifiedType);
            if (type != null && (!type.exists() || type.isAnonymous())) {
                type = null;
            }
        }
        catch (JavaModelException ce) {
            SapphireUiFrameworkPlugin.log(ce);
        }
        return type;
    }

    private static final class Resources
    extends NLS {
        public static String couldNotFindTypeDialogTitle;
        public static String couldNotFindTypeDialogMessage;

        static {
            Resources.initializeMessages((String)JavaTypeJumpActionHandler.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

