/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.renderer.actions.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphireActionHandlerFactory;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.def.ISapphireActionHandlerDef;
import org.eclipse.sapphire.ui.editor.views.masterdetails.MasterDetailsContentNode;
import org.eclipse.sapphire.ui.editor.views.masterdetails.MasterDetailsContentTree;
import org.eclipse.sapphire.ui.editor.views.masterdetails.MasterDetailsPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OutlineNodeAddActionHandlerFactory
extends SapphireActionHandlerFactory {
    public static final String ID_BASE = "Sapphire.Add.";

    @Override
    public List<SapphireActionHandler> create() {
        ArrayList<SapphireActionHandler> handlers = new ArrayList<SapphireActionHandler>();
        MasterDetailsContentNode node = (MasterDetailsContentNode)this.getPart();
        List<ListProperty> listProperties = node.getChildListProperties();
        for (ListProperty listProperty : listProperties) {
            for (ModelElementType memberType : listProperty.getAllPossibleTypes()) {
                AddActionHandler handler = new AddActionHandler(listProperty, memberType);
                handlers.add(handler);
            }
        }
        return handlers;
    }

    private static final class AddActionHandler
    extends SapphireActionHandler {
        private final ListProperty listProperty;
        private final ModelElementType type;
        private MasterDetailsContentTree contentTree;
        private MasterDetailsContentTree.Listener contentTreeListener;

        public AddActionHandler(ListProperty listProperty, ModelElementType type) {
            this.listProperty = listProperty;
            this.type = type;
            this.setId(OutlineNodeAddActionHandlerFactory.ID_BASE + type.getSimpleName());
            this.setLabel(type.getLabel(true, CapitalizationType.NO_CAPS, false));
        }

        public void init(SapphireAction action, ISapphireActionHandlerDef def) {
            super.init(action, def);
            ImageDescriptor typeSpecificAddImage = this.getPart().getImageCache().getImageDescriptor(this.type);
            if (typeSpecificAddImage != null) {
                this.addImage(typeSpecificAddImage);
            }
            this.contentTree = ((MasterDetailsContentNode)this.getPart()).getContentTree();
            this.contentTreeListener = new MasterDetailsContentTree.Listener(){

                public void handleFilterChange(String newFilterText) {
                    AddActionHandler.this.refreshEnabledState();
                }
            };
            this.contentTree.addListener(this.contentTreeListener);
            this.refreshEnabledState();
        }

        protected Object run(SapphireRenderingContext context) {
            MasterDetailsContentNode node = (MasterDetailsContentNode)this.getPart();
            IModelElement element = node.getLocalModelElement();
            ModelElementList list = element.read(this.listProperty);
            IModelElement newModelElement = list.addNewElement(this.type);
            node.getContentTree().notifyOfNodeStructureChange(node);
            for (MasterDetailsContentNode n : node.getChildNodes()) {
                if (n.getModelElement() != newModelElement) continue;
                n.select();
                this.getPart().getNearestPart(MasterDetailsPage.class).setFocusOnDetails();
                break;
            }
            return newModelElement;
        }

        private void refreshEnabledState() {
            this.setEnabled(this.contentTree != null && this.contentTree.getFilterText().length() == 0);
        }

        public void dispose() {
            super.dispose();
            if (this.contentTree != null) {
                this.contentTree.removeListener(this.contentTreeListener);
            }
        }
    }
}

