/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelParticle;
import org.eclipse.sapphire.modeling.TransientProperty;
import org.eclipse.sapphire.modeling.annotations.ModelPropertyValidator;
import org.eclipse.sapphire.modeling.util.internal.MiscUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Transient<T>
extends ModelParticle {
    private final TransientProperty property;
    private final T content;
    private IStatus valres;

    public Transient(IModelElement parent, TransientProperty property, T content) {
        super(parent, parent.resource());
        this.property = property;
        this.content = content;
        this.valres = null;
    }

    public void init() {
        this.initValidation();
    }

    private void initValidation() {
        if (this.valres == null) {
            ModelPropertyValidator<?> validator = this.property.getValidator();
            this.valres = validator == null ? Status.OK_STATUS : validator.validate(this);
        }
    }

    @Override
    public IModelElement parent() {
        return (IModelElement)super.parent();
    }

    public TransientProperty property() {
        return this.property;
    }

    public T content() {
        return this.content;
    }

    @Override
    public IStatus validate() {
        this.initValidation();
        return this.valres;
    }

    public boolean equals(Object val) {
        if (this == val) {
            return true;
        }
        if (val == null) {
            return false;
        }
        this.init();
        Transient value = (Transient)val;
        return this.parent() == value.parent() && this.property == value.property && MiscUtil.equal(this.content, value.content) && Transient.equal(this.valres, value.valres);
    }

    public int hashCode() {
        int hashCode = this.parent().hashCode();
        hashCode ^= this.property.hashCode();
        return hashCode ^= this.content == null ? 1 : this.content.hashCode();
    }

    public String toString() {
        return this.content == null ? "<null>" : this.content.toString();
    }

    private static boolean equal(IStatus x, IStatus y) {
        return x.getMessage().equals(y.getMessage()) && x.getSeverity() == y.getSeverity();
    }
}

