/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.annotations.processor.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sapphire.modeling.annotations.processor.util.BaseModel;
import org.eclipse.sapphire.modeling.annotations.processor.util.IndentingPrintWriter;

public final class Body
extends BaseModel {
    private static final BaseModel EMPTY_LINE_SEGMENT = new StringSegment("");
    private static final BaseModel BLOCK_OPEN_SEGMENT = new BaseModel(){

        public void write(IndentingPrintWriter pw) {
            pw.print("{");
            pw.println();
            pw.increaseIndent();
        }
    };
    private static final BaseModel BLOCK_CLOSE_SEGMENT = new BaseModel(){

        public void write(IndentingPrintWriter pw) {
            pw.decreaseIndent();
            pw.print("}");
            pw.println();
        }
    };
    private static final BaseModel BLOCK_CLOSE_SEGMENT_WITH_SEMICOLON = new BaseModel(){

        public void write(IndentingPrintWriter pw) {
            pw.decreaseIndent();
            pw.print("};");
            pw.println();
        }
    };
    private static final BaseModel METHOD_PARAMS_BLOCK_OPEN_SEGMENT = new BaseModel(){

        public void write(IndentingPrintWriter pw) {
            pw.print("(");
            pw.println();
            pw.increaseIndent();
        }
    };
    private static final BaseModel METHOD_PARAMS_BLOCK_CLOSE_SEGMENT = new BaseModel(){

        public void write(IndentingPrintWriter pw) {
            pw.decreaseIndent();
            pw.print(");");
            pw.println();
        }
    };
    private List<BaseModel> segments = new ArrayList<BaseModel>();

    public void append(String content) {
        this.segments.add(new StringSegment(content));
    }

    public void append(String content, String ... args) {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        int n = content.length();
        while (i < n) {
            char ch = content.charAt(i);
            if (ch == '#' && i + 1 < n) {
                ch = content.charAt(++i);
                buf.append(args[Integer.parseInt(String.valueOf(ch)) - 1]);
            } else {
                buf.append(ch);
            }
            ++i;
        }
        this.append(buf.toString());
    }

    public void appendEmptyLine() {
        this.segments.add(EMPTY_LINE_SEGMENT);
    }

    public void openBlock() {
        this.segments.add(BLOCK_OPEN_SEGMENT);
    }

    public void closeBlock() {
        this.closeBlock(false);
    }

    public void closeBlock(boolean suffixWithSemicolon) {
        this.segments.add(suffixWithSemicolon ? BLOCK_CLOSE_SEGMENT_WITH_SEMICOLON : BLOCK_CLOSE_SEGMENT);
    }

    public void openMethodParamsBlock() {
        this.segments.add(METHOD_PARAMS_BLOCK_OPEN_SEGMENT);
    }

    public void closeMethodParamsBlock() {
        this.segments.add(METHOD_PARAMS_BLOCK_CLOSE_SEGMENT);
    }

    public void write(IndentingPrintWriter pw) {
        for (BaseModel segment : this.segments) {
            segment.write(pw);
        }
    }

    private static final class StringSegment
    extends BaseModel {
        private final String str;

        public StringSegment(String str) {
            this.str = str;
        }

        public void write(IndentingPrintWriter pw) {
            String[] stringArray = this.str.replace("\r", "").split("\n");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                pw.print(line);
                pw.println();
                ++n2;
            }
        }
    }
}

