/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.xml;

import org.eclipse.sapphire.modeling.ElementBindingImpl;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.xml.VirtualChildXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlPath;
import org.eclipse.sapphire.modeling.xml.XmlResource;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlElementBinding;

public final class StandardImpliedXmlElementBindingImpl
extends ElementBindingImpl {
    private XmlPath path;
    private Resource resource;

    public void init(IModelElement element, ModelProperty property, String[] params) {
        super.init(element, property, params);
        if (property.getAllPossibleTypes().size() > 1) {
            throw new IllegalStateException();
        }
        String pathString = "";
        XmlElementBinding xmlElementBindingAnnotation = property.getAnnotation(XmlElementBinding.class);
        if (xmlElementBindingAnnotation != null) {
            if (xmlElementBindingAnnotation.mappings().length > 0) {
                throw new IllegalStateException();
            }
            pathString = xmlElementBindingAnnotation.path();
        } else {
            XmlBinding xmlBindingAnnotation = property.getAnnotation(XmlBinding.class);
            if (xmlBindingAnnotation != null) {
                pathString = xmlBindingAnnotation.path();
            }
        }
        this.path = new XmlPath(pathString, ((XmlResource)element.resource()).getXmlNamespaceResolver());
    }

    public ModelElementType type(Resource resource) {
        return this.property().getType();
    }

    public Resource read() {
        if (this.resource == null) {
            XmlResource parentXmlResource = (XmlResource)this.element().resource();
            this.resource = new VirtualChildXmlResource(parentXmlResource, this.path);
        }
        return this.resource;
    }
}

