/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.xml;

import org.eclipse.sapphire.modeling.BindingImpl;
import org.eclipse.sapphire.modeling.ElementProperty;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ImpliedElementProperty;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.internal.SapphireModelingFrameworkPlugin;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.StandardImpliedXmlElementBindingImpl;
import org.eclipse.sapphire.modeling.xml.StandardXmlElementBindingImpl;
import org.eclipse.sapphire.modeling.xml.StandardXmlListBindingImpl;
import org.eclipse.sapphire.modeling.xml.StandardXmlNamespaceResolver;
import org.eclipse.sapphire.modeling.xml.StandardXmlValueBindingImpl;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlNamespaceResolver;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlElementBinding;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlListBinding;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlValueBinding;

public abstract class XmlResource
extends Resource {
    private XmlNamespaceResolver xmlNamespaceResolver;

    public XmlResource(XmlResource parent) {
        super(parent);
    }

    public void init(IModelElement modelElement) {
        super.init(modelElement);
        this.xmlNamespaceResolver = new StandardXmlNamespaceResolver(modelElement.getModelElementType());
    }

    public XmlResource parent() {
        return (XmlResource)super.parent();
    }

    public RootXmlResource root() {
        return (RootXmlResource)super.root();
    }

    public final XmlNamespaceResolver getXmlNamespaceResolver() {
        return this.xmlNamespaceResolver;
    }

    public abstract XmlElement getXmlElement(boolean var1);

    public final XmlElement getXmlElement() {
        return this.getXmlElement(false);
    }

    protected BindingImpl createBinding(ModelProperty property) {
        BindingImpl binding = null;
        String[] params = null;
        if (property instanceof ValueProperty) {
            CustomXmlValueBinding customBindingAnnotation = property.getAnnotation(CustomXmlValueBinding.class);
            if (customBindingAnnotation != null) {
                try {
                    binding = customBindingAnnotation.impl().newInstance();
                    params = customBindingAnnotation.params();
                }
                catch (Exception e) {
                    SapphireModelingFrameworkPlugin.log(e);
                    binding = null;
                }
            } else {
                binding = new StandardXmlValueBindingImpl();
            }
        } else if (property instanceof ElementProperty) {
            CustomXmlElementBinding customBindingAnnotation = property.getAnnotation(CustomXmlElementBinding.class);
            if (customBindingAnnotation != null) {
                try {
                    binding = customBindingAnnotation.impl().newInstance();
                    params = customBindingAnnotation.params();
                }
                catch (Exception e) {
                    SapphireModelingFrameworkPlugin.log(e);
                    binding = null;
                }
            } else {
                binding = property instanceof ImpliedElementProperty ? new StandardImpliedXmlElementBindingImpl() : new StandardXmlElementBindingImpl();
            }
        } else if (property instanceof ListProperty) {
            CustomXmlListBinding customBindingAnnotation = property.getAnnotation(CustomXmlListBinding.class);
            if (customBindingAnnotation != null) {
                try {
                    binding = customBindingAnnotation.impl().newInstance();
                    params = customBindingAnnotation.params();
                }
                catch (Exception e) {
                    SapphireModelingFrameworkPlugin.log(e);
                    binding = null;
                }
            } else {
                binding = new StandardXmlListBindingImpl();
            }
        }
        if (binding != null) {
            ((BindingImpl)binding).init(this.element(), property, params);
        }
        return binding;
    }
}

