/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.calendar.ui;

import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelPropertyChangeEvent;
import org.eclipse.sapphire.modeling.ModelPropertyListener;
import org.eclipse.sapphire.samples.calendar.integrated.IAttendee;
import org.eclipse.sapphire.samples.calendar.ui.CalendarEditor;
import org.eclipse.sapphire.samples.calendar.ui.ContactDetailsJumpHandler;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.def.ISapphireActionHandlerDef;

public final class ShowContactDetailsActionHandler
extends SapphireActionHandler {
    private ModelPropertyListener listener;

    public void init(SapphireAction action, ISapphireActionHandlerDef def) {
        super.init(action, def);
        this.listener = new ModelPropertyListener(){

            public void handlePropertyChangedEvent(ModelPropertyChangeEvent event) {
                ShowContactDetailsActionHandler.this.refreshEnablementState();
            }
        };
        this.getModelElement().addListener(this.listener, IAttendee.PROP_IN_CONTACTS_DATABASE.getName());
        this.refreshEnablementState();
    }

    protected void refreshEnablementState() {
        this.setEnabled((Boolean)((IAttendee)this.getModelElement()).isInContactsDatabase().getContent());
    }

    protected Object run(SapphireRenderingContext context) {
        ISapphirePart part = this.getPart();
        CalendarEditor editor = (CalendarEditor)((Object)part.getNearestPart(CalendarEditor.class));
        IModelElement modelElement = part.getModelElement();
        ContactDetailsJumpHandler.jump(editor, modelElement);
        return null;
    }

    public void dispose() {
        super.dispose();
        this.getModelElement().removeListener(this.listener, IAttendee.PROP_IN_CONTACTS_DATABASE.getName());
    }
}

