/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.SapphireActionGroup;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphireActionHandlerFilter;
import org.eclipse.sapphire.ui.SapphireActionLocationHint;
import org.eclipse.sapphire.ui.SapphireActionSystemPart;
import org.eclipse.sapphire.ui.def.ISapphireActionDef;
import org.eclipse.sapphire.ui.def.SapphireActionType;
import org.eclipse.sapphire.ui.def.SapphireKeySequence;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.sapphire.ui.util.TopologicalSorter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SapphireAction
extends SapphireActionSystemPart {
    public static final String EVENT_TYPE_CHANGED = "type";
    public static final String EVENT_GROUP_CHANGED = "group";
    public static final String EVENT_KEY_BINDING_CHANGED = "key-binding";
    public static final String EVENT_HANDLERS_CHANGED = "handlers";
    public static final String EVENT_FILTERS_CHANGED = "filters";
    private SapphireActionGroup parent;
    private SapphireActionType type;
    private String group;
    private SapphireKeySequence keyBinding;
    private final List<SapphireActionHandler> handlers = new CopyOnWriteArrayList<SapphireActionHandler>();
    private final List<SapphireActionHandlerFilter> filters = new CopyOnWriteArrayList<SapphireActionHandlerFilter>();
    private final SapphireActionSystemPart.Listener handlerListener = new SapphireActionSystemPart.Listener(){

        public void handleEvent(SapphireActionSystemPart.Event event) {
            String type = event.getType();
            if (type.equals("enablement")) {
                SapphireAction.this.refreshEnablementState();
            } else if (type.equals("checked")) {
                SapphireAction.this.refreshCheckedState();
            }
        }
    };

    public SapphireAction() {
        this.addListener(new SapphireActionSystemPart.Listener(){

            public void handleEvent(SapphireActionSystemPart.Event event) {
                String type = event.getType();
                if (type.equals(SapphireAction.EVENT_HANDLERS_CHANGED) || type.equals(SapphireAction.EVENT_FILTERS_CHANGED)) {
                    SapphireAction.this.refreshEnablementState();
                    SapphireAction.this.refreshCheckedState();
                }
            }
        });
    }

    public void init(SapphireActionGroup parent, ISapphireActionDef def) {
        super.init(def);
        this.parent = parent;
        if (def != null) {
            this.type = (SapphireActionType)((Object)def.getType().getContent());
            this.group = (String)def.getGroup().getContent();
            this.keyBinding = (SapphireKeySequence)def.getKeyBinding().getContent();
        }
        this.setEnabled(false);
    }

    public SapphireActionGroup getActionSet() {
        return this.parent;
    }

    public final ISapphirePart getPart() {
        return this.parent.getPart();
    }

    public String getContext() {
        return this.parent.getContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SapphireActionType getType() {
        SapphireAction sapphireAction = this;
        synchronized (sapphireAction) {
            return this.type;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setType(SapphireActionType type) {
        SapphireAction sapphireAction = this;
        synchronized (sapphireAction) {
            this.type = type;
        }
        this.notifyListeners(new SapphireActionSystemPart.Event(EVENT_TYPE_CHANGED));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getGroup() {
        SapphireAction sapphireAction = this;
        synchronized (sapphireAction) {
            return this.group;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGroup(String group) {
        SapphireAction sapphireAction = this;
        synchronized (sapphireAction) {
            this.group = group;
        }
        this.notifyListeners(new SapphireActionSystemPart.Event(EVENT_GROUP_CHANGED));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SapphireKeySequence getKeyBinding() {
        SapphireAction sapphireAction = this;
        synchronized (sapphireAction) {
            return this.keyBinding;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKeyBinding(SapphireKeySequence keyBinding) {
        SapphireAction sapphireAction = this;
        synchronized (sapphireAction) {
            this.keyBinding = keyBinding;
        }
        this.notifyListeners(new SapphireActionSystemPart.Event(EVENT_KEY_BINDING_CHANGED));
    }

    public void addHandler(SapphireActionHandler handler) {
        handler.addListener(this.handlerListener);
        this.handlers.add(handler);
        this.notifyListeners(new SapphireActionSystemPart.Event(EVENT_HANDLERS_CHANGED));
    }

    public void removeHandler(SapphireActionHandler handler) {
        handler.removeListener(this.handlerListener);
        this.handlers.remove(handler);
        this.notifyListeners(new SapphireActionSystemPart.Event(EVENT_HANDLERS_CHANGED));
    }

    public List<SapphireActionHandler> getActiveHandlers() {
        TopologicalSorter<SapphireActionHandler> sorter = new TopologicalSorter<SapphireActionHandler>();
        for (SapphireActionHandler handler : this.handlers) {
            boolean ok = true;
            ArrayList<SapphireActionHandlerFilter> failedFilters = null;
            for (SapphireActionHandlerFilter filter : this.filters) {
                try {
                    ok = filter.check(handler);
                }
                catch (Exception e) {
                    SapphireUiFrameworkPlugin.log(e);
                    if (failedFilters == null) {
                        failedFilters = new ArrayList<SapphireActionHandlerFilter>();
                    }
                    failedFilters.add(filter);
                }
                if (!ok) break;
            }
            if (failedFilters != null) {
                this.filters.removeAll(failedFilters);
            }
            if (!ok) continue;
            TopologicalSorter.Entity handlerEntity = sorter.entity(handler.getId(), handler);
            for (SapphireActionLocationHint locationHint : handler.getLocationHints()) {
                handlerEntity.constraint(locationHint.toString());
            }
        }
        return Collections.unmodifiableList(sorter.sort());
    }

    public SapphireActionHandler getFirstActiveHandler() {
        List<SapphireActionHandler> handlers = this.getActiveHandlers();
        return handlers.isEmpty() ? null : handlers.get(0);
    }

    public boolean hasActiveHandlers() {
        return this.getFirstActiveHandler() != null;
    }

    public void addFilter(SapphireActionHandlerFilter filter) {
        this.filters.add(filter);
        this.notifyListeners(new SapphireActionSystemPart.Event(EVENT_FILTERS_CHANGED));
    }

    public void removeFilter(SapphireActionHandlerFilter filter) {
        this.filters.remove(filter);
        this.notifyListeners(new SapphireActionSystemPart.Event(EVENT_FILTERS_CHANGED));
    }

    private void refreshEnablementState() {
        boolean enabled = false;
        for (SapphireActionHandler handler : this.getActiveHandlers()) {
            if (!handler.isEnabled()) continue;
            enabled = true;
            break;
        }
        this.setEnabled(enabled);
    }

    private void refreshCheckedState() {
        boolean checked = false;
        SapphireActionHandler handler = this.getFirstActiveHandler();
        if (handler != null) {
            checked = handler.isChecked();
        }
        this.setChecked(checked);
    }

    public void dispose() {
        for (SapphireActionHandler handler : this.handlers) {
            try {
                handler.dispose();
            }
            catch (Exception e) {
                SapphireUiFrameworkPlugin.log(e);
            }
        }
    }
}

