/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.assist.internal;

import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.ui.SapphireEditorFormPage;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContext;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContribution;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContributor;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistSection;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.texteditor.ITextEditor;

public final class ShowInSourceActionAssistContributor
extends PropertyEditorAssistContributor {
    public ShowInSourceActionAssistContributor() {
        this.setId("System.ShowInSourceActionContributor");
        this.setPriority(320);
    }

    public void contribute(PropertyEditorAssistContext context) {
        ModelElementList list;
        final SapphireEditorFormPage page = context.getPropertyEditor().getNearestPart(SapphireEditorFormPage.class);
        if (page == null) {
            return;
        }
        ITextEditor sourceView = page.getSourceView();
        if (sourceView == null) {
            return;
        }
        final IModelElement element = context.getModelElement();
        final ModelProperty prop = context.getProperty();
        boolean contribute = false;
        if (prop instanceof ValueProperty) {
            Value val = element.read((ValueProperty)prop);
            if (val.getText(false) != null) {
                contribute = true;
            }
        } else if (prop instanceof ListProperty && (list = element.read((ListProperty)prop)).size() > 0) {
            contribute = true;
        }
        if (!contribute) {
            return;
        }
        PropertyEditorAssistContribution contribution = new PropertyEditorAssistContribution();
        contribution.setText("<p><a href=\"action\" nowrap=\"true\">" + ShowInSourceActionAssistContributor.escapeForXml(Resources.action) + "</a></p>");
        contribution.setHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent event) {
                page.showInSourceView(element, prop);
            }
        });
        PropertyEditorAssistSection section = context.getSection("actions");
        section.addContribution(contribution);
    }

    private static final class Resources
    extends NLS {
        public static String action;

        static {
            Resources.initializeMessages((String)ShowInSourceActionAssistContributor.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

