/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.def.internal;

import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ReferenceValue;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.ui.def.ISapphirePartListenerDef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SapphirePartListenerDef
extends ModelElement
implements ISapphirePartListenerDef {
    private ReferenceValue<Class<?>> listenerClass;

    public SapphirePartListenerDef(IModelParticle parent, ModelProperty parentProperty, Resource resource) {
        super(TYPE, parent, parentProperty, resource);
    }

    public SapphirePartListenerDef(Resource resource) {
        super(TYPE, null, null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReferenceValue<Class<?>> getListenerClass() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.listenerClass == null) {
                this.refresh((ModelProperty)PROP_LISTENER_CLASS, true);
            }
            return this.listenerClass;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setListenerClass(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_LISTENER_CLASS.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_LISTENER_CLASS, true);
            if (!SapphirePartListenerDef.equal((String)this.listenerClass.getText(false), (String)value)) {
                this.resource().binding(PROP_LISTENER_CLASS).write(value);
                this.refresh((ModelProperty)PROP_LISTENER_CLASS, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            property = property.refine((IModelElement)this);
            if (property == PROP_LISTENER_CLASS && (this.listenerClass != null || force)) {
                ReferenceValue<Class<?>> oldValue = this.listenerClass;
                String val = this.resource().binding(PROP_LISTENER_CLASS).read();
                this.listenerClass = new ReferenceValue((IModelElement)this, PROP_LISTENER_CLASS, PROP_LISTENER_CLASS.encodeKeywords(val));
                this.listenerClass.init();
                boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_LISTENER_CLASS);
                if (oldValue != null) {
                    if (this.listenerClass.equals(oldValue)) {
                        this.listenerClass = oldValue;
                    }
                    if (this.listenerClass != oldValue || propertyEnabledStatusChanged) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_LISTENER_CLASS);
                    }
                }
            }
        }
    }

    public Object read(ModelProperty property) {
        if ((property = property.refine((IModelElement)this)) == PROP_LISTENER_CLASS) {
            return this.getListenerClass();
        }
        return super.read(property);
    }

    public void write(ValueProperty property, Object value) {
        if ((property = (ValueProperty)property.refine((IModelElement)this)) == PROP_LISTENER_CLASS) {
            this.setListenerClass((String)value);
            return;
        }
        super.write(property, value);
    }
}

