/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms.widgets.examples;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.window.Window;
import org.eclipse.sapphire.ui.swt.renderer.internal.formtext.SapphireFormText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.HyperlinkSettings;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.part.ViewPart;

public class SapphireFormView
extends ViewPart {
    private FormToolkit toolkit;
    private ScrolledForm form;

    public void createPartControl(Composite parent) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.form = this.toolkit.createScrolledForm(parent);
        this.form.setText("Hello, Eclipse Forms");
        TableWrapLayout layout = new TableWrapLayout();
        this.form.getBody().setLayout((Layout)layout);
        Link link2 = new Link(this.form.getBody(), 0);
        link2.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                System.out.println("SWT link selected");
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                System.out.println("SWT link SHOULD NOT BE HERE!");
            }
        });
        link2.setText("SWT link to eclipse.org: <a href=\"http://www.eclipse.org\" nowrap=\"true\">http://www.eclipse.org</a>");
        this.toolkit.adapt((Control)link2, false, false);
        TableWrapData td2 = new TableWrapData();
        td2.colspan = 2;
        link2.setLayoutData((Object)td2);
        Hyperlink link = this.toolkit.createHyperlink(this.form.getBody(), "Click here.", 64);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                System.out.println("Link activated!");
            }
        });
        link.setText("This is an example of a form that is much longer and will need to wrap.");
        layout.numColumns = 2;
        TableWrapData td = new TableWrapData();
        td.colspan = 2;
        link.setLayoutData((Object)td);
        this.toolkit.createLabel(this.form.getBody(), "Text field label:");
        Text text = this.toolkit.createText(this.form.getBody(), "");
        td = new TableWrapData(256);
        text.setLayoutData((Object)td);
        Button button = this.toolkit.createButton(this.form.getBody(), "An example of a checkbox in a form", 32);
        td = new TableWrapData();
        td.colspan = 2;
        button.setLayoutData((Object)td);
        ImageHyperlink ih = this.toolkit.createImageHyperlink(this.form.getBody(), 0);
        ih.setText("Image link with no image");
        ih = this.toolkit.createImageHyperlink(this.form.getBody(), 0);
        ih.setText("Link with image and text");
        ExpandableComposite ec = this.toolkit.createExpandableComposite(this.form.getBody(), 20);
        ImageHyperlink eci = this.toolkit.createImageHyperlink((Composite)ec, 0);
        ec.setTextClient((Control)eci);
        ec.setText("Expandable Composite title");
        String ctext = "We will now create a somewhat long text so that we can use it as content for the expandable composite. Expandable composite is used to hide or show the text using the toggle control";
        Label client = this.toolkit.createLabel((Composite)ec, ctext, 64);
        ec.setClient((Control)client);
        td = new TableWrapData();
        td.colspan = 2;
        ec.setLayoutData((Object)td);
        ec.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                SapphireFormView.this.form.reflow(true);
            }
        });
        Section section = this.toolkit.createSection(this.form.getBody(), 194);
        td = new TableWrapData(128);
        td.colspan = 2;
        section.setLayoutData((Object)td);
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                SapphireFormView.this.form.reflow(true);
            }
        });
        section.setText("Section title");
        this.toolkit.createCompositeSeparator((Composite)section);
        section.setDescription("This is the description that goes below the title");
        Composite sectionClient = this.toolkit.createComposite((Composite)section);
        sectionClient.setLayout((Layout)new GridLayout());
        button = this.toolkit.createButton(sectionClient, "Radio 1", 16);
        button = this.toolkit.createButton(sectionClient, "Radio 2", 16);
        section.setClient((Control)sectionClient);
        StringBuffer buf = new StringBuffer();
        buf.append("<form>");
        buf.append("<p>");
        buf.append("Here is some plain text for the text to render; ");
        buf.append("this text is at <a href=\"http://www.eclipse.org\" nowrap=\"true\">http://www.eclipse.org</a> web site.");
        buf.append("</p>");
        buf.append("<p>");
        buf.append("<span color=\"header\" font=\"header\">This text is in header font and color.</span>");
        buf.append("</p>");
        buf.append("<p>This line will contain some <b>bold</b> and some <span font=\"code\">source</span> text. ");
        buf.append("We can also add <img href=\"image\"/> an image. ");
        buf.append("</p>");
        buf.append("<li>A default (bulleted) list item.</li>");
        buf.append("<li>Another bullet list item.</li>");
        buf.append("<li style=\"text\" value=\"1.\">A list item with text.</li>");
        buf.append("<li style=\"text\" value=\"2.\">Another list item with text</li>");
        buf.append("<li style=\"image\" value=\"image\">List item with an image bullet</li>");
        buf.append("<li style=\"text\" bindent=\"20\" indent=\"40\" value=\"3.\">A list item with text.</li>");
        buf.append("<li style=\"text\" bindent=\"20\" indent=\"40\" value=\"4.\">A list item with text.</li>");
        buf.append("<p>     leading blanks;      more white \n\n new lines   <br/><br/><br/> \n more <b>   bb   </b>  white  . </p>");
        buf.append("</form>");
        SapphireFormText rtext = new SapphireFormText(this.form.getBody(), 0x40 | Window.getDefaultOrientation());
        rtext.marginWidth = 1;
        rtext.marginHeight = 0;
        rtext.setHyperlinkSettings((HyperlinkSettings)this.toolkit.getHyperlinkGroup());
        this.toolkit.adapt((Control)rtext, false, true);
        rtext.setMenu(parent.getMenu());
        td = new TableWrapData(128);
        td.colspan = 2;
        rtext.setLayoutData(td);
        rtext.setColor("header", this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        rtext.setFont("header", JFaceResources.getHeaderFont());
        rtext.setFont("code", JFaceResources.getTextFont());
        rtext.setText(buf.toString(), true, false);
        rtext.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                System.out.println("Link active: " + e.getHref());
            }
        });
        this.toolkit.paintBordersFor(this.form.getBody());
    }

    public void setFocus() {
        Control focusControl = this.form.getDisplay().getFocusControl();
        if (focusControl != null) {
            Composite parent = focusControl.getParent();
            while (parent != null) {
                if (parent == this.form) {
                    return;
                }
                parent = parent.getParent();
            }
        }
        this.form.setFocus();
    }

    public void dispose() {
        this.toolkit.dispose();
        super.dispose();
    }
}

