/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.renderers.swt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.LongString;
import org.eclipse.sapphire.modeling.annotations.SensitiveData;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionGroup;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphireActionHandlerFilter;
import org.eclipse.sapphire.ui.SapphireActionSystem;
import org.eclipse.sapphire.ui.SapphireActionSystemPart;
import org.eclipse.sapphire.ui.SapphirePropertyEditor;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.assist.internal.PropertyEditorAssistDecorator;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.sapphire.ui.internal.binding.TextFieldBinding;
import org.eclipse.sapphire.ui.listeners.ValuePropertyEditorListener;
import org.eclipse.sapphire.ui.renderers.swt.PropertyEditorRenderer;
import org.eclipse.sapphire.ui.renderers.swt.PropertyEditorRendererFactory;
import org.eclipse.sapphire.ui.renderers.swt.ValuePropertyEditorRenderer;
import org.eclipse.sapphire.ui.swt.renderer.GridLayoutUtil;
import org.eclipse.sapphire.ui.swt.renderer.SapphireToolBarActionPresentation;
import org.eclipse.sapphire.ui.swt.renderer.TextOverlayPainter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;

public class DefaultValuePropertyEditorRenderer
extends ValuePropertyEditorRenderer {
    private Text textField;

    public DefaultValuePropertyEditorRenderer(SapphireRenderingContext context, SapphirePropertyEditor part) {
        super(context, part);
    }

    protected void createContents(Composite parent) {
        this.createContents(parent, false);
    }

    protected Control createContents(Composite parent, final boolean suppressBrowseAction) {
        SapphirePropertyEditor part = this.getPart();
        final IModelElement element = part.getModelElement();
        ValueProperty property = (ValueProperty)part.getProperty();
        boolean isLongString = property.hasAnnotation(LongString.class);
        boolean isDeprecated = property.hasAnnotation(Deprecated.class);
        final boolean isReadOnly = property.isReadOnly() || part.getRenderingHint("read.only", false);
        boolean isSensitiveData = property.hasAnnotation(SensitiveData.class);
        SapphireActionGroup actions = this.getActions();
        final SapphireActionHandler jumpActionHandler = actions.getAction("Sapphire.Jump").getFirstActiveHandler();
        SapphireToolBarActionPresentation toolBarActionsPresentation = new SapphireToolBarActionPresentation(this.getActionPresentationManager());
        toolBarActionsPresentation.addFilter(SapphireActionSystem.createFilterByActionId("Sapphire.Assist"));
        toolBarActionsPresentation.addFilter(SapphireActionSystem.createFilterByActionId("Sapphire.Jump"));
        actions.addFilter(new SapphireActionHandlerFilter(){

            public boolean check(SapphireActionHandler handler) {
                String actionId = handler.getAction().getId();
                return !actionId.equals("Sapphire.Browse") || !isReadOnly && !suppressBrowseAction;
            }
        });
        boolean isActionsToolBarNeeded = toolBarActionsPresentation.hasActions();
        boolean isBrowseOnly = part.getRenderingHint("browse.only", false);
        boolean showLabelAbove = part.getRenderingHint("show.label.above", false);
        boolean showLabelInline = part.getRenderingHint("show.label", !showLabelAbove);
        Label label = null;
        int baseIndent = part.getLeftMarginHint() + 9;
        if (showLabelInline || showLabelAbove) {
            label = new Label(parent, 0);
            label.setText(String.valueOf(property.getLabel(false, CapitalizationType.FIRST_WORD_ONLY, true)) + ":");
            label.setLayoutData((Object)GridLayoutUtil.gdhindent(GridLayoutUtil.gdhspan(GridLayoutUtil.gdvalign(GridLayoutUtil.gd(), isLongString ? 128 : 0x1000000), showLabelAbove ? 2 : 1), baseIndent));
            this.context.adapt((Control)label);
        }
        this.setSpanBothColumns(!showLabelInline);
        Composite textFieldParent = this.createMainComposite(parent);
        this.context.adapt((Control)textFieldParent);
        int textFieldParentColumns = 1;
        if (isActionsToolBarNeeded) {
            ++textFieldParentColumns;
        }
        if (isDeprecated) {
            ++textFieldParentColumns;
        }
        textFieldParent.setLayout((Layout)GridLayoutUtil.glayout(textFieldParentColumns, 0, 0, 0, 0));
        Composite nestedComposite = new Composite(textFieldParent, 0);
        nestedComposite.setLayoutData((Object)(isLongString ? GridLayoutUtil.gdfill() : GridLayoutUtil.gdvalign(GridLayoutUtil.gdhfill(), 0x1000000)));
        nestedComposite.setLayout((Layout)GridLayoutUtil.glspacing(GridLayoutUtil.glayout(2, 0, 0), 2));
        this.context.adapt((Control)nestedComposite);
        PropertyEditorAssistDecorator decorator = this.createDecorator(nestedComposite);
        decorator.getControl().setLayoutData((Object)GridLayoutUtil.gdvalign(GridLayoutUtil.gd(), 128));
        decorator.addEditorControl((Control)nestedComposite);
        int style = (part.getRenderingHint("border", !isReadOnly) ? 2048 : 0) | (isLongString ? 578 : 0) | (isReadOnly || isBrowseOnly ? 8 : 0) | (isSensitiveData ? 0x400000 : 0);
        this.textField = new Text(nestedComposite, style);
        this.textField.setLayoutData((Object)GridLayoutUtil.gdfill());
        this.textField.setData("assist-decorator", (Object)decorator);
        this.context.adapt((Control)this.textField);
        decorator.addEditorControl((Control)this.textField);
        TextOverlayPainter.Controller textOverlayPainterController = jumpActionHandler != null ? new TextOverlayPainter.Controller(){

            public boolean isHyperlinkEnabled() {
                return jumpActionHandler.isEnabled();
            }

            public void handleHyperlinkEvent() {
                jumpActionHandler.execute(DefaultValuePropertyEditorRenderer.this.context);
            }

            public String getDefaultText() {
                return element.read(DefaultValuePropertyEditorRenderer.this.getProperty()).getDefaultText();
            }
        } : new TextOverlayPainter.Controller(){

            public String getDefaultText() {
                return element.read(DefaultValuePropertyEditorRenderer.this.getProperty()).getDefaultText();
            }
        };
        TextOverlayPainter.install(this.textField, textOverlayPainterController);
        if (isBrowseOnly) {
            final Color bgcolor = new Color((Device)this.textField.getDisplay(), 235, 235, 235);
            this.textField.setBackground(bgcolor);
            this.textField.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    bgcolor.dispose();
                }
            });
        }
        ArrayList<Object> relatedControls = new ArrayList<Object>();
        this.textField.setData("related-controls", relatedControls);
        relatedControls.add(label);
        SapphireActionSystemPart.Listener actionHandlerListener = new SapphireActionSystemPart.Listener(){

            public void handleEvent(SapphireActionSystemPart.Event event) {
                if (event.getType().equals("post-execute") && !DefaultValuePropertyEditorRenderer.this.textField.isDisposed()) {
                    DefaultValuePropertyEditorRenderer.this.textField.setFocus();
                    DefaultValuePropertyEditorRenderer.this.textField.setSelection(0, DefaultValuePropertyEditorRenderer.this.textField.getText().length());
                }
            }
        };
        for (SapphireAction action : actions.getActions()) {
            if (action.getId().equals("Sapphire.Assist")) continue;
            for (SapphireActionHandler handler : action.getActiveHandlers()) {
                handler.addListener(actionHandlerListener);
            }
        }
        if (isActionsToolBarNeeded) {
            ToolBar toolbar = new ToolBar(textFieldParent, 0x800100);
            toolbar.setLayoutData((Object)GridLayoutUtil.gdvfill());
            toolBarActionsPresentation.setToolBar(toolbar);
            toolBarActionsPresentation.render();
            this.context.adapt((Control)toolbar);
            decorator.addEditorControl((Control)toolbar);
            relatedControls.add(toolbar);
        }
        if (isDeprecated) {
            Text deprecatedLabel = new Text(textFieldParent, 8);
            deprecatedLabel.setLayoutData((Object)GridLayoutUtil.gd());
            deprecatedLabel.setText(Resources.deprecatedLabelText);
            this.context.adapt((Control)deprecatedLabel);
            deprecatedLabel.setForeground(parent.getDisplay().getSystemColor(16));
        }
        this.binding = new TextFieldBinding(this.getPart(), this.context, this.textField);
        this.textField.setData("binding", (Object)this.binding);
        this.addControl((Control)this.textField);
        List listenerClasses = part.getRenderingHint("listeners", Collections.emptyList());
        if (!listenerClasses.isEmpty()) {
            final ArrayList<ValuePropertyEditorListener> listeners = new ArrayList<ValuePropertyEditorListener>();
            for (Class cl : listenerClasses) {
                try {
                    ValuePropertyEditorListener listener = (ValuePropertyEditorListener)cl.newInstance();
                    listener.initialize(this.context, element, (ModelProperty)property);
                    listeners.add(listener);
                }
                catch (Exception e) {
                    SapphireUiFrameworkPlugin.log(e);
                }
            }
            if (!listeners.isEmpty()) {
                this.textField.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent event) {
                        for (ValuePropertyEditorListener listener : listeners) {
                            try {
                                listener.handleValueChanged();
                            }
                            catch (Exception e) {
                                SapphireUiFrameworkPlugin.log(e);
                            }
                        }
                    }
                });
            }
        }
        return this.textField;
    }

    protected boolean canExpandVertically() {
        return this.getProperty().hasAnnotation(LongString.class);
    }

    protected void handleFocusReceivedEvent() {
        this.textField.setFocus();
    }

    public static final class Factory
    extends PropertyEditorRendererFactory {
        public boolean isApplicableTo(SapphirePropertyEditor propertyEditorDefinition) {
            return propertyEditorDefinition.getProperty() instanceof ValueProperty;
        }

        public PropertyEditorRenderer create(SapphireRenderingContext context, SapphirePropertyEditor part) {
            return new DefaultValuePropertyEditorRenderer(context, part);
        }
    }

    private static final class Resources
    extends NLS {
        public static String deprecatedLabelText;

        static {
            Resources.initializeMessages((String)DefaultValuePropertyEditorRenderer.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

