/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt;

import java.util.Collections;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.help.IContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphirePartEvent;
import org.eclipse.sapphire.ui.SapphirePartListener;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.SapphireWizardPageListener;
import org.eclipse.sapphire.ui.SapphireWizardPagePart;
import org.eclipse.sapphire.ui.def.ISapphireDocumentation;
import org.eclipse.sapphire.ui.def.ISapphireDocumentationDef;
import org.eclipse.sapphire.ui.def.ISapphireDocumentationRef;
import org.eclipse.sapphire.ui.def.ISapphireWizardPageDef;
import org.eclipse.sapphire.ui.swt.renderer.GridLayoutUtil;
import org.eclipse.sapphire.ui.util.SapphireHelpSystem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class SapphireWizardPage
extends WizardPage {
    private final SapphireWizardPagePart part;

    public SapphireWizardPage(IModelElement rootModelElement, ISapphireWizardPageDef definition) {
        this((SapphireWizardPagePart)SapphirePart.create(null, rootModelElement, definition, Collections.<String, String>emptyMap()));
    }

    public SapphireWizardPage(SapphireWizardPagePart part) {
        super((String)part.getDefinition().getId().getContent());
        this.part = part;
        this.setTitle(this.part.getLabel());
        this.setDescription(this.part.getDescription());
        ImageDescriptor imageDescriptor = this.part.getImageDescriptor();
        if (imageDescriptor != null) {
            this.setImageDescriptor(imageDescriptor);
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)GridLayoutUtil.gdfill());
        composite.setLayout((Layout)GridLayoutUtil.glayout(1, 0, 0));
        Composite innerComposite = new Composite(composite, 0);
        innerComposite.setLayout((Layout)GridLayoutUtil.glayout(2, 0, 0));
        innerComposite.setLayoutData((Object)GridLayoutUtil.gdfill());
        SapphireRenderingContext context = new SapphireRenderingContext((ISapphirePart)this.part, innerComposite);
        this.part.render(context);
        final Runnable messageUpdateOperation = new Runnable(){

            public void run() {
                IStatus st = SapphireWizardPage.this.part.getValidationState();
                if (st.getSeverity() == 4) {
                    SapphireWizardPage.this.setMessage(st.getMessage(), 3);
                    SapphireWizardPage.this.setPageComplete(false);
                } else if (st.getSeverity() == 2) {
                    SapphireWizardPage.this.setMessage(st.getMessage(), 2);
                    SapphireWizardPage.this.setPageComplete(true);
                } else {
                    SapphireWizardPage.this.setMessage(null);
                    SapphireWizardPage.this.setPageComplete(true);
                }
            }
        };
        messageUpdateOperation.run();
        SapphirePartListener messageUpdateListener = new SapphirePartListener(){

            public void handleValidateStateChange(IStatus oldValidateState, IStatus newValidationState) {
                messageUpdateOperation.run();
            }
        };
        this.part.addListener(messageUpdateListener);
        ISapphireDocumentation doc = (ISapphireDocumentation)this.part.getDefinition().getDocumentation().element();
        if (doc != null) {
            ISapphireDocumentationDef docdef = null;
            docdef = doc instanceof ISapphireDocumentationDef ? (ISapphireDocumentationDef)doc : ((ISapphireDocumentationRef)doc).resolve();
            if (docdef != null) {
                SapphireHelpSystem.setHelp((Control)composite, docdef);
            }
        }
        this.setControl((Control)composite);
    }

    public final void performHelp() {
        IContext documentationContext = this.part.getDocumentationContext();
        if (documentationContext != null) {
            PlatformUI.getWorkbench().getHelpSystem().displayHelp(documentationContext);
        }
    }

    public void setVisible(boolean visible) {
        String initialFocusProperty;
        super.setVisible(visible);
        if (visible && (initialFocusProperty = (String)this.part.getDefinition().getInitialFocus().getContent()) != null) {
            this.part.setFocus(initialFocusProperty);
        }
        SapphirePartEvent event = new SapphirePartEvent(this.part);
        for (SapphirePartListener listener : this.part.getListeners()) {
            if (!(listener instanceof SapphireWizardPageListener)) continue;
            SapphireWizardPageListener wlnr = (SapphireWizardPageListener)listener;
            if (visible) {
                wlnr.handleShowPageEvent(event);
                continue;
            }
            wlnr.handleHidePageEvent(event);
        }
    }
}

