/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.renderer.actions;

import java.util.EnumSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.java.JavaTypeConstraints;
import org.eclipse.sapphire.modeling.java.JavaTypeKind;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireBrowseActionHandler;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.def.ISapphireActionHandlerDef;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;

public final class JavaTypeBrowseActionHandler
extends SapphireBrowseActionHandler {
    public static final String ID = "Sapphire.Browse.Java.Type";
    public static final String PARAM_KINDS = "kinds";
    private int browseDialogStyle;

    public void init(SapphireAction action, ISapphireActionHandlerDef def) {
        block27: {
            int count;
            EnumSet<JavaTypeKind> kinds;
            block26: {
                super.init(action, def);
                this.setId(ID);
                String paramKinds = def.getParam(PARAM_KINDS);
                kinds = EnumSet.noneOf(JavaTypeKind.class);
                if (paramKinds != null) {
                    String[] stringArray = paramKinds.split(",");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String kindString = stringArray[n2];
                        if ((kindString = kindString.trim()).equalsIgnoreCase(JavaTypeKind.CLASS.name())) {
                            kinds.add(JavaTypeKind.CLASS);
                        } else if (kindString.equalsIgnoreCase(JavaTypeKind.ABSTRACT_CLASS.name())) {
                            kinds.add(JavaTypeKind.ABSTRACT_CLASS);
                        } else if (kindString.equalsIgnoreCase(JavaTypeKind.INTERFACE.name())) {
                            kinds.add(JavaTypeKind.INTERFACE);
                        } else if (kindString.equalsIgnoreCase(JavaTypeKind.ANNOTATION.name())) {
                            kinds.add(JavaTypeKind.ANNOTATION);
                        } else if (kindString.equalsIgnoreCase(JavaTypeKind.ENUM.name())) {
                            kinds.add(JavaTypeKind.ENUM);
                        } else {
                            String msg = NLS.bind((String)Resources.typeKindNotRecognized, (Object)kindString);
                            SapphireUiFrameworkPlugin.logError(msg);
                        }
                        ++n2;
                    }
                } else {
                    JavaTypeConstraints javaTypeConstraintsAnnotation = (JavaTypeConstraints)this.getProperty().getAnnotation(JavaTypeConstraints.class);
                    if (javaTypeConstraintsAnnotation != null) {
                        JavaTypeKind[] javaTypeKindArray = javaTypeConstraintsAnnotation.kind();
                        int n = javaTypeKindArray.length;
                        int n3 = 0;
                        while (n3 < n) {
                            JavaTypeKind kind = javaTypeKindArray[n3];
                            kinds.add(kind);
                            ++n3;
                        }
                    }
                }
                this.browseDialogStyle = 256;
                count = kinds.size();
                if (count != 1) break block26;
                JavaTypeKind kind = (JavaTypeKind)kinds.iterator().next();
                switch (kind) {
                    case CLASS: {
                        this.browseDialogStyle = 2;
                        break block27;
                    }
                    case ABSTRACT_CLASS: {
                        this.browseDialogStyle = 2;
                        break block27;
                    }
                    case INTERFACE: {
                        this.browseDialogStyle = 4;
                        break block27;
                    }
                    case ANNOTATION: {
                        this.browseDialogStyle = 64;
                        break block27;
                    }
                    case ENUM: {
                        this.browseDialogStyle = 128;
                        break block27;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            if (count == 2 && (kinds.contains(JavaTypeKind.CLASS) || kinds.contains(JavaTypeKind.ABSTRACT_CLASS))) {
                if (kinds.contains(JavaTypeKind.INTERFACE)) {
                    this.browseDialogStyle = 512;
                } else if (kinds.contains(JavaTypeKind.ENUM)) {
                    this.browseDialogStyle = 1024;
                }
            }
        }
    }

    public String browse(SapphireRenderingContext context) {
        IModelElement element = this.getModelElement();
        ValueProperty property = this.getProperty();
        IProject project = (IProject)element.adapt(IProject.class);
        try {
            SelectionDialog dlg = JavaUI.createTypeDialog((Shell)context.getShell(), null, (IProject)project, (int)this.browseDialogStyle, (boolean)false);
            String title = property.getLabel(true, CapitalizationType.TITLE_STYLE, false);
            dlg.setTitle(String.valueOf(Resources.select) + title);
            if (dlg.open() == 0) {
                Object[] results = dlg.getResult();
                assert (results != null && results.length == 1);
                if (results[0] instanceof IType) {
                    return ((IType)results[0]).getFullyQualifiedName();
                }
            }
        }
        catch (JavaModelException e) {
            SapphireUiFrameworkPlugin.log(e);
        }
        return null;
    }

    private static final class Resources
    extends NLS {
        public static String select;
        public static String typeKindNotRecognized;

        static {
            Resources.initializeMessages((String)JavaTypeBrowseActionHandler.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

