/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sapphire.modeling.SapphireMultiStatus;
import org.eclipse.sapphire.ui.SapphireImageCache;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphirePartListener;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.def.ISapphireTabGroupDef;
import org.eclipse.sapphire.ui.def.ISapphireTabGroupItemDef;
import org.eclipse.sapphire.ui.swt.renderer.GridLayoutUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class SapphireTabGroup
extends SapphirePart {
    private List<SapphirePart> tabParts;

    protected void init() {
        super.init();
        this.tabParts = new ArrayList<SapphirePart>();
        for (ISapphireTabGroupItemDef tabDef : ((ISapphireTabGroupDef)this.definition).getTabs()) {
            SapphirePart tabPart = SapphireTabGroup.create(this, this.getModelElement(), tabDef, null);
            this.tabParts.add(tabPart);
            SapphirePartListener tabPartListener = new SapphirePartListener(){

                public void handleValidateStateChange(IStatus oldValidateState, IStatus newValidationState) {
                    SapphireTabGroup.this.updateValidationState();
                }
            };
            tabPart.addListener(tabPartListener);
        }
    }

    public void render(SapphireRenderingContext context) {
        boolean expandVertically = Boolean.valueOf(this.definition.getHint("expand.vertically"));
        TabFolder tabGroup = new TabFolder(context.getComposite(), 128);
        tabGroup.setLayoutData((Object)GridLayoutUtil.gdhspan(expandVertically ? GridLayoutUtil.gdfill() : GridLayoutUtil.gdhfill(), 2));
        context.adapt((Control)tabGroup);
        for (final SapphirePart tabPart : this.tabParts) {
            Composite tabControl = new Composite((Composite)tabGroup, 0);
            tabControl.setLayout((Layout)GridLayoutUtil.glayout(2, 0, 0));
            final TabItem tab = new TabItem(tabGroup, 0);
            tab.setText(((ISapphireTabGroupItemDef)tabPart.getDefinition()).getLabel().getLocalizedText());
            tab.setControl((Control)tabControl);
            SapphirePartListener tabPartListener = new SapphirePartListener(){

                public void handleValidateStateChange(IStatus oldValidateState, IStatus newValidationState) {
                    SapphireTabGroup.this.updateTabImage(tab, tabPart, newValidationState);
                }
            };
            tabPart.addListener(tabPartListener);
            this.updateTabImage(tab, tabPart, tabPart.getValidationState());
            tabPart.render(new SapphireRenderingContext(tabPart, context, tabControl));
        }
    }

    private void updateTabImage(TabItem tab, SapphirePart tabPart, IStatus newValidationState) {
        int severity = newValidationState.getSeverity();
        ImageDescriptor imageDescriptor = (ImageDescriptor)((ISapphireTabGroupItemDef)tabPart.getDefinition()).getImagePath().resolve();
        if (imageDescriptor == null) {
            imageDescriptor = SapphireImageCache.OBJECT_LEAF_NODE;
        }
        Image image = this.getImageCache().getImage(imageDescriptor, severity);
        tab.setImage(image);
    }

    protected IStatus computeValidationState() {
        SapphireMultiStatus st = new SapphireMultiStatus();
        for (SapphirePart tabPart : this.tabParts) {
            st.add(tabPart.getValidationState());
        }
        return st;
    }

    public void dispose() {
        super.dispose();
        for (SapphirePart tabPart : this.tabParts) {
            tabPart.dispose();
        }
    }
}

