/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import java.util.HashMap;
import java.util.List;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.EditFailedException;
import org.eclipse.sapphire.modeling.ElementProperty;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ImpliedElementProperty;
import org.eclipse.sapphire.modeling.ModelElementHandle;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelPath;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelPropertyChangeEvent;
import org.eclipse.sapphire.modeling.ModelPropertyListener;
import org.eclipse.sapphire.modeling.localization.LabelTransformer;
import org.eclipse.sapphire.ui.SapphirePageBook;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.def.ISapphireCompositeDef;
import org.eclipse.sapphire.ui.def.ISapphireLabelDef;
import org.eclipse.sapphire.ui.def.ISapphireUiDef;
import org.eclipse.sapphire.ui.def.ISapphireWithDirectiveDef;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.sapphire.ui.internal.binding.RadioButtonsGroup;
import org.eclipse.sapphire.ui.swt.renderer.GridLayoutUtil;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public final class SapphireWithDirective
extends SapphirePageBook {
    private IModelElement modelElementForChildParts;
    private ElementProperty property;

    protected void init() {
        ISapphireWithDirectiveDef def = (ISapphireWithDirectiveDef)this.definition;
        this.property = (ElementProperty)this.resolve(def.getProperty().getText());
        super.init();
        this.setExposePageValidationState(true);
        this.updateCurrentPage(true);
    }

    protected ISapphireCompositeDef initDefaultPageDef() {
        ISapphireUiDef root = (ISapphireUiDef)ISapphireUiDef.TYPE.instantiate();
        ISapphireCompositeDef composite = (ISapphireCompositeDef)root.getCompositeDefs().addNewElement();
        ISapphireLabelDef label = (ISapphireLabelDef)composite.getContent().addNewElement(ISapphireLabelDef.TYPE);
        label.setText(Resources.noAdditionalPropertiesMessage);
        return composite;
    }

    public ElementProperty getProperty() {
        return this.property;
    }

    public void render(final SapphireRenderingContext context) {
        ISapphireWithDirectiveDef def = (ISapphireWithDirectiveDef)this.definition;
        Composite composite = new Composite(context.getComposite(), 0);
        composite.setLayoutData((Object)GridLayoutUtil.gdhspan(GridLayoutUtil.gdhfill(), 2));
        composite.setLayout((Layout)GridLayoutUtil.glayout(1, 0, 0));
        context.adapt((Control)composite);
        if (!(this.property instanceof ImpliedElementProperty)) {
            ModelPropertyListener modelPropertyListener;
            List allPossibleTypes = this.property.getAllPossibleTypes();
            final IModelElement element = this.getModelElement();
            final ElementProperty property = this.property;
            if (allPossibleTypes.size() == 1) {
                final Button masterCheckBox = new Button(composite, 32);
                masterCheckBox.setLayoutData((Object)GridLayoutUtil.gdhindent(GridLayoutUtil.gdhspan(GridLayoutUtil.gdhfill(), 2), 10));
                masterCheckBox.setText(LabelTransformer.transform((String)def.getLabel().getLocalizedText(), (CapitalizationType)CapitalizationType.FIRST_WORD_ONLY, (boolean)true));
                context.adapt((Control)masterCheckBox);
                modelPropertyListener = new ModelPropertyListener(){

                    public void handlePropertyChangedEvent(ModelPropertyChangeEvent event) {
                        IModelElement subModelElement = element.read(property).element();
                        masterCheckBox.setSelection(subModelElement != null);
                        masterCheckBox.setEnabled(element.isPropertyEnabled((ModelProperty)property));
                        if (subModelElement != null) {
                            context.setHelp((Control)masterCheckBox, subModelElement, (ModelProperty)property);
                        }
                    }
                };
                masterCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        block4: {
                            try {
                                ModelElementHandle handle = element.read(property);
                                if (masterCheckBox.getSelection()) {
                                    handle.element(true);
                                } else {
                                    handle.remove();
                                }
                            }
                            catch (Exception e) {
                                EditFailedException editFailedException = EditFailedException.findAsCause((Throwable)e);
                                if (editFailedException != null) break block4;
                                SapphireUiFrameworkPlugin.log(e);
                            }
                        }
                    }
                });
            } else {
                final RadioButtonsGroup radioButtonsGroup = new RadioButtonsGroup(context, composite, false);
                radioButtonsGroup.setLayoutData(GridLayoutUtil.gdhindent(GridLayoutUtil.gdhspan(GridLayoutUtil.gdhfill(), 2), 10));
                context.adapt((Control)radioButtonsGroup);
                final Button noneButton = radioButtonsGroup.addRadioButton(Resources.noneRadioButton);
                final HashMap<ModelElementType, Button> typeToButton = new HashMap<ModelElementType, Button>();
                final HashMap<Button, ModelElementType> buttonToType = new HashMap<Button, ModelElementType>();
                for (ModelElementType type : allPossibleTypes) {
                    String label = type.getLabel(true, CapitalizationType.FIRST_WORD_ONLY, false);
                    Button button = radioButtonsGroup.addRadioButton(label);
                    typeToButton.put(type, button);
                    buttonToType.put(button, type);
                }
                modelPropertyListener = new ModelPropertyListener(){

                    public void handlePropertyChangedEvent(ModelPropertyChangeEvent event) {
                        IModelElement subModelElement = element.read(property).element();
                        Button button = subModelElement == null ? noneButton : (Button)typeToButton.get(subModelElement.getModelElementType());
                        if (radioButtonsGroup.getSelection() != button) {
                            radioButtonsGroup.setSelection(button);
                        }
                        radioButtonsGroup.setEnabled(element.isPropertyEnabled((ModelProperty)property));
                    }
                };
                radioButtonsGroup.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        block4: {
                            try {
                                ModelElementHandle handle = element.read(property);
                                Button button = radioButtonsGroup.getSelection();
                                if (handle.element() != null && button == noneButton) {
                                    handle.remove();
                                } else {
                                    ModelElementType type = (ModelElementType)buttonToType.get(button);
                                    handle.element(true, type);
                                }
                            }
                            catch (Exception e) {
                                EditFailedException editFailedException = EditFailedException.findAsCause((Throwable)e);
                                if (editFailedException != null) break block4;
                                SapphireUiFrameworkPlugin.log(e);
                            }
                        }
                    }
                });
            }
            Composite separatorComposite = new Composite(composite, 0);
            separatorComposite.setLayoutData((Object)GridLayoutUtil.gdhindent(GridLayoutUtil.gdhspan(GridLayoutUtil.gdhfill(), 2), 10));
            separatorComposite.setLayout((Layout)GridLayoutUtil.glayout(1, 0, 5));
            context.adapt((Control)separatorComposite);
            Label separator = new Label(separatorComposite, 258);
            separator.setLayoutData((Object)GridLayoutUtil.gdhfill());
            modelPropertyListener.handlePropertyChangedEvent(null);
            element.addListener(modelPropertyListener, property.getName());
            composite.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    element.removeListener(modelPropertyListener, property.getName());
                }
            });
        }
        super.render(new SapphireRenderingContext(this, context, composite));
    }

    protected void handleModelElementChange(ModelPropertyChangeEvent event) {
        super.handleModelElementChange(event);
        if (event.getProperty().getName().equals(this.property.getName())) {
            this.updateCurrentPage(false);
        }
    }

    protected Object parsePageKey(String pageKeyString) {
        ISapphireUiDef rootdef = (ISapphireUiDef)this.definition.nearest(ISapphireUiDef.class);
        Class<?> cl = rootdef.resolveClass(pageKeyString);
        return SapphirePageBook.ClassBasedKey.create(cl);
    }

    private void updateCurrentPage(boolean force) {
        IModelElement element = this.getModelElement();
        IModelElement child = this.property instanceof ImpliedElementProperty ? element.read((ImpliedElementProperty)this.property) : element.read(this.property).element();
        if (force || this.modelElementForChildParts != child) {
            this.modelElementForChildParts = child;
            if (this.modelElementForChildParts != null) {
                this.changePage(this.modelElementForChildParts, SapphirePageBook.ClassBasedKey.create(this.modelElementForChildParts));
            } else {
                this.changePage(element, null);
            }
        }
    }

    public boolean setFocus(ModelPath path) {
        IModelElement element;
        String propertyName;
        ModelPath.Segment head = path.head();
        if (head instanceof ModelPath.PropertySegment && (propertyName = ((ModelPath.PropertySegment)head).getPropertyName()).equals(this.property.getName()) && (element = this.getModelElement()).isPropertyEnabled((ModelProperty)this.property) && element.read(this.property) != null) {
            super.setFocus(path.tail());
        }
        return false;
    }

    private static final class Resources
    extends NLS {
        public static String noneRadioButton;
        public static String noAdditionalPropertiesMessage;

        static {
            Resources.initializeMessages((String)SapphireWithDirective.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

